# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CertArgs', 'Cert']

@pulumi.input_type
class CertArgs:
    def __init__(__self__, *,
                 app: pulumi.Input[str],
                 hostname: pulumi.Input[str]):
        """
        The set of arguments for constructing a Cert resource.
        :param pulumi.Input[str] app: The App this resource will be created in
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def app(self) -> pulumi.Input[str]:
        """
        The App this resource will be created in
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: pulumi.Input[str]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)


@pulumi.input_type
class _CertState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input[str]] = None,
                 check: Optional[pulumi.Input[bool]] = None,
                 dns_validation_hostname: Optional[pulumi.Input[str]] = None,
                 dns_validation_instructions: Optional[pulumi.Input[str]] = None,
                 dns_validation_target: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cert resources.
        :param pulumi.Input[str] app: The App this resource will be created in
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if check is not None:
            pulumi.set(__self__, "check", check)
        if dns_validation_hostname is not None:
            pulumi.set(__self__, "dns_validation_hostname", dns_validation_hostname)
        if dns_validation_instructions is not None:
            pulumi.set(__self__, "dns_validation_instructions", dns_validation_instructions)
        if dns_validation_target is not None:
            pulumi.set(__self__, "dns_validation_target", dns_validation_target)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[str]]:
        """
        The App this resource will be created in
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter
    def check(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "check")

    @check.setter
    def check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "check", value)

    @property
    @pulumi.getter(name="dnsValidationHostname")
    def dns_validation_hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dns_validation_hostname")

    @dns_validation_hostname.setter
    def dns_validation_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_validation_hostname", value)

    @property
    @pulumi.getter(name="dnsValidationInstructions")
    def dns_validation_instructions(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dns_validation_instructions")

    @dns_validation_instructions.setter
    def dns_validation_instructions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_validation_instructions", value)

    @property
    @pulumi.getter(name="dnsValidationTarget")
    def dns_validation_target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dns_validation_target")

    @dns_validation_target.setter
    def dns_validation_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_validation_target", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)


class Cert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Fly certificate resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app: The App this resource will be created in
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Fly certificate resource

        :param str resource_name: The name of the resource.
        :param CertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertArgs.__new__(CertArgs)

            if app is None and not opts.urn:
                raise TypeError("Missing required property 'app'")
            __props__.__dict__["app"] = app
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["check"] = None
            __props__.__dict__["dns_validation_hostname"] = None
            __props__.__dict__["dns_validation_instructions"] = None
            __props__.__dict__["dns_validation_target"] = None
        super(Cert, __self__).__init__(
            'fly:index/cert:Cert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[str]] = None,
            check: Optional[pulumi.Input[bool]] = None,
            dns_validation_hostname: Optional[pulumi.Input[str]] = None,
            dns_validation_instructions: Optional[pulumi.Input[str]] = None,
            dns_validation_target: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None) -> 'Cert':
        """
        Get an existing Cert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app: The App this resource will be created in
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertState.__new__(_CertState)

        __props__.__dict__["app"] = app
        __props__.__dict__["check"] = check
        __props__.__dict__["dns_validation_hostname"] = dns_validation_hostname
        __props__.__dict__["dns_validation_instructions"] = dns_validation_instructions
        __props__.__dict__["dns_validation_target"] = dns_validation_target
        __props__.__dict__["hostname"] = hostname
        return Cert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def app(self) -> pulumi.Output[str]:
        """
        The App this resource will be created in
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter
    def check(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "check")

    @property
    @pulumi.getter(name="dnsValidationHostname")
    def dns_validation_hostname(self) -> pulumi.Output[str]:
        return pulumi.get(self, "dns_validation_hostname")

    @property
    @pulumi.getter(name="dnsValidationInstructions")
    def dns_validation_instructions(self) -> pulumi.Output[str]:
        return pulumi.get(self, "dns_validation_instructions")

    @property
    @pulumi.getter(name="dnsValidationTarget")
    def dns_validation_target(self) -> pulumi.Output[str]:
        return pulumi.get(self, "dns_validation_target")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        return pulumi.get(self, "hostname")

