# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'MachineMount',
    'MachineService',
    'MachineServicePort',
]

@pulumi.output_type
class MachineMount(dict):
    def __init__(__self__, *,
                 path: str,
                 volume: str):
        """
        :param str path: Path for volume to be mounted on vm, ex: `/data`
        :param str volume: ID of volume
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path for volume to be mounted on vm, ex: `/data`
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def volume(self) -> str:
        """
        ID of volume
        """
        return pulumi.get(self, "volume")


@pulumi.output_type
class MachineService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalPort":
            suggest = "internal_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 internal_port: int,
                 ports: Sequence['outputs.MachineServicePort'],
                 protocol: str):
        """
        :param int internal_port: Port the machine listens on
        :param Sequence['MachineServicePortArgs'] ports: How the port is exposed
        :param str protocol: `udp` or `tcp`
        """
        pulumi.set(__self__, "internal_port", internal_port)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> int:
        """
        Port the machine listens on
        """
        return pulumi.get(self, "internal_port")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.MachineServicePort']:
        """
        How the port is exposed
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        `udp` or `tcp`
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class MachineServicePort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceHttps":
            suggest = "force_https"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MachineServicePort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MachineServicePort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MachineServicePort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 force_https: Optional[bool] = None,
                 handlers: Optional[Sequence[str]] = None):
        """
        :param int port: Mapped external port number
        :param bool force_https: Automatically redirect to HTTPS on "http" handler
        :param Sequence[str] handlers: How the edge should process requests; ex empty, or `tls` to attach app's certificate
        """
        pulumi.set(__self__, "port", port)
        if force_https is not None:
            pulumi.set(__self__, "force_https", force_https)
        if handlers is not None:
            pulumi.set(__self__, "handlers", handlers)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Mapped external port number
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="forceHttps")
    def force_https(self) -> Optional[bool]:
        """
        Automatically redirect to HTTPS on "http" handler
        """
        return pulumi.get(self, "force_https")

    @property
    @pulumi.getter
    def handlers(self) -> Optional[Sequence[str]]:
        """
        How the edge should process requests; ex empty, or `tls` to attach app's certificate
        """
        return pulumi.get(self, "handlers")


