# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 fly_api_token: Optional[pulumi.Input[str]] = None,
                 fly_http_endpoint: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] fly_api_token: fly.io api token. If not set checks env for FLY_API_TOKEN
        :param pulumi.Input[str] fly_http_endpoint: Where the provider should look to find the fly http endpoint
        """
        if fly_api_token is not None:
            pulumi.set(__self__, "fly_api_token", fly_api_token)
        if fly_http_endpoint is not None:
            pulumi.set(__self__, "fly_http_endpoint", fly_http_endpoint)

    @property
    @pulumi.getter(name="flyApiToken")
    def fly_api_token(self) -> Optional[pulumi.Input[str]]:
        """
        fly.io api token. If not set checks env for FLY_API_TOKEN
        """
        return pulumi.get(self, "fly_api_token")

    @fly_api_token.setter
    def fly_api_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fly_api_token", value)

    @property
    @pulumi.getter(name="flyHttpEndpoint")
    def fly_http_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Where the provider should look to find the fly http endpoint
        """
        return pulumi.get(self, "fly_http_endpoint")

    @fly_http_endpoint.setter
    def fly_http_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fly_http_endpoint", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fly_api_token: Optional[pulumi.Input[str]] = None,
                 fly_http_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the fly package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fly_api_token: fly.io api token. If not set checks env for FLY_API_TOKEN
        :param pulumi.Input[str] fly_http_endpoint: Where the provider should look to find the fly http endpoint
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the fly package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fly_api_token: Optional[pulumi.Input[str]] = None,
                 fly_http_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["fly_api_token"] = fly_api_token
            __props__.__dict__["fly_http_endpoint"] = fly_http_endpoint
        super(Provider, __self__).__init__(
            'fly',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="flyApiToken")
    def fly_api_token(self) -> pulumi.Output[Optional[str]]:
        """
        fly.io api token. If not set checks env for FLY_API_TOKEN
        """
        return pulumi.get(self, "fly_api_token")

    @property
    @pulumi.getter(name="flyHttpEndpoint")
    def fly_http_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Where the provider should look to find the fly http endpoint
        """
        return pulumi.get(self, "fly_http_endpoint")

