from PIL import Image
import cairo
import math
import numpy as np
from art_generator.canvas import Canvas
from art_generator.circle import Circle
from art_generator.context import Context


def do_stuff():
    WIDTH, HEIGHT = 256, 256

    surface = cairo.ImageSurface(cairo.FORMAT_ARGB32, WIDTH, HEIGHT)
    ctx = cairo.Context(surface)

    ctx.scale(WIDTH, HEIGHT)  # Normalizing the canvas

    pat = cairo.LinearGradient(0.0, 0.0, 0.0, 1.0)
    pat.add_color_stop_rgba(1, 0.7, 0, 0, 0.5)  # First stop, 50% opacity
    pat.add_color_stop_rgba(0, 0.9, 0.7, 0.2, 1)  # Last stop, 100% opacity

    ctx.rectangle(0, 0, 1, 1)  # Rectangle(x0, y0, x1, y1)
    ctx.set_source(pat)
    ctx.fill()

    ctx.translate(0.1, 0.1)  # Changing the current transformation matrix

    ctx.move_to(0, 0)
    # Arc(cx, cy, radius, start_angle, stop_angle)
    ctx.arc(0.2, 0.1, 0.1, -math.pi / 2, 0)
    ctx.line_to(0.5, 0.1)  # Line to (x,y)
    # Curve(x1, y1, x2, y2, x3, y3)
    ctx.curve_to(0.5, 0.2, 0.5, 0.4, 0.2, 0.8)
    ctx.close_path()

    ctx.set_source_rgb(0.3, 0.2, 0.5)  # Solid color
    ctx.set_line_width(0.02)
    ctx.stroke()

    # surface.write_to_png("example.png")  # Output to PNG
    buf = surface.get_data()
    return np.ndarray(shape=(WIDTH, HEIGHT, 4), dtype=np.uint8, buffer=buf)


def blank_image():
    canvas = Canvas(256, 256)
    return canvas.export()


def cairo_image():
    return Image.fromarray(do_stuff())


def layer():
    canvas = Canvas(256, 256)
    canvas.layer(do_stuff())
    return canvas.export()


def circle():
    context = Context(500, 500)
    Circle(context, 200, 200, 100).draw()
    return Image.fromarray(context.export())
