"""`StepImplementer` for the `container-image-static-compliance-scan` step using OpenSCAP.

Convenience wrapper for the `OpenSCAPGeneric` step implementer so that users
can specify `OpenSCAP` for the `container-image-static-compliance-scan`.

Step Configuration
------------------
Step configuration expected as input to this step.
Could come from:

  * static configuration
  * runtime configuration
  * previous step results

 Configuration Key             | Required? | Default | Description
-------------------------------|-----------|---------|-----------
`container-image-tag`          | Yes       |         | Container image tag to scan.
`oscap-input-definitions-uri`  | Yes       |         | URI to the OpenSCAP definitions file \
                                                       to do the evaluation with. \
                                                       Must use protocol file://|http://|https://. \
                                                       Must have file extension .xml|.bz2.
`oscap-profile`                | No        |         | OpenSCAP profile to evaluate.
`oscap-tailoring-uri`          | No        |         | URI to OpenSCAP tailoring file \
                                                       to do the evaluation with. \
                                                       Must use protocol file://|http://|https://. \
                                                       Must have file extension .xml|.bz2.
`oscap-fetch-remote-resources` | No        | True    | For Source DataStream and XCCDF files \
                                                       that have remote references fetch them if \
                                                       True, else don't. \
                                                       <br/><br/> \
                                                       **WARNING**: evaluations will not be \
                                                       complete if input defintions require \
                                                       remote resources and this is not True. \
                                                       For disconnected environments the remote \
                                                       internal mirror.
`[container-image-pull-registry-type, container-image-registry-type]` \
                               | Yes       | 'containers-storage:' \
                                                     | \
                                           Container repository type for the pull image source. \
                                           See https://github.com/containers/skopeo for valid \
                                           options.

Result Artifacts
----------------
Results artifacts output by this step.

Result Artifact Key | Description
--------------------|------------
`html-report`       | HTML report generated by oscap eval
`xml-report`        | XML report generated by oscap eval
`stdout-report`     | stdout report generated by oscap eval
"""

from ploigos_step_runner.step_implementers.shared.openscap_generic import OpenSCAPGeneric

REQUIRED_CONFIG_OR_PREVIOUS_STEP_RESULT_ARTIFACT_KEYS = [
    'oscap-profile'
]

class OpenSCAP(OpenSCAPGeneric):
    """`StepImplementer` for the `container-image-static-compliance-scan` step using OpenSCAP.

    Convenience wrapper for the `OpenSCAPGeneric` step implementer so that users
    can specify `OpenSCAP` for the `container-image-static-compliance-scan`.

    Since compliance scans with oscap require a profile, also extends to sets the `oscap-profile`
    as a required configuration key.
    """

    @staticmethod
    def _required_config_or_result_keys():
        """Getter for step configuration or previous step result artifacts that are required before
        running this step.

        See Also
        --------
        _validate_required_config_or_previous_step_result_artifact_keys

        Returns
        -------
        array_list
            Array of configuration keys or previous step result artifacts
            that are required before running the step.
        """
        return REQUIRED_CONFIG_OR_PREVIOUS_STEP_RESULT_ARTIFACT_KEYS + \
            OpenSCAPGeneric._required_config_or_result_keys()
