from http.server import BaseHTTPRequestHandler
from typing import Any, Callable, Dict, List, Optional as Opt, Tuple
from vtelem.registry import DEFAULT_INDENT as DEFAULT_INDENT

RequestHandle = Callable[[BaseHTTPRequestHandler, dict], Tuple[bool, str]]
LOG: Any

class HttpRequestMapper:
    requests: Any
    handle_data: Any
    def __init__(self): ...
    def get_handle(self, request_type: str, path: str) -> Tuple[Opt[RequestHandle], Opt[dict]]: ...
    def add_handler(self, request_type: str, path: str, handle: RequestHandle, description: str, data: dict = ..., response_type: str = ..., charset: str = ...) -> None: ...

class MapperAwareRequestHandler(BaseHTTPRequestHandler):
    def log_message(self, fmt, *args) -> None: ...
    def do_HEAD(self) -> None: ...
    def do_GET(self) -> None: ...
    def do_POST(self) -> None: ...

def parse_content_type(value: str) -> Opt[dict]: ...
def get_multipart_boundary(content_type: dict) -> Opt[str]: ...
def parse_request_lines(lines: List[str]) -> dict: ...
def dequote(data: str) -> str: ...
def parse_multipart_data(boundary: str, data: str) -> List[Dict[str, List[str]]]: ...
def parse_content_disposition(data: str) -> dict: ...
def get_post_request_data(request: BaseHTTPRequestHandler) -> dict: ...
