from enum import IntEnum
from typing import Any, Callable, Dict, Iterator, Optional, Type
from vtelem.classes import DEFAULTS as DEFAULTS
from vtelem.classes.serdes import ObjectData as ObjectData, ObjectMap as ObjectMap, Serializable as Serializable, SerializableParams as SerializableParams
from vtelem.classes.type_primitive import TypePrimitive as TypePrimitive, new_default as new_default
from vtelem.enums.primitive import get_size as get_size
from vtelem.names import class_to_snake as class_to_snake, to_snake as to_snake
from vtelem.schema.manager import SchemaManager as SchemaManager

IntStrMap = Dict[int, str]

def coerce_enum(values: IntStrMap) -> IntStrMap: ...
def reverse_map(enum_map: IntStrMap) -> Dict[str, Optional[int]]: ...
def user_enum_data(name: str, values: IntStrMap, default: str = ...) -> ObjectData: ...

class UserEnum(Serializable):
    strings: Any
    def init(self, data: ObjectData) -> None: ...
    @property
    def default(self) -> str: ...
    def __iter__(self) -> Iterator[str]: ...
    def get_str(self, val: int) -> str: ...
    def get_value(self, val: str) -> int: ...
    def get_primitive(self, value: str, changed_cb: Callable = ...) -> TypePrimitive: ...

def user_enum(name: str, values: IntStrMap, default: str = ..., manager: SchemaManager = ...) -> UserEnum: ...
def from_enum(enum_class: Type[IntEnum]) -> UserEnum: ...
