from typing import Any, Callable, Dict, Iterator, List, Optional, Tuple
from vtelem.classes.data_cache import DataCache as DataCache
from vtelem.frame.fields import to_parsed as to_parsed
from vtelem.types.frame import FrameType as FrameType, MessageType as MessageType, ParsedFrame as ParsedFrame

MessageCallback = Callable[[MessageType, int, bytes], None]
CallbackMap = Dict[MessageType, List[MessageCallback]]

class MessageDispatcher:
    message_callbacks: Any
    def __init__(self, initial_callbacks: CallbackMap = ...) -> None: ...
    def add_callback(self, mtype: MessageType, callback: MessageCallback) -> None: ...
    def service_callbacks(self, mtype: MessageType, number: int, data: bytes) -> None: ...

class MessageCache(DataCache, MessageDispatcher):
    fragment_data: Any
    fragment_dir: Any
    def __init__(self, cache_dir: str, initial_callbacks: CallbackMap = ...) -> None: ...
    def service_all_callbacks(self) -> None: ...
    def load_fragments(self, fragment_dir: str) -> None: ...
    def store_fragment(self, mtype: MessageType, crc: int, fragment_index: int, data: bytes) -> None: ...
    def complete(self, mtype: MessageType) -> List[int]: ...
    def content(self, mtype: MessageType, crc: int) -> Optional[Tuple[int, bytes]]: ...
    def content_str(self, mtype: MessageType, crc: int) -> Optional[Tuple[int, str]]: ...
    def ingest(self, frame: ParsedFrame) -> None: ...

def from_temp_dir(initial_callbacks: CallbackMap = ...) -> Iterator[MessageCache]: ...
