from json import JSONEncoder
from typing import Any, Sequence, Tuple, Type
from vtelem.classes.serdes import ObjectData as ObjectData, Serializable as Serializable
from vtelem.frame.framer import Framer as Framer
from vtelem.frame.message import MessageFrame as MessageFrame, frames_required as frames_required
from vtelem.types.frame import MessageType as MessageType

SerializedFrames = Tuple[Sequence[MessageFrame], int]

class MessageFramer(Framer):
    message_numbers: Any
    def __init__(self, mtu: int, app_id_basis: float = ..., use_crc: bool = ...) -> None: ...
    def message_frame(self, time: float = ...) -> MessageFrame: ...
    def serialize_message(self, message: bytes, time: float = ..., message_type: MessageType = ...) -> SerializedFrames: ...
    def serialize_message_str(self, message: str, time: float = ..., message_type: MessageType = ...) -> SerializedFrames: ...
    def serialize_message_json(self, message: ObjectData, time: float = ..., message_type: MessageType = ..., cls: Type[JSONEncoder] = ..., **dump_kwargs) -> SerializedFrames: ...
    def serialize_object(self, message: Serializable, time: float = ..., message_type: MessageType = ..., **dump_kwargs) -> SerializedFrames: ...
