from io import BytesIO
from pathlib import Path
from queue import Queue
from threading import Semaphore
from typing import Any, Callable, Iterator, Tuple
from vtelem.classes import DEFAULTS as DEFAULTS
from vtelem.classes.metered_queue import MAX_SIZE as MAX_SIZE, create as create
from vtelem.classes.time_entity import LockEntity as LockEntity
from vtelem.classes.type_primitive import new_default as new_default
from vtelem.daemon.queue import QueueDaemon as QueueDaemon
from vtelem.frame.channel import ChannelFrame as ChannelFrame
from vtelem.mtu import Host as Host
from vtelem.telemetry.environment import TelemetryEnvironment as TelemetryEnvironment

LOG: Any

class StreamWriter(QueueDaemon):
    curr_id: int
    queue_id: int
    streams: Any
    stream_attrs: Any
    stream_closers: Any
    queues: Any
    error_handle: Any
    def __init__(self, name: str, frame_queue: Queue, error_handle: Callable[[int], None] = ..., env: TelemetryEnvironment = ..., time_keeper: Any = ...): ...
    @property
    def overhead(self) -> int: ...
    def get_queue(self, name: str = ..., maxsize: int = ...) -> Queue: ...
    def add_queue(self, queue: Queue) -> int: ...
    def registered_queue(self, name: str = ..., maxsize: int = ...) -> Tuple[int, Queue]: ...
    def add_stream(self, stream: BytesIO, stream_closer: Callable = ..., flush: bool = ...) -> int: ...
    def stream_added(self, stream: BytesIO, stream_closer: Callable = ..., flush: bool = ...) -> Iterator[None]: ...
    def add_file(self, path: Path, flush: bool = ..., append: bool = ...) -> Iterator[None]: ...
    def add_semaphore_stream(self, stream: BytesIO) -> Tuple[int, Semaphore]: ...
    def remove_stream(self, stream_id: int, call_closer: bool = ...) -> bool: ...
    def remove_queue(self, queue_id: int, inject_none: bool = ...) -> bool: ...

class QueueClientManager(LockEntity):
    name: Any
    writer: Any
    active_client_queues: Any
    def __init__(self, name: str, writer: StreamWriter) -> None: ...
    def add_client_queue(self, addr: Host = ...) -> Tuple[int, Queue]: ...
    def close_clients(self) -> int: ...

def default_writer(name: str = ..., error_handle: Callable[[int], None] = ..., env: TelemetryEnvironment = ..., time_keeper: Any = ..., maxsize: int = ..., queue: Queue = ...) -> Tuple[StreamWriter, Queue]: ...
