from ..models import State, Chamber, District

PR = State(
    name="Puerto Rico",
    abbr="PR",
    capital="San Juan",
    capital_tz="America/Puerto_Rico",
    fips="72",
    unicameral=False,
    legislature_name="Legislative Assembly of Puerto Rico",
    legislature_organization_id="ocd-organization/172e46ae-bd24-406a-a754-e243e5fab319",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/c0dbab0c-4fe6-464e-aa44-6bd2cf725c55",
    division_id="ocd-division/country:us/territory:pr",
    jurisdiction_id="ocd-jurisdiction/country:us/territory:pr/government",
    url="http://www.oslpr.org/",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/f932d329-15b2-4385-9d7d-d4b8a7ed8495",
        num_seats=51,
        title="Representative",
        districts=[
            District("1", "lower", "ocd-division/country:us/territory:pr/sldl:1", 1),
            District("2", "lower", "ocd-division/country:us/territory:pr/sldl:2", 1),
            District("3", "lower", "ocd-division/country:us/territory:pr/sldl:3", 1),
            District("4", "lower", "ocd-division/country:us/territory:pr/sldl:4", 1),
            District("5", "lower", "ocd-division/country:us/territory:pr/sldl:5", 1),
            District("6", "lower", "ocd-division/country:us/territory:pr/sldl:6", 1),
            District("7", "lower", "ocd-division/country:us/territory:pr/sldl:7", 1),
            District("8", "lower", "ocd-division/country:us/territory:pr/sldl:8", 1),
            District("9", "lower", "ocd-division/country:us/territory:pr/sldl:9", 1),
            District("10", "lower", "ocd-division/country:us/territory:pr/sldl:10", 1),
            District("11", "lower", "ocd-division/country:us/territory:pr/sldl:11", 1),
            District("12", "lower", "ocd-division/country:us/territory:pr/sldl:12", 1),
            District("13", "lower", "ocd-division/country:us/territory:pr/sldl:13", 1),
            District("14", "lower", "ocd-division/country:us/territory:pr/sldl:14", 1),
            District("15", "lower", "ocd-division/country:us/territory:pr/sldl:15", 1),
            District("16", "lower", "ocd-division/country:us/territory:pr/sldl:16", 1),
            District("17", "lower", "ocd-division/country:us/territory:pr/sldl:17", 1),
            District("18", "lower", "ocd-division/country:us/territory:pr/sldl:18", 1),
            District("19", "lower", "ocd-division/country:us/territory:pr/sldl:19", 1),
            District("20", "lower", "ocd-division/country:us/territory:pr/sldl:20", 1),
            District("21", "lower", "ocd-division/country:us/territory:pr/sldl:21", 1),
            District("22", "lower", "ocd-division/country:us/territory:pr/sldl:22", 1),
            District("23", "lower", "ocd-division/country:us/territory:pr/sldl:23", 1),
            District("24", "lower", "ocd-division/country:us/territory:pr/sldl:24", 1),
            District("25", "lower", "ocd-division/country:us/territory:pr/sldl:25", 1),
            District("26", "lower", "ocd-division/country:us/territory:pr/sldl:26", 1),
            District("27", "lower", "ocd-division/country:us/territory:pr/sldl:27", 1),
            District("28", "lower", "ocd-division/country:us/territory:pr/sldl:28", 1),
            District("29", "lower", "ocd-division/country:us/territory:pr/sldl:29", 1),
            District("30", "lower", "ocd-division/country:us/territory:pr/sldl:30", 1),
            District("31", "lower", "ocd-division/country:us/territory:pr/sldl:31", 1),
            District("32", "lower", "ocd-division/country:us/territory:pr/sldl:32", 1),
            District("33", "lower", "ocd-division/country:us/territory:pr/sldl:33", 1),
            District("34", "lower", "ocd-division/country:us/territory:pr/sldl:34", 1),
            District("35", "lower", "ocd-division/country:us/territory:pr/sldl:35", 1),
            District("36", "lower", "ocd-division/country:us/territory:pr/sldl:36", 1),
            District("37", "lower", "ocd-division/country:us/territory:pr/sldl:37", 1),
            District("38", "lower", "ocd-division/country:us/territory:pr/sldl:38", 1),
            District("39", "lower", "ocd-division/country:us/territory:pr/sldl:39", 1),
            District("40", "lower", "ocd-division/country:us/territory:pr/sldl:40", 1),
            District(
                "At-Large",
                "lower",
                "ocd-division/country:us/territory:pr/sldl:at-large",
                11,
            ),
        ],
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/c187ea65-5cd6-42fb-b08b-18e487855526",
        num_seats=30,
        title="Senator",
        districts=[
            District("I", "upper", "ocd-division/country:us/territory:pr/sldu:1", 2),
            District("II", "upper", "ocd-division/country:us/territory:pr/sldu:2", 2),
            District("III", "upper", "ocd-division/country:us/territory:pr/sldu:3", 2),
            District("IV", "upper", "ocd-division/country:us/territory:pr/sldu:4", 2),
            District("V", "upper", "ocd-division/country:us/territory:pr/sldu:5", 2),
            District("VI", "upper", "ocd-division/country:us/territory:pr/sldu:6", 2),
            District("VII", "upper", "ocd-division/country:us/territory:pr/sldu:7", 2),
            District("VIII", "upper", "ocd-division/country:us/territory:pr/sldu:8", 2),
            District("At-Large", "upper", "ocd-division/country:us/territory:pr", 14),
        ],
    ),
)
