#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by TatSu.
#
#    https://pypi.python.org/pypi/tatsu/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals

import sys

from tatsu.buffering import Buffer
from tatsu.parsing import Parser
from tatsu.parsing import tatsumasu, leftrec, nomemo
from tatsu.parsing import leftrec, nomemo  # noqa
from tatsu.util import re, generic_main  # noqa


KEYWORDS = {}  # type: ignore


class RGBuffer(Buffer):
    def __init__(
        self,
        text,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=None,
        namechars='',
        **kwargs
    ):
        super(RGBuffer, self).__init__(
            text,
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,
            namechars=namechars,
            **kwargs
        )


class RGParser(Parser):
    def __init__(
        self,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=None,
        left_recursion=True,
        parseinfo=True,
        keywords=None,
        namechars='',
        buffer_class=RGBuffer,
        **kwargs
    ):
        if keywords is None:
            keywords = KEYWORDS
        super(RGParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,
            left_recursion=left_recursion,
            parseinfo=parseinfo,
            keywords=keywords,
            namechars=namechars,
            buffer_class=buffer_class,
            **kwargs
        )

    @tatsumasu()
    @nomemo
    def _start_(self):  # noqa
        self._productions_()
        self._check_eof()

    @tatsumasu()
    @leftrec
    def _productions_(self):  # noqa
        with self._choice():
            with self._option():
                self._productions_()
                self._production_()
            with self._option():
                self._productions_()
                self._last_production_()
            with self._option():
                self._production_()
            self._error('no available options')

    @tatsumasu()
    def _last_production_(self):  # noqa
        with self._choice():
            with self._option():
                self._head_()
                self._token('->')
                self._alpha_()
            with self._option():
                self._head_()
                self._token('→')
                self._alpha_()
            self._error('no available options')

    @tatsumasu()
    def _production_(self):  # noqa
        with self._choice():
            with self._option():
                self._head_()
                self._token('->')
                self._alpha_()
                self._token(';')
            with self._option():
                self._head_()
                self._token('→')
                self._alpha_()
                self._token(';')
            with self._option():
                self._head_()
                self._token('->')
                self._alpha_()
                self._token('\n')
            with self._option():
                self._head_()
                self._token('→')
                self._alpha_()
                self._token('\n')
            self._error('no available options')

    @tatsumasu()
    def _alpha_(self):  # noqa
        with self._choice():
            with self._option():
                self._basic_()
                self._basic_()
            with self._option():
                self._basic_()
            self._error('no available options')

    @tatsumasu()
    def _basic_(self):  # noqa
        with self._choice():
            with self._option():
                self._token('epsilon')
            with self._option():
                self._token('ε')
            with self._option():
                self._pattern('\\w')
            with self._option():
                self._pattern('[\\$#@.<>\\-\\/#_+*()]')
            with self._option():
                self._pattern('"[^"]+"')
            self._error('no available options')

    @tatsumasu()
    def _head_(self):  # noqa
        with self._choice():
            with self._option():
                self._pattern('\\w')
            with self._option():
                self._pattern('"[^"]+"')
            self._error('no available options')


class RGSemantics(object):
    def start(self, ast):  # noqa
        return ast

    def productions(self, ast):  # noqa
        return ast

    def last_production(self, ast):  # noqa
        return ast

    def production(self, ast):  # noqa
        return ast

    def alpha(self, ast):  # noqa
        return ast

    def basic(self, ast):  # noqa
        return ast

    def head(self, ast):  # noqa
        return ast


def main(filename, start=None, **kwargs):
    if start is None:
        start = 'start'
    if not filename or filename == '-':
        text = sys.stdin.read()
    else:
        with open(filename) as f:
            text = f.read()
    parser = RGParser()
    return parser.parse(text, rule_name=start, filename=filename, **kwargs)


if __name__ == '__main__':
    import json
    from tatsu.util import asjson

    ast = generic_main(main, RGParser, name='RG')
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(asjson(ast), indent=2))
    print()
