from .persistence.factory import get_decode_sink
from .managers import get_decoder_env
SINK = get_decode_sink()
ENV = get_decoder_env()
def decode_record_data(**kwargs):

    result = ENV.decode(
        kwargs.get("b64"),
        signature=kwargs.get("signature"),
        program_id=kwargs.get("program_id"),
    )

    payload = {
        "data": kwargs.get("b64"),
        "signature": kwargs.get("signature"),
        "program_id": kwargs.get("program_id"),
        "result": result,
    }

    if result is None:
        SINK.save_failed(
            discriminator=kwargs.get("discriminator"),
            event=kwargs.get("event"),
            payload=payload,
        )
    else:
        SINK.save_decoded(
            discriminator=kwargs.get("discriminator"),
            event=kwargs.get("event"),
            payload=payload,
        )
    
##for log in logs:
##    b64 = log.get('b64')
##    event_name = log.get("event")
##    signature = log.get('signature')
##    program_id = log.get('program_id')
##    result = env.decode(b64, signature=signature, program_id=program_id)
##    print(result)
