from enum import IntEnum


class UnitId(IntEnum):
    MOVEABLE_MAP_REVEALER = 0
    ALFRED_THE_ALPACA = 1300
    AMAZON_ARCHER = 850
    AMAZON_WARRIOR = 825
    ARAMBAI = 1126
    ARBALESTER = 492
    ARCHER = 4
    BACTRIAN_CAMEL = 1237
    BALLISTA_ELEPHANT = 1120
    BANDIT = 299
    BATTERING_RAM = 1258
    BATTLE_ELEPHANT = 1132
    BERSERK = 692
    BOMBARD_CANNON = 36
    BOYAR = 876
    CAMEL = 897
    CAMEL_ARCHER = 1007
    CAMEL_RIDER = 329
    CANNON_GALLEON = 420
    CANOE = 778
    CAPPED_RAM = 422
    CARAVEL = 1004
    CART = 1338
    CATAPHRACT = 40
    CAVALIER = 283
    CAVALRY_ARCHER = 39
    CENTURION = 275
    CHAMPION = 567
    CHU_KO_NU = 73
    COBRA_CAR = 748
    CONDOTTIERO = 882
    CONQUISTADOR = 771
    COW_A = 705
    COW_B = 1596
    COW_C = 1598
    COW_D = 1600
    CROSSBOWMAN = 24
    DEMOLITION_RAFT = 1104
    DEMOLITION_SHIP = 527
    DONKEY = 846
    DRAGON_SHIP = 1302
    EAGLE_SCOUT = 751
    EAGLE_WARRIOR = 753
    EASTERN_SWORDSMAN = 894
    ELEPHANT_ARCHER = 873
    ELITE_ARAMBAI = 1128
    ELITE_BALLISTA_ELEPHANT = 1122
    ELITE_BATTLE_ELEPHANT = 1134
    ELITE_BERSERK = 694
    ELITE_BOYAR = 878
    ELITE_CAMEL_ARCHER = 1009
    ELITE_CANNON_GALLEON = 691
    ELITE_CARAVEL = 1006
    ELITE_CATAPHRACT = 553
    ELITE_CHU_KO_NU = 559
    ELITE_CONQUISTADOR = 773
    ELITE_EAGLE_WARRIOR = 752
    ELITE_ELEPHANT_ARCHER = 875
    ELITE_GBETO = 1015
    ELITE_GENITOUR = 1012
    ELITE_GENOESE_CROSSBOWMAN = 868
    ELITE_HUSKARL = 555
    ELITE_JAGUAR_WARRIOR = 726
    ELITE_JANISSARY = 557
    ELITE_KAMAYUK = 881
    ELITE_KARAMBIT_WARRIOR = 1125
    ELITE_KESHIK = 1230
    ELITE_KIPCHAK = 1233
    ELITE_KONNIK = 1227
    ELITE_KONNIK_DISMOUNTED = 1253
    ELITE_LEITIS = 1236
    ELITE_LONGBOAT = 533
    ELITE_LONGBOWMAN = 530
    ELITE_MAGYAR_HUSZAR = 871
    ELITE_MAMELUKE = 556
    ELITE_MANGUDAI = 561
    ELITE_ORGAN_GUN = 1003
    ELITE_PLUMED_ARCHER = 765
    ELITE_RATTAN_ARCHER = 1131
    ELITE_SAMURAI = 560
    ELITE_SHOTEL_WARRIOR = 1018
    ELITE_SKIRMISHER = 6
    ELITE_STEPPE_LANCER = 1372
    ELITE_TARKAN = 757
    ELITE_TEUTONIC_KNIGHT = 554
    ELITE_THROWING_AXEMAN = 531
    ELITE_TURTLE_SHIP = 832
    ELITE_WAR_ELEPHANT = 558
    ELITE_WAR_WAGON = 829
    ELITE_WOAD_RAIDER = 534
    FAST_FIRE_SHIP = 532
    FIRE_GALLEY = 1103
    FIRE_SHIP = 529
    FISHING_SHIP = 13
    FLAMETHROWER = 188
    FLAMING_CAMEL = 1263
    FURIOUS_THE_MONKEY_BOY = 860
    GALLEON = 442
    GALLEY = 539
    GBETO = 1013
    GENITOUR = 1010
    GENOESE_CROSSBOWMAN = 866
    GOAT = 1060
    GOOSE = 1243
    HALBERDIER = 359
    HAND_CANNONEER = 5
    HEAVY_CAMEL_RIDER = 330
    HEAVY_CAVALRY_ARCHER = 474
    HEAVY_CROSSBOWMAN = 493
    HEAVY_DEMOLITION_SHIP = 528
    HEAVY_PIKEMAN = 892
    HEAVY_SCORPION = 542
    HEAVY_SWORDSMAN = 76
    HORSE_A = 814
    HORSE_B = 1356
    HORSE_C = 1602
    HORSE_D = 1604
    HORSE_E = 1606
    HUSKARL = 41
    HUSSAR = 441
    IMPERIAL_CAMEL_RIDER = 207
    IMPERIAL_SKIRMISHER = 1155
    INVISIBLE_OBJECT = 1291
    IROQUOIS_WARRIOR = 1374
    JAGUAR_WARRIOR = 725
    JANISSARY = 46
    JUNK = 15
    KAMAYUK = 879
    KARAMBIT_WARRIOR = 1123
    KESHIK = 1228
    KHAN = 1275
    KING = 434
    KIPCHAK = 1231
    KNIGHT = 38
    KONNIK = 1225
    KONNIK_DISMOUNTED = 1252
    LEGIONARY = 1
    LEITIS = 1234
    LIGHT_CAVALRY = 546
    LLAMA = 305
    LONG_SWORDSMAN = 77
    LONGBOAT = 250
    LONGBOWMAN = 8
    MAGYAR_HUSZAR = 869
    MAMELUKE = 282
    MAN_AT_ARMS = 75
    MANGONEL = 280
    MANGUDAI = 11
    MERCHANT = 1572
    MILITIA = 74
    MISSIONARY = 775
    MONK = 125
    MONK_WITH_RELIC = 286
    NINJA = 1145
    NORSE_WARRIOR = 361
    ONAGER = 550
    ORGAN_GUN = 1001
    OX_CART = 1271
    OX_WAGON = 1273
    PALADIN = 569
    PENGUIN = 639
    PETARD = 440
    PHOTONMAN = 1577
    PIG = 1245
    PIKEMAN = 358
    PLUMED_ARCHER = 763
    PRIEST = 1023
    PRIEST_WITH_RELIC = 1400
    QUEEN = 1292
    RATTAN_ARCHER = 1129
    RELIC_CART = 1304
    ROYAL_JANISSARY = 52
    SAMURAI = 291
    SCORPION = 279
    SCOUT_CAVALRY = 448
    SHARKATZOR = 1222
    SHEEP = 594
    SHOTEL_WARRIOR = 1016
    SIEGE_ONAGER = 588
    SIEGE_RAM = 548
    SIEGE_TOWER = 1105
    SKIRMISHER = 7
    SLINGER = 185
    SPEARMAN = 93
    STEPPE_LANCER = 1370
    TARKAN = 755
    TEUTONIC_KNIGHT = 25
    THROWING_AXEMAN = 281
    TORCH_A_CONVERTABLE = 854
    TORCH_B_CONVERTABLE = 1377
    TRADE_CART_EMPTY = 128
    TRADE_CART_FULL = 204
    TRADE_COG = 17
    TRANSPORT_SHIP = 545
    TREBUCHET = 42
    TREBUCHET_PACKED = 331
    TURKEY = 833
    TURTLE_SHIP = 831
    TWO_HANDED_SWORDSMAN = 473

    VILLAGER_MALE_FISHERMAN = 56
    VILLAGER_FEMALE_FISHERMAN = 57
    VILLAGER_MALE = 83
    VILLAGER_MALE_BUILDER = 118
    VILLAGER_MALE_FORAGER = 120
    VILLAGER_MALE_HUNTER = 122
    VILLAGER_MALE_LUMBERJACK = 123
    VILLAGER_MALE_STONE_MINER = 124
    VILLAGER_MALE_REPAIRER = 156
    VILLAGER_FEMALE_BUILDER = 212
    VILLAGER_FEMALE_FARMER = 214
    VILLAGER_FEMALE_HUNTER = 216
    VILLAGER_FEMALE_LUMBERJACK = 218
    VILLAGER_FEMALE_STONE_MINER = 220
    VILLAGER_FEMALE_REPAIRER = 222
    VILLAGER_MALE_FARMER = 259
    VILLAGER_FEMALE = 293
    VILLAGER_FEMALE_FORAGER = 354
    VILLAGER_MALE_GOLD_MINER = 579
    VILLAGER_FEMALE_GOLD_MINER = 581
    VILLAGER_FEMALE_SHEPHERD = 590
    VILLAGER_MALE_SHEPHERD = 592

    VILLAGER_MALE_DAVE_LEWIS = 206

    WAR_ELEPHANT = 239
    WAR_GALLEY = 21
    WAR_WAGON = 827
    WATER_BUFFALO = 1142
    WOAD_RAIDER = 232
    XOLOTL_WARRIOR = 1570
    SMALL_TEMP_MAP_REVEAL = 112
    LARGE_TEMP_MAP_REVEAL = 332
    BOARDER_GALLEY = 536
    """Monk for ships - can convert enemy boats with 1 range"""
    HUSKARL_BARRACKS = 759
    ELITE_HUSKARL_BARRACKS = 761
    TARKAN_STABLE = 886
    ELITE_TARKAN_STABLE = 887
    GENITOUR_ORIGINAL = 583
    """Refers to the original unit named genitour, which was a militia with a ranged attack, like a skirmisher"""
    ELITE_GENITOUR_ORIGINAL = 596
    """Refers to the original unit named genitour, which was a militia with a ranged attack, like a skirmisher"""
    CONDOTTIERO_PLACEHOLDER = 184
    KONNIK_KREPOST = 1254
    ELITE_KONNIK_KREPOST = 1255
    ELITE_KIPCHAK_CUMAN_MERCENARIES = 1260

    # Lords of the West - DLC Units
    COUSTILLIER = 1655
    ELITE_COUSTILLIER = 1657
    FLEMISH_MILITIA = 1699
    FLEMISH_MILITIA_MALE = 1663
    """Refers to the Flemish militia after being converted from a male villager"""
    FLEMISH_MILITIA_FEMALE = 1697
    """Refers to the Flemish militia after being converted from a female villager"""
    SERJEANT = 1658
    ELITE_SERJEANT = 1659
    SERJEANT_DONJON = 1660
    ELITE_SERJEANT_DONJON = 1661


class GaiaUnitId(IntEnum):
    # GAIA Units
    BEAR = 486
    BUTTERFLY1 = 1608
    BUTTERFLY2 = 1609
    BUTTERFLY3 = 1610
    CROCODILE = 1031
    DEER = 65
    DIRE_WOLF = 89
    ELEPHANT = 1301
    FALCON = 1056
    HAWK = 96
    IBEX = 1239
    IRON_BOAR = 810
    JAGUAR = 812
    JAVELINA = 822
    KOMODO_DRAGON = 1135
    LION = 1029
    MACAW = 816
    OSTRICH = 1026
    RABID_WOLF = 202
    RHINOCEROS = 1139
    SEAGULLS = 303
    SNOW_LEOPARD = 1241
    STORK = 1028
    STORMY_DOG = 862
    TIGER = 1137
    VULTURE = 1305
    WILD_BACTRIAN_CAMEL = 1247
    WILD_BOAR = 48
    WILD_CAMEL = 884
    WILD_HORSE = 835
    WOLF = 126
    ZEBRA = 1019

    # Player Units
    MOVEABLE_MAP_REVEALER = 0
    ALFRED_THE_ALPACA = 1300
    AMAZON_ARCHER = 850
    AMAZON_WARRIOR = 825
    ARAMBAI = 1126
    ARBALESTER = 492
    ARCHER = 4
    BACTRIAN_CAMEL = 1237
    BALLISTA_ELEPHANT = 1120
    BANDIT = 299
    BATTERING_RAM = 1258
    BATTLE_ELEPHANT = 1132
    BERSERK = 692
    BOMBARD_CANNON = 36
    BOYAR = 876
    CAMEL = 897
    CAMEL_ARCHER = 1007
    CAMEL_RIDER = 329
    CANNON_GALLEON = 420
    CANOE = 778
    CAPPED_RAM = 422
    CARAVEL = 1004
    CART = 1338
    CATAPHRACT = 40
    CAVALIER = 283
    CAVALRY_ARCHER = 39
    CENTURION = 275
    CHAMPION = 567
    CHU_KO_NU = 73
    COBRA_CAR = 748
    CONDOTTIERO = 882
    CONQUISTADOR = 771
    COW_A = 705
    COW_B = 1596
    COW_C = 1598
    COW_D = 1600
    CROSSBOWMAN = 24
    DEMOLITION_RAFT = 1104
    DEMOLITION_SHIP = 527
    DONKEY = 846
    DRAGON_SHIP = 1302
    EAGLE_SCOUT = 751
    EAGLE_WARRIOR = 753
    EASTERN_SWORDSMAN = 894
    ELEPHANT_ARCHER = 873
    ELITE_ARAMBAI = 1128
    ELITE_BALLISTA_ELEPHANT = 1122
    ELITE_BATTLE_ELEPHANT = 1134
    ELITE_BERSERK = 694
    ELITE_BOYAR = 878
    ELITE_CAMEL_ARCHER = 1009
    ELITE_CANNON_GALLEON = 691
    ELITE_CARAVEL = 1006
    ELITE_CATAPHRACT = 553
    ELITE_CHU_KO_NU = 559
    ELITE_CONQUISTADOR = 773
    ELITE_EAGLE_WARRIOR = 752
    ELITE_ELEPHANT_ARCHER = 875
    ELITE_GBETO = 1015
    ELITE_GENITOUR = 1012
    ELITE_GENOESE_CROSSBOWMAN = 868
    ELITE_HUSKARL = 555
    ELITE_JAGUAR_WARRIOR = 726
    ELITE_JANISSARY = 557
    ELITE_KAMAYUK = 881
    ELITE_KARAMBIT_WARRIOR = 1125
    ELITE_KESHIK = 1230
    ELITE_KIPCHAK = 1233
    ELITE_KONNIK = 1227
    ELITE_KONNIK_DISMOUNTED = 1253
    ELITE_LEITIS = 1236
    ELITE_LONGBOAT = 533
    ELITE_LONGBOWMAN = 530
    ELITE_MAGYAR_HUSZAR = 871
    ELITE_MAMELUKE = 556
    ELITE_MANGUDAI = 561
    ELITE_ORGAN_GUN = 1003
    ELITE_PLUMED_ARCHER = 765
    ELITE_RATTAN_ARCHER = 1131
    ELITE_SAMURAI = 560
    ELITE_SHOTEL_WARRIOR = 1018
    ELITE_SKIRMISHER = 6
    ELITE_STEPPE_LANCER = 1372
    ELITE_TARKAN = 757
    ELITE_TEUTONIC_KNIGHT = 554
    ELITE_THROWING_AXEMAN = 531
    ELITE_TURTLE_SHIP = 832
    ELITE_WAR_ELEPHANT = 558
    ELITE_WAR_WAGON = 829
    ELITE_WOAD_RAIDER = 534
    FAST_FIRE_SHIP = 532
    FIRE_GALLEY = 1103
    FIRE_SHIP = 529
    FISHING_SHIP = 13
    FLAMETHROWER = 188
    FLAMING_CAMEL = 1263
    FURIOUS_THE_MONKEY_BOY = 860
    GALLEON = 442
    GALLEY = 539
    GBETO = 1013
    GENITOUR = 1010
    GENOESE_CROSSBOWMAN = 866
    GOAT = 1060
    GOOSE = 1243
    HALBERDIER = 359
    HAND_CANNONEER = 5
    HEAVY_CAMEL_RIDER = 330
    HEAVY_CAVALRY_ARCHER = 474
    HEAVY_CROSSBOWMAN = 493
    HEAVY_DEMOLITION_SHIP = 528
    HEAVY_PIKEMAN = 892
    HEAVY_SCORPION = 542
    HEAVY_SWORDSMAN = 76
    HORSE_A = 814
    HORSE_B = 1356
    HORSE_C = 1602
    HORSE_D = 1604
    HORSE_E = 1606
    HUSKARL = 41
    HUSSAR = 441
    IMPERIAL_CAMEL_RIDER = 207
    IMPERIAL_SKIRMISHER = 1155
    INVISIBLE_OBJECT = 1291
    IROQUOIS_WARRIOR = 1374
    JAGUAR_WARRIOR = 725
    JANISSARY = 46
    JUNK = 15
    KAMAYUK = 879
    KARAMBIT_WARRIOR = 1123
    KESHIK = 1228
    KHAN = 1275
    KING = 434
    KIPCHAK = 1231
    KNIGHT = 38
    KONNIK = 1225
    KONNIK_DISMOUNTED = 1252
    LEGIONARY = 1
    LEITIS = 1234
    LIGHT_CAVALRY = 546
    LLAMA = 305
    LONG_SWORDSMAN = 77
    LONGBOAT = 250
    LONGBOWMAN = 8
    MAGYAR_HUSZAR = 869
    MAMELUKE = 282
    MAN_AT_ARMS = 75
    MANGONEL = 280
    MANGUDAI = 11
    MERCHANT = 1572
    MILITIA = 74
    MISSIONARY = 775
    MONK = 125
    MONK_WITH_RELIC = 286
    NINJA = 1145
    NORSE_WARRIOR = 361
    ONAGER = 550
    ORGAN_GUN = 1001
    OX_CART = 1271
    OX_WAGON = 1273
    PALADIN = 569
    PENGUIN = 639
    PETARD = 440
    PHOTONMAN = 1577
    PIG = 1245
    PIKEMAN = 358
    PLUMED_ARCHER = 763
    PRIEST = 1023
    PRIEST_WITH_RELIC = 1400
    QUEEN = 1292
    RATTAN_ARCHER = 1129
    RELIC_CART = 1304
    ROYAL_JANISSARY = 52
    SAMURAI = 291
    SCORPION = 279
    SCOUT_CAVALRY = 448
    SHARKATZOR = 1222
    SHEEP = 594
    SHOTEL_WARRIOR = 1016
    SIEGE_ONAGER = 588
    SIEGE_RAM = 548
    SIEGE_TOWER = 1105
    SKIRMISHER = 7
    SLINGER = 185
    SPEARMAN = 93
    STEPPE_LANCER = 1370
    TARKAN = 755
    TEUTONIC_KNIGHT = 25
    THROWING_AXEMAN = 281
    TORCH_A_CONVERTABLE = 854
    TORCH_B_CONVERTABLE = 1377
    TRADE_CART_EMPTY = 128
    TRADE_CART_FULL = 204
    TRADE_COG = 17
    TRANSPORT_SHIP = 545
    TREBUCHET = 42
    TREBUCHET_PACKED = 331
    TURKEY = 833
    TURTLE_SHIP = 831
    TWO_HANDED_SWORDSMAN = 473

    VILLAGER_MALE_FISHERMAN = 56
    VILLAGER_FEMALE_FISHERMAN = 57
    VILLAGER_MALE = 83
    VILLAGER_MALE_BUILDER = 118
    VILLAGER_MALE_FORAGER = 120
    VILLAGER_MALE_HUNTER = 122
    VILLAGER_MALE_LUMBERJACK = 123
    VILLAGER_MALE_STONE_MINER = 124
    VILLAGER_MALE_REPAIRER = 156
    VILLAGER_FEMALE_BUILDER = 212
    VILLAGER_FEMALE_FARMER = 214
    VILLAGER_FEMALE_HUNTER = 216
    VILLAGER_FEMALE_LUMBERJACK = 218
    VILLAGER_FEMALE_STONE_MINER = 220
    VILLAGER_FEMALE_REPAIRER = 222
    VILLAGER_MALE_FARMER = 259
    VILLAGER_FEMALE = 293
    VILLAGER_FEMALE_FORAGER = 354
    VILLAGER_MALE_GOLD_MINER = 579
    VILLAGER_FEMALE_GOLD_MINER = 581
    VILLAGER_FEMALE_SHEPHERD = 590
    VILLAGER_MALE_SHEPHERD = 592

    VILLAGER_MALE_DAVE_LEWIS = 206

    WAR_ELEPHANT = 239
    WAR_GALLEY = 21
    WAR_WAGON = 827
    WATER_BUFFALO = 1142
    WOAD_RAIDER = 232
    XOLOTL_WARRIOR = 1570
    SMALL_TEMP_MAP_REVEAL = 112
    LARGE_TEMP_MAP_REVEAL = 332
    BOARDER_GALLEY = 536
    """Monk for ships - can convert enemy boats with 1 range"""
    HUSKARL_BARRACKS = 759
    ELITE_HUSKARL_BARRACKS = 761
    TARKAN_STABLE = 886
    ELITE_TARKAN_STABLE = 887
    GENITOUR_ORIGINAL = 583
    """Refers to the original unit named genitour, which was a militia with a ranged attack, like a skirmisher"""
    ELITE_GENITOUR_ORIGINAL = 596
    """Refers to the original unit named genitour, which was a militia with a ranged attack, like a skirmisher"""
    
    # Lords of the West - DLC Units
    COUSTILLIER = 1655
    ELITE_COUSTILLIER = 1657
    FLEMISH_MILITIA = 1699
    FLEMISH_MILITIA_MALE = 1663
    """Refers to the Flemish militia after being converted from a male villager"""
    FLEMISH_MILITIA_FEMALE = 1697
    """Refers to the Flemish militia after being converted from a female villager"""
    SERJEANT = 1658
    ELITE_SERJEANT = 1659
    SERJEANT_DONJON = 1660
    ELITE_SERJEANT_DONJON = 1661

    CONDOTTIERO_PLACEHOLDER = 184
    KONNIK_KREPOST = 1254
    ELITE_KONNIK_KREPOST = 1255
    ELITE_KIPCHAK_CUMAN_MERCENARIES = 1260


class UnitIcon(IntEnum):
    MOVEABLE_MAP_REVEALER = -1
    ALFRED_THE_ALPACA = 177
    AMAZON_ARCHER = 165
    AMAZON_WARRIOR = 166
    ARAMBAI = 230
    ARBALESTER = 90
    ARCHER = 17
    BACTRIAN_CAMEL = 266
    BALLISTA_ELEPHANT = 231
    BANDIT = 8
    BATTERING_RAM = 74
    BATTLE_ELEPHANT = 228
    BERSERK = 38
    BOMBARD_CANNON = 30
    BOYAR = 114
    CAMEL = 135
    CAMEL_ARCHER = 191
    CAMEL_RIDER = 78
    CANNON_GALLEON = 55
    CANOE = 164
    CAPPED_RAM = 63
    CARAVEL = 198
    CART = 34
    CATAPHRACT = 35
    CAVALIER = 49
    CAVALRY_ARCHER = 19
    CENTURION = 138
    CHAMPION = 72
    CHU_KO_NU = 36
    COBRA_CAR = 142
    CONDOTTIERO = 134
    CONQUISTADOR = 106
    COW_A = 150
    COW_B = 150
    COW_C = 150
    COW_D = 150
    CROSSBOWMAN = 18
    DEMOLITION_RAFT = 202
    DEMOLITION_SHIP = 84
    DONKEY = 158
    DRAGON_SHIP = 178
    EAGLE_SCOUT = 109
    EAGLE_WARRIOR = 148
    EASTERN_SWORDSMAN = 186
    ELEPHANT_ARCHER = 93
    ELITE_ARAMBAI = 230
    ELITE_BALLISTA_ELEPHANT = 231
    ELITE_BATTLE_ELEPHANT = 246
    ELITE_BERSERK = 38
    ELITE_BOYAR = 114
    ELITE_CAMEL_ARCHER = 191
    ELITE_CANNON_GALLEON = 298
    ELITE_CARAVEL = 198
    ELITE_CATAPHRACT = 35
    ELITE_CHU_KO_NU = 36
    ELITE_CONQUISTADOR = 106
    ELITE_EAGLE_WARRIOR = 149
    ELITE_ELEPHANT_ARCHER = 93
    ELITE_GBETO = 197
    ELITE_GENITOUR = 201
    ELITE_GENOESE_CROSSBOWMAN = 133
    ELITE_HUSKARL = 50
    ELITE_JAGUAR_WARRIOR = 110
    ELITE_JANISSARY = 39
    ELITE_KAMAYUK = 97
    ELITE_KARAMBIT_WARRIOR = 233
    ELITE_KESHIK = 251
    ELITE_KIPCHAK = 252
    ELITE_KONNIK = 249
    ELITE_KONNIK_DISMOUNTED = 250
    ELITE_LEITIS = 253
    ELITE_LONGBOAT = 40
    ELITE_LONGBOWMAN = 41
    ELITE_MAGYAR_HUSZAR = 99
    ELITE_MAMELUKE = 37
    ELITE_MANGUDAI = 42
    ELITE_ORGAN_GUN = 190
    ELITE_PLUMED_ARCHER = 108
    ELITE_RATTAN_ARCHER = 232
    ELITE_SAMURAI = 44
    ELITE_SHOTEL_WARRIOR = 195
    ELITE_SKIRMISHER = 21
    ELITE_STEPPE_LANCER = 274
    ELITE_TARKAN = 105
    ELITE_TEUTONIC_KNIGHT = 45
    ELITE_THROWING_AXEMAN = 46
    ELITE_TURTLE_SHIP = 116
    ELITE_WAR_ELEPHANT = 43
    ELITE_WAR_WAGON = 117
    ELITE_WOAD_RAIDER = 47
    FAST_FIRE_SHIP = 85
    FIRE_GALLEY = 203
    FIRE_SHIP = 86
    FISHING_SHIP = 24
    FLAMETHROWER = 144
    FLAMING_CAMEL = 270
    FURIOUS_THE_MONKEY_BOY = 132
    GALLEON = 60
    GALLEY = 87
    GBETO = 197
    GENITOUR = 201
    GENOESE_CROSSBOWMAN = 133
    GOAT = 200
    GOOSE = 265
    HALBERDIER = 104
    HAND_CANNONEER = 22
    HEAVY_CAMEL_RIDER = 79
    HEAVY_CAVALRY_ARCHER = 71
    HEAVY_CROSSBOWMAN = 133
    HEAVY_DEMOLITION_SHIP = 83
    HEAVY_PIKEMAN = 136
    HEAVY_SCORPION = 89
    HEAVY_SWORDSMAN = 184
    HORSE_A = 112
    HORSE_B = 112
    HORSE_C = 112
    HORSE_D = 112
    HORSE_E = 112
    HUSKARL = 50
    HUSSAR = 103
    IMPERIAL_CAMEL_RIDER = 185
    IMPERIAL_SKIRMISHER = 229
    INVISIBLE_OBJECT = -1
    IROQUOIS_WARRIOR = 297
    JAGUAR_WARRIOR = 110
    JANISSARY = 39
    JUNK = 211
    KAMAYUK = 97
    KARAMBIT_WARRIOR = 233
    KESHIK = 251
    KHAN = 258
    KING = 48
    KIPCHAK = 252
    KNIGHT = 1
    KONNIK = 249
    KONNIK_DISMOUNTED = 250
    LEGIONARY = 139
    LEITIS = 253
    LIGHT_CAVALRY = 91
    LLAMA = 156
    LONG_SWORDSMAN = 13
    LONGBOAT = 40
    LONGBOWMAN = 41
    MAGYAR_HUSZAR = 99
    MAMELUKE = 37
    MAN_AT_ARMS = 10
    MANGONEL = 27
    MANGUDAI = 42
    MERCHANT = 346
    MILITIA = 8
    MISSIONARY = 107
    MONK = 33
    MONK_WITH_RELIC = 33
    NINJA = 299
    NORSE_WARRIOR = 140
    ONAGER = 101
    ORGAN_GUN = 190
    OX_CART = 263
    OX_WAGON = 264
    PALADIN = 2
    PENGUIN = 157
    PETARD = 113
    PHOTONMAN = 300
    PIG = 269
    PIKEMAN = 11
    PLUMED_ARCHER = 108
    PRIEST = 294
    PRIEST_WITH_RELIC = 33
    QUEEN = 168
    RATTAN_ARCHER = 232
    RELIC_CART = 295
    ROYAL_JANISSARY = 296
    SAMURAI = 44
    SCORPION = 80
    SCOUT_CAVALRY = 64
    SHARKATZOR = 352
    SHEEP = 96
    SHOTEL_WARRIOR = 195
    SIEGE_ONAGER = 102
    SIEGE_RAM = 73
    SIEGE_TOWER = 212
    SKIRMISHER = 20
    SLINGER = 143
    SPEARMAN = 31
    STEPPE_LANCER = 273
    TARKAN = 105
    TEUTONIC_KNIGHT = 45
    THROWING_AXEMAN = 46
    TORCH_A_CONVERTABLE = -1
    TORCH_B_CONVERTABLE = -1
    TRADE_CART_EMPTY = 34
    TRADE_CART_FULL = 34
    TRADE_CART_MESO = 287
    TRADE_COG = 23
    TRANSPORT_SHIP = 95
    TREBUCHET = 28
    TREBUCHET_PACKED = 29
    TURKEY = 115
    TURTLE_SHIP = 116
    TWO_HANDED_SWORDSMAN = 12

    VILLAGER_MALE_FISHERMAN = 332
    VILLAGER_FEMALE_FISHERMAN = 331
    VILLAGER_MALE = 15
    VILLAGER_MALE_BUILDER = 330
    VILLAGER_MALE_FORAGER = 332
    VILLAGER_MALE_HUNTER = 332
    VILLAGER_MALE_LUMBERJACK = 339
    VILLAGER_MALE_STONE_MINER = 336
    VILLAGER_MALE_REPAIRER = 330
    VILLAGER_MALE_VMDL = 337
    VILLAGER_FEMALE_BUILDER = 329
    VILLAGER_FEMALE_FARMER = 331
    VILLAGER_FEMALE_HUNTER = 331
    VILLAGER_FEMALE_LUMBERJACK = 338
    VILLAGER_FEMALE_STONE_MINER = 335
    VILLAGER_FEMALE_REPAIRER = 329
    VILLAGER_MALE_FARMER = 332
    VILLAGER_FEMALE = 16
    VILLAGER_FEMALE_FORAGER = 331
    VILLAGER_MALE_GOLD_MINER = 334
    VILLAGER_FEMALE_GOLD_MINER = 333
    VILLAGER_FEMALE_SHEPHERD = 331
    VILLAGER_MALE_SHEPHERD = 332

    WAR_ELEPHANT = 43
    WAR_GALLEY = 25
    WAR_WAGON = 117
    WATER_BUFFALO = 224
    WOAD_RAIDER = 47
    XOLOTL_WARRIOR = 351
    SMALL_TEMP_MAP_REVEAL = -1
    LARGE_TEMP_MAP_REVEAL = -1
    BOARDER_GALLEY = 82
    HUSKARL_BARRACKS = 50
    ELITE_HUSKARL_BARRACKS = 50
    TARKAN_STABLE = 105
    ELITE_TARKAN_STABLE = 105
    GENITOUR_ORIGINAL = 19
    ELITE_GENITOUR_ORIGINAL = 19
    COUSTILLIER = 355
    ELITE_COUSTILLIER = 355
    FLEMISH_MILITIA = 354
    FLEMISH_MILITIA_MALE = 354
    FLEMISH_MILITIA_FEMALE = 354
    SERJEANT = 356
    ELITE_SERJEANT = 356
    SERJEANT_DONJON = 356
    ELITE_SERJEANT_DONJON = 356


class GaiaUnitIcon(IntEnum):
    BEAR = 151
    BUTTERFLY1 = -1
    BUTTERFLY2 = -1
    BUTTERFLY3 = -1
    CROCODILE = 193
    DEER = 3
    DIRE_WOLF = 7
    ELEPHANT = 179
    FALCON = 5
    HAWK = 283
    IBEX = 267
    IRON_BOAR = 98
    JAGUAR = 111
    JAVELINA = 98
    KOMODO_DRAGON = 226
    LION = 194
    MACAW = 284
    OSTRICH = 196
    RABID_WOLF = 7
    RHINOCEROS = 225
    SEAGULLS = -1
    SNOW_LEOPARD = 268
    STORK = 285
    STORMY_DOG = 159
    TIGER = 227
    VULTURE = 286
    WILD_BACTRIAN_CAMEL = 266
    WILD_BOAR = 98
    WILD_CAMEL = 135
    WILD_HORSE = 112
    WOLF = 7
    ZEBRA = 192
    MOVEABLE_MAP_REVEALER = -1
    ALFRED_THE_ALPACA = 177
    AMAZON_ARCHER = 165
    AMAZON_WARRIOR = 166
    ARAMBAI = 230
    ARBALESTER = 90
    ARCHER = 17
    BACTRIAN_CAMEL = 266
    BALLISTA_ELEPHANT = 231
    BANDIT = 8
    BATTERING_RAM = 74
    BATTLE_ELEPHANT = 228
    BERSERK = 38
    BOMBARD_CANNON = 30
    BOYAR = 114
    CAMEL = 135
    CAMEL_ARCHER = 191
    CAMEL_RIDER = 78
    CANNON_GALLEON = 55
    CANOE = 164
    CAPPED_RAM = 63
    CARAVEL = 198
    CART = 34
    CATAPHRACT = 35
    CAVALIER = 49
    CAVALRY_ARCHER = 19
    CENTURION = 138
    CHAMPION = 72
    CHU_KO_NU = 36
    COBRA_CAR = 142
    CONDOTTIERO = 134
    CONQUISTADOR = 106
    COW_A = 150
    COW_B = 150
    COW_C = 150
    COW_D = 150
    CROSSBOWMAN = 18
    DEMOLITION_RAFT = 202
    DEMOLITION_SHIP = 84
    DONKEY = 158
    DRAGON_SHIP = 178
    EAGLE_SCOUT = 109
    EAGLE_WARRIOR = 148
    EASTERN_SWORDSMAN = 186
    ELEPHANT_ARCHER = 93
    ELITE_ARAMBAI = 230
    ELITE_BALLISTA_ELEPHANT = 231
    ELITE_BATTLE_ELEPHANT = 246
    ELITE_BERSERK = 38
    ELITE_BOYAR = 114
    ELITE_CAMEL_ARCHER = 191
    ELITE_CANNON_GALLEON = 298
    ELITE_CARAVEL = 198
    ELITE_CATAPHRACT = 35
    ELITE_CHU_KO_NU = 36
    ELITE_CONQUISTADOR = 106
    ELITE_EAGLE_WARRIOR = 149
    ELITE_ELEPHANT_ARCHER = 93
    ELITE_GBETO = 197
    ELITE_GENITOUR = 201
    ELITE_GENOESE_CROSSBOWMAN = 133
    ELITE_HUSKARL = 50
    ELITE_JAGUAR_WARRIOR = 110
    ELITE_JANISSARY = 39
    ELITE_KAMAYUK = 97
    ELITE_KARAMBIT_WARRIOR = 233
    ELITE_KESHIK = 251
    ELITE_KIPCHAK = 252
    ELITE_KONNIK = 249
    ELITE_KONNIK_DISMOUNTED = 250
    ELITE_LEITIS = 253
    ELITE_LONGBOAT = 40
    ELITE_LONGBOWMAN = 41
    ELITE_MAGYAR_HUSZAR = 99
    ELITE_MAMELUKE = 37
    ELITE_MANGUDAI = 42
    ELITE_ORGAN_GUN = 190
    ELITE_PLUMED_ARCHER = 108
    ELITE_RATTAN_ARCHER = 232
    ELITE_SAMURAI = 44
    ELITE_SHOTEL_WARRIOR = 195
    ELITE_SKIRMISHER = 21
    ELITE_STEPPE_LANCER = 274
    ELITE_TARKAN = 105
    ELITE_TEUTONIC_KNIGHT = 45
    ELITE_THROWING_AXEMAN = 46
    ELITE_TURTLE_SHIP = 116
    ELITE_WAR_ELEPHANT = 43
    ELITE_WAR_WAGON = 117
    ELITE_WOAD_RAIDER = 47
    FAST_FIRE_SHIP = 85
    FIRE_GALLEY = 203
    FIRE_SHIP = 86
    FISHING_SHIP = 24
    FLAMETHROWER = 144
    FLAMING_CAMEL = 270
    FURIOUS_THE_MONKEY_BOY = 132
    GALLEON = 60
    GALLEY = 87
    GBETO = 197
    GENITOUR = 201
    GENOESE_CROSSBOWMAN = 133
    GOAT = 200
    GOOSE = 265
    HALBERDIER = 104
    HAND_CANNONEER = 22
    HEAVY_CAMEL_RIDER = 79
    HEAVY_CAVALRY_ARCHER = 71
    HEAVY_CROSSBOWMAN = 133
    HEAVY_DEMOLITION_SHIP = 83
    HEAVY_PIKEMAN = 136
    HEAVY_SCORPION = 89
    HEAVY_SWORDSMAN = 184
    HORSE_A = 112
    HORSE_B = 112
    HORSE_C = 112
    HORSE_D = 112
    HORSE_E = 112
    HUSKARL = 50
    HUSSAR = 103
    IMPERIAL_CAMEL_RIDER = 185
    IMPERIAL_SKIRMISHER = 229
    INVISIBLE_OBJECT = -1
    IROQUOIS_WARRIOR = 297
    JAGUAR_WARRIOR = 110
    JANISSARY = 39
    JUNK = 211
    KAMAYUK = 97
    KARAMBIT_WARRIOR = 233
    KESHIK = 251
    KHAN = 258
    KING = 48
    KIPCHAK = 252
    KNIGHT = 1
    KONNIK = 249
    KONNIK_DISMOUNTED = 250
    LEGIONARY = 139
    LEITIS = 253
    LIGHT_CAVALRY = 91
    LLAMA = 156
    LONG_SWORDSMAN = 13
    LONGBOAT = 40
    LONGBOWMAN = 41
    MAGYAR_HUSZAR = 99
    MAMELUKE = 37
    MAN_AT_ARMS = 10
    MANGONEL = 27
    MANGUDAI = 42
    MERCHANT = 346
    MILITIA = 8
    MISSIONARY = 107
    MONK = 33
    MONK_WITH_RELIC = 33
    NINJA = 299
    NORSE_WARRIOR = 140
    ONAGER = 101
    ORGAN_GUN = 190
    OX_CART = 263
    OX_WAGON = 264
    PALADIN = 2
    PENGUIN = 157
    PETARD = 113
    PHOTONMAN = 300
    PIG = 269
    PIKEMAN = 11
    PLUMED_ARCHER = 108
    PRIEST = 294
    PRIEST_WITH_RELIC = 33
    QUEEN = 168
    RATTAN_ARCHER = 232
    RELIC_CART = 295
    ROYAL_JANISSARY = 296
    SAMURAI = 44
    SCORPION = 80
    SCOUT_CAVALRY = 64
    SHARKATZOR = 352
    SHEEP = 96
    SHOTEL_WARRIOR = 195
    SIEGE_ONAGER = 102
    SIEGE_RAM = 73
    SIEGE_TOWER = 212
    SKIRMISHER = 20
    SLINGER = 143
    SPEARMAN = 31
    STEPPE_LANCER = 273
    TARKAN = 105
    TEUTONIC_KNIGHT = 45
    THROWING_AXEMAN = 46
    TORCH_A_CONVERTABLE = -1
    TORCH_B_CONVERTABLE = -1
    TRADE_CART_EMPTY = 34
    TRADE_CART_FULL = 34
    TRADE_CART_MESO = 287
    TRADE_COG = 23
    TRANSPORT_SHIP = 95
    TREBUCHET = 28
    TREBUCHET_PACKED = 29
    TURKEY = 115
    TURTLE_SHIP = 116
    TWO_HANDED_SWORDSMAN = 12

    VILLAGER_MALE_FISHERMAN = 332
    VILLAGER_FEMALE_FISHERMAN = 331
    VILLAGER_MALE = 15
    VILLAGER_MALE_BUILDER = 330
    VILLAGER_MALE_FORAGER = 332
    VILLAGER_MALE_HUNTER = 332
    VILLAGER_MALE_LUMBERJACK = 339
    VILLAGER_MALE_STONE_MINER = 336
    VILLAGER_MALE_REPAIRER = 330
    VILLAGER_MALE_VMDL = 337
    VILLAGER_FEMALE_BUILDER = 329
    VILLAGER_FEMALE_FARMER = 331
    VILLAGER_FEMALE_HUNTER = 331
    VILLAGER_FEMALE_LUMBERJACK = 338
    VILLAGER_FEMALE_STONE_MINER = 335
    VILLAGER_FEMALE_REPAIRER = 329
    VILLAGER_MALE_FARMER = 332
    VILLAGER_FEMALE = 16
    VILLAGER_FEMALE_FORAGER = 331
    VILLAGER_MALE_GOLD_MINER = 334
    VILLAGER_FEMALE_GOLD_MINER = 333
    VILLAGER_FEMALE_SHEPHERD = 331
    VILLAGER_MALE_SHEPHERD = 332

    WAR_ELEPHANT = 43
    WAR_GALLEY = 25
    WAR_WAGON = 117
    WATER_BUFFALO = 224
    WOAD_RAIDER = 47
    XOLOTL_WARRIOR = 351
    SMALL_TEMP_MAP_REVEAL = -1
    LARGE_TEMP_MAP_REVEAL = -1
    BOARDER_GALLEY = 82
    HUSKARL_BARRACKS = 50
    ELITE_HUSKARL_BARRACKS = 50
    TARKAN_STABLE = 105
    ELITE_TARKAN_STABLE = 105
    GENITOUR_ORIGINAL = 19
    ELITE_GENITOUR_ORIGINAL = 19
    COUSTILLIER = 355
    ELITE_COUSTILLIER = 355
    FLEMISH_MILITIA = 354
    FLEMISH_MILITIA_MALE = 354
    FLEMISH_MILITIA_FEMALE = 354
    SERJEANT = 356
    ELITE_SERJEANT = 356
    SERJEANT_DONJON = 356
    ELITE_SERJEANT_DONJON = 356

