<p align="center"><img src="logo.png" alt="Logo"></p>

Standing for *Yet Underused Path Instruments*, **yupi** is a set of tools designed
for collecting, generating and processing trajectory data of any kind.

## **What does it offers?**

- **Convert raw data to trajectories** ... *different input manners*
- **I/O operations with trajectories** ... *json and csv serializers*
- **Trajectory extraction from video inputs** ... *even with moving camera*
- **Artificial trajectory generation** ... *several models implemented*
- **Trajectory basic operations** ... *rotation, shift, scaling, ...*
- **Trajectory transformations** ... *filters, resamples, ...*
- **Statistical calculations from trajectories ensembles** ... *turning angles histogram, velocity autocorrelation function, power spectral density, and much more ...*
- **Results visualization** ... *each statistical observable has a related plot function*
- **Spacial projection of trajectories** ... *for 2D and 3D trajectories*

## Installation

Current recommended installation method is via PyPI:

```cmd
pip install yupi
```

## Compatibility

- Python 3.7 or later
- Ubuntu 18.04 or later
- Windows 7 or later
- macOS 10.12.6 (Sierra) or later.

## Getting Started

In the [official documentation](https://yupi.readthedocs.io/en/latest/) there
are some resources to start using the library: Tutorials, Examples  and a
detailed description of the API.

## Examples

Code examples (with additional multimedia resources) can be found in
[this repository](https://github.com/yupidevs/yupi_examples). Additionally, in
the [Examples section](https://yupi.readthedocs.io/en/latest/examples/examples.html)
of the documentation, you can find the same examples with additional comments
and expected execution results in order to inspect the examples without actually
executing them.
