dataset_info = dict(
    dataset_name='coco',
    paper_info=dict(
        author=
        'Lin, Tsung-Yi and Maire, Michael and Belongie, Serge and Hays, James and Perona, Pietro and Ramanan, Deva and Doll{\'a}r, Piotr and Zitnick, C Lawrence',
        title='Microsoft coco: Common objects in context',
        container='European conference on computer vision',
        year='2014',
        homepage='http://cocodataset.org/'),
    keypoint_info=dict({
        0:
        dict(name='nose', id=0, color=[51, 153, 255], type='upper', swap=''),
        1:
        dict(
            name='left_eye',
            id=1,
            color=[51, 153, 255],
            type='upper',
            swap='right_eye'),
        2:
        dict(
            name='right_eye',
            id=2,
            color=[51, 153, 255],
            type='upper',
            swap='left_eye'),
        3:
        dict(
            name='left_ear',
            id=3,
            color=[51, 153, 255],
            type='upper',
            swap='right_ear'),
        4:
        dict(
            name='right_ear',
            id=4,
            color=[51, 153, 255],
            type='upper',
            swap='left_ear'),
        5:
        dict(
            name='left_shoulder',
            id=5,
            color=[0, 255, 0],
            type='upper',
            swap='right_shoulder'),
        6:
        dict(
            name='right_shoulder',
            id=6,
            color=[255, 128, 0],
            type='upper',
            swap='left_shoulder'),
        7:
        dict(
            name='left_elbow',
            id=7,
            color=[0, 255, 0],
            type='upper',
            swap='right_elbow'),
        8:
        dict(
            name='right_elbow',
            id=8,
            color=[255, 128, 0],
            type='upper',
            swap='left_elbow'),
        9:
        dict(
            name='left_wrist',
            id=9,
            color=[0, 255, 0],
            type='upper',
            swap='right_wrist'),
        10:
        dict(
            name='right_wrist',
            id=10,
            color=[255, 128, 0],
            type='upper',
            swap='left_wrist'),
        11:
        dict(
            name='left_hip',
            id=11,
            color=[0, 255, 0],
            type='lower',
            swap='right_hip'),
        12:
        dict(
            name='right_hip',
            id=12,
            color=[255, 128, 0],
            type='lower',
            swap='left_hip'),
        13:
        dict(
            name='left_knee',
            id=13,
            color=[0, 255, 0],
            type='lower',
            swap='right_knee'),
        14:
        dict(
            name='right_knee',
            id=14,
            color=[255, 128, 0],
            type='lower',
            swap='left_knee'),
        15:
        dict(
            name='left_ankle',
            id=15,
            color=[0, 255, 0],
            type='lower',
            swap='right_ankle'),
        16:
        dict(
            name='right_ankle',
            id=16,
            color=[255, 128, 0],
            type='lower',
            swap='left_ankle')
    }),
    skeleton_info=dict({
        0:
        dict(link=('left_ankle', 'left_knee'), id=0, color=[0, 255, 0]),
        1:
        dict(link=('left_knee', 'left_hip'), id=1, color=[0, 255, 0]),
        2:
        dict(link=('right_ankle', 'right_knee'), id=2, color=[255, 128, 0]),
        3:
        dict(link=('right_knee', 'right_hip'), id=3, color=[255, 128, 0]),
        4:
        dict(link=('left_hip', 'right_hip'), id=4, color=[51, 153, 255]),
        5:
        dict(link=('left_shoulder', 'left_hip'), id=5, color=[51, 153, 255]),
        6:
        dict(link=('right_shoulder', 'right_hip'), id=6, color=[51, 153, 255]),
        7:
        dict(
            link=('left_shoulder', 'right_shoulder'),
            id=7,
            color=[51, 153, 255]),
        8:
        dict(link=('left_shoulder', 'left_elbow'), id=8, color=[0, 255, 0]),
        9:
        dict(
            link=('right_shoulder', 'right_elbow'), id=9, color=[255, 128, 0]),
        10:
        dict(link=('left_elbow', 'left_wrist'), id=10, color=[0, 255, 0]),
        11:
        dict(link=('right_elbow', 'right_wrist'), id=11, color=[255, 128, 0]),
        12:
        dict(link=('left_eye', 'right_eye'), id=12, color=[51, 153, 255]),
        13:
        dict(link=('nose', 'left_eye'), id=13, color=[51, 153, 255]),
        14:
        dict(link=('nose', 'right_eye'), id=14, color=[51, 153, 255]),
        15:
        dict(link=('left_eye', 'left_ear'), id=15, color=[51, 153, 255]),
        16:
        dict(link=('right_eye', 'right_ear'), id=16, color=[51, 153, 255]),
        17:
        dict(link=('left_ear', 'left_shoulder'), id=17, color=[51, 153, 255]),
        18:
        dict(
            link=('right_ear', 'right_shoulder'), id=18, color=[51, 153, 255])
    }),
    joint_weights=[
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.2, 1.2, 1.5, 1.5, 1.0, 1.0, 1.2,
        1.2, 1.5, 1.5
    ],
    sigmas=[
        0.026, 0.025, 0.025, 0.035, 0.035, 0.079, 0.079, 0.072, 0.072, 0.062,
        0.062, 0.107, 0.107, 0.087, 0.087, 0.089, 0.089
    ])
log_level = 'INFO'
load_from = None
resume_from = None
dist_params = dict(backend='nccl')
workflow = [('train', 1)]
checkpoint_config = dict(interval=10)
evaluation = dict(interval=10, metric='mAP', save_best='AP')
optimizer = dict(type='Adam', lr=0.0005)
optimizer_config = dict(grad_clip=None)
lr_config = dict(
    policy='step',
    warmup='linear',
    warmup_iters=500,
    warmup_ratio=0.001,
    step=[170, 200])
total_epochs = 210
log_config = dict(interval=50, hooks=[dict(type='TextLoggerHook')])
channel_cfg = dict(
    num_output_channels=17,
    dataset_joints=17,
    dataset_channel=[[
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
    ]],
    inference_channel=[
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
    ])
model = dict(
    type='TopDown',
    pretrained=
    'https://download.openmmlab.com/mmpose/pretrain_models/hrnet_w48-8ef0771d.pth',
    backbone=dict(
        type='HRNet',
        in_channels=3,
        extra=dict(
            stage1=dict(
                num_modules=1,
                num_branches=1,
                block='BOTTLENECK',
                num_blocks=(4, ),
                num_channels=(64, )),
            stage2=dict(
                num_modules=1,
                num_branches=2,
                block='BASIC',
                num_blocks=(4, 4),
                num_channels=(48, 96)),
            stage3=dict(
                num_modules=4,
                num_branches=3,
                block='BASIC',
                num_blocks=(4, 4, 4),
                num_channels=(48, 96, 192)),
            stage4=dict(
                num_modules=3,
                num_branches=4,
                block='BASIC',
                num_blocks=(4, 4, 4, 4),
                num_channels=(48, 96, 192, 384)))),
    keypoint_head=dict(
        type='TopdownHeatmapSimpleHead',
        in_channels=48,
        out_channels=17,
        num_deconv_layers=0,
        extra=dict(final_conv_kernel=1),
        loss_keypoint=dict(type='JointsMSELoss', use_target_weight=True)),
    train_cfg=dict(),
    test_cfg=dict(
        flip_test=True,
        post_process='default',
        shift_heatmap=True,
        modulate_kernel=11))
data_cfg = dict(
    image_size=[192, 256],
    heatmap_size=[48, 64],
    num_output_channels=17,
    num_joints=17,
    dataset_channel=[[
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
    ]],
    inference_channel=[
        0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
    ],
    soft_nms=False,
    nms_thr=1.0,
    oks_thr=0.9,
    vis_thr=0.2,
    use_gt_bbox=False,# 测试时是否使用人工标注的边界框
    det_bbox_thr=0.0,  # 检测到的边界框分数的阈值。当 'use_gt_bbox=True' 时使用
    bbox_file=
    'data/coco/person_detection_results/COCO_val2017_detections_AP_H_56_person.json'# 边界框检测文件的路径
)
train_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='TopDownRandomFlip', flip_prob=0.5),
    dict(
        type='TopDownHalfBodyTransform',
        num_joints_half_body=8,
        prob_half_body=0.3),
    dict(
        type='TopDownGetRandomScaleRotation', rot_factor=40, scale_factor=0.5),
    dict(type='TopDownAffine'),
    dict(type='ToTensor'),
    dict(
        type='NormalizeTensor',
        mean=[0.485, 0.456, 0.406],
        std=[0.229, 0.224, 0.225]),
    dict(type='TopDownGenerateTarget', sigma=2),
    dict(
        type='Collect',
        keys=['img', 'target', 'target_weight'],
        meta_keys=[
            'image_file', 'joints_3d', 'joints_3d_visible', 'center', 'scale',
            'rotation', 'bbox_score', 'flip_pairs'
        ])
]
val_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='TopDownAffine'),
    dict(type='ToTensor'),
    dict(
        type='NormalizeTensor',
        mean=[0.485, 0.456, 0.406],
        std=[0.229, 0.224, 0.225]),
    dict(
        type='Collect',
        keys=['img'],
        meta_keys=[
            'image_file', 'center', 'scale', 'rotation', 'bbox_score',
            'flip_pairs'
        ])
]
test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='TopDownAffine'),
    dict(type='ToTensor'),
    dict(
        type='NormalizeTensor',
        mean=[0.485, 0.456, 0.406],
        std=[0.229, 0.224, 0.225]),
    dict(
        type='Collect',
        keys=['img'],
        meta_keys=[
            'image_file', 'center', 'scale', 'rotation', 'bbox_score',
            'flip_pairs'
        ])
]
data_root = 'data/coco'
data = dict(
    samples_per_gpu=32,
    workers_per_gpu=2,
    val_dataloader=dict(samples_per_gpu=32),
    test_dataloader=dict(samples_per_gpu=32),
    train=dict(
        type='TopDownCocoDataset',
        ann_file='data/coco/annotations/person_keypoints_train2017.json',
        img_prefix='data/coco/train2017/',
        data_cfg=dict(
            image_size=[192, 256],
            heatmap_size=[48, 64],
            num_output_channels=17,
            num_joints=17,
            dataset_channel=[[
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
            ]],
            inference_channel=[
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
            ],
            soft_nms=False,
            nms_thr=1.0,
            oks_thr=0.9,
            vis_thr=0.2,
            use_gt_bbox=False,
            det_bbox_thr=0.0,
            bbox_file=
            'data/coco/person_detection_results/COCO_val2017_detections_AP_H_56_person.json'
        ),
        pipeline=[
            dict(type='LoadImageFromFile'),
            dict(type='TopDownRandomFlip', flip_prob=0.5),
            dict(
                type='TopDownHalfBodyTransform',
                num_joints_half_body=8,
                prob_half_body=0.3),
            dict(
                type='TopDownGetRandomScaleRotation',
                rot_factor=40,
                scale_factor=0.5),
            dict(type='TopDownAffine'),
            dict(type='ToTensor'),
            dict(
                type='NormalizeTensor',
                mean=[0.485, 0.456, 0.406],
                std=[0.229, 0.224, 0.225]),
            dict(type='TopDownGenerateTarget', sigma=2),
            dict(
                type='Collect',
                keys=['img', 'target', 'target_weight'],
                meta_keys=[
                    'image_file', 'joints_3d', 'joints_3d_visible', 'center',
                    'scale', 'rotation', 'bbox_score', 'flip_pairs'
                ])
        ],
        dataset_info=dict(
            dataset_name='coco',
            paper_info=dict(
                author=
                'Lin, Tsung-Yi and Maire, Michael and Belongie, Serge and Hays, James and Perona, Pietro and Ramanan, Deva and Doll{\'a}r, Piotr and Zitnick, C Lawrence',
                title='Microsoft coco: Common objects in context',
                container='European conference on computer vision',
                year='2014',
                homepage='http://cocodataset.org/'),
            keypoint_info=dict({
                0:
                dict(
                    name='nose',
                    id=0,
                    color=[51, 153, 255],
                    type='upper',
                    swap=''),
                1:
                dict(
                    name='left_eye',
                    id=1,
                    color=[51, 153, 255],
                    type='upper',
                    swap='right_eye'),
                2:
                dict(
                    name='right_eye',
                    id=2,
                    color=[51, 153, 255],
                    type='upper',
                    swap='left_eye'),
                3:
                dict(
                    name='left_ear',
                    id=3,
                    color=[51, 153, 255],
                    type='upper',
                    swap='right_ear'),
                4:
                dict(
                    name='right_ear',
                    id=4,
                    color=[51, 153, 255],
                    type='upper',
                    swap='left_ear'),
                5:
                dict(
                    name='left_shoulder',
                    id=5,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_shoulder'),
                6:
                dict(
                    name='right_shoulder',
                    id=6,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_shoulder'),
                7:
                dict(
                    name='left_elbow',
                    id=7,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_elbow'),
                8:
                dict(
                    name='right_elbow',
                    id=8,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_elbow'),
                9:
                dict(
                    name='left_wrist',
                    id=9,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_wrist'),
                10:
                dict(
                    name='right_wrist',
                    id=10,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_wrist'),
                11:
                dict(
                    name='left_hip',
                    id=11,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_hip'),
                12:
                dict(
                    name='right_hip',
                    id=12,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_hip'),
                13:
                dict(
                    name='left_knee',
                    id=13,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_knee'),
                14:
                dict(
                    name='right_knee',
                    id=14,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_knee'),
                15:
                dict(
                    name='left_ankle',
                    id=15,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_ankle'),
                16:
                dict(
                    name='right_ankle',
                    id=16,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_ankle')
            }),
            skeleton_info=dict({
                0:
                dict(
                    link=('left_ankle', 'left_knee'), id=0, color=[0, 255, 0]),
                1:
                dict(link=('left_knee', 'left_hip'), id=1, color=[0, 255, 0]),
                2:
                dict(
                    link=('right_ankle', 'right_knee'),
                    id=2,
                    color=[255, 128, 0]),
                3:
                dict(
                    link=('right_knee', 'right_hip'),
                    id=3,
                    color=[255, 128, 0]),
                4:
                dict(
                    link=('left_hip', 'right_hip'), id=4, color=[51, 153,
                                                                 255]),
                5:
                dict(
                    link=('left_shoulder', 'left_hip'),
                    id=5,
                    color=[51, 153, 255]),
                6:
                dict(
                    link=('right_shoulder', 'right_hip'),
                    id=6,
                    color=[51, 153, 255]),
                7:
                dict(
                    link=('left_shoulder', 'right_shoulder'),
                    id=7,
                    color=[51, 153, 255]),
                8:
                dict(
                    link=('left_shoulder', 'left_elbow'),
                    id=8,
                    color=[0, 255, 0]),
                9:
                dict(
                    link=('right_shoulder', 'right_elbow'),
                    id=9,
                    color=[255, 128, 0]),
                10:
                dict(
                    link=('left_elbow', 'left_wrist'),
                    id=10,
                    color=[0, 255, 0]),
                11:
                dict(
                    link=('right_elbow', 'right_wrist'),
                    id=11,
                    color=[255, 128, 0]),
                12:
                dict(
                    link=('left_eye', 'right_eye'),
                    id=12,
                    color=[51, 153, 255]),
                13:
                dict(link=('nose', 'left_eye'), id=13, color=[51, 153, 255]),
                14:
                dict(link=('nose', 'right_eye'), id=14, color=[51, 153, 255]),
                15:
                dict(
                    link=('left_eye', 'left_ear'), id=15, color=[51, 153,
                                                                 255]),
                16:
                dict(
                    link=('right_eye', 'right_ear'),
                    id=16,
                    color=[51, 153, 255]),
                17:
                dict(
                    link=('left_ear', 'left_shoulder'),
                    id=17,
                    color=[51, 153, 255]),
                18:
                dict(
                    link=('right_ear', 'right_shoulder'),
                    id=18,
                    color=[51, 153, 255])
            }),
            joint_weights=[
                1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.2, 1.2, 1.5, 1.5, 1.0,
                1.0, 1.2, 1.2, 1.5, 1.5
            ],
            sigmas=[
                0.026, 0.025, 0.025, 0.035, 0.035, 0.079, 0.079, 0.072, 0.072,
                0.062, 0.062, 0.107, 0.107, 0.087, 0.087, 0.089, 0.089
            ])),
    val=dict(
        type='TopDownCocoDataset',
        ann_file='data/coco/annotations/person_keypoints_val2017.json',
        img_prefix='data/coco/val2017/',
        data_cfg=dict(
            image_size=[192, 256],
            heatmap_size=[48, 64],
            num_output_channels=17,
            num_joints=17,
            dataset_channel=[[
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
            ]],
            inference_channel=[
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
            ],
            soft_nms=False,
            nms_thr=1.0,
            oks_thr=0.9,
            vis_thr=0.2,
            use_gt_bbox=False,
            det_bbox_thr=0.0,
            bbox_file=
            'data/coco/person_detection_results/COCO_val2017_detections_AP_H_56_person.json'
        ),
        pipeline=[
            dict(type='LoadImageFromFile'),
            dict(type='TopDownAffine'),
            dict(type='ToTensor'),
            dict(
                type='NormalizeTensor',
                mean=[0.485, 0.456, 0.406],
                std=[0.229, 0.224, 0.225]),
            dict(
                type='Collect',
                keys=['img'],
                meta_keys=[
                    'image_file', 'center', 'scale', 'rotation', 'bbox_score',
                    'flip_pairs'
                ])
        ],
        dataset_info=dict(
            dataset_name='coco',
            paper_info=dict(
                author=
                'Lin, Tsung-Yi and Maire, Michael and Belongie, Serge and Hays, James and Perona, Pietro and Ramanan, Deva and Doll{\'a}r, Piotr and Zitnick, C Lawrence',
                title='Microsoft coco: Common objects in context',
                container='European conference on computer vision',
                year='2014',
                homepage='http://cocodataset.org/'),
            keypoint_info=dict({
                0:
                dict(
                    name='nose',
                    id=0,
                    color=[51, 153, 255],
                    type='upper',
                    swap=''),
                1:
                dict(
                    name='left_eye',
                    id=1,
                    color=[51, 153, 255],
                    type='upper',
                    swap='right_eye'),
                2:
                dict(
                    name='right_eye',
                    id=2,
                    color=[51, 153, 255],
                    type='upper',
                    swap='left_eye'),
                3:
                dict(
                    name='left_ear',
                    id=3,
                    color=[51, 153, 255],
                    type='upper',
                    swap='right_ear'),
                4:
                dict(
                    name='right_ear',
                    id=4,
                    color=[51, 153, 255],
                    type='upper',
                    swap='left_ear'),
                5:
                dict(
                    name='left_shoulder',
                    id=5,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_shoulder'),
                6:
                dict(
                    name='right_shoulder',
                    id=6,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_shoulder'),
                7:
                dict(
                    name='left_elbow',
                    id=7,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_elbow'),
                8:
                dict(
                    name='right_elbow',
                    id=8,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_elbow'),
                9:
                dict(
                    name='left_wrist',
                    id=9,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_wrist'),
                10:
                dict(
                    name='right_wrist',
                    id=10,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_wrist'),
                11:
                dict(
                    name='left_hip',
                    id=11,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_hip'),
                12:
                dict(
                    name='right_hip',
                    id=12,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_hip'),
                13:
                dict(
                    name='left_knee',
                    id=13,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_knee'),
                14:
                dict(
                    name='right_knee',
                    id=14,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_knee'),
                15:
                dict(
                    name='left_ankle',
                    id=15,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_ankle'),
                16:
                dict(
                    name='right_ankle',
                    id=16,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_ankle')
            }),
            skeleton_info=dict({
                0:
                dict(
                    link=('left_ankle', 'left_knee'), id=0, color=[0, 255, 0]),
                1:
                dict(link=('left_knee', 'left_hip'), id=1, color=[0, 255, 0]),
                2:
                dict(
                    link=('right_ankle', 'right_knee'),
                    id=2,
                    color=[255, 128, 0]),
                3:
                dict(
                    link=('right_knee', 'right_hip'),
                    id=3,
                    color=[255, 128, 0]),
                4:
                dict(
                    link=('left_hip', 'right_hip'), id=4, color=[51, 153,
                                                                 255]),
                5:
                dict(
                    link=('left_shoulder', 'left_hip'),
                    id=5,
                    color=[51, 153, 255]),
                6:
                dict(
                    link=('right_shoulder', 'right_hip'),
                    id=6,
                    color=[51, 153, 255]),
                7:
                dict(
                    link=('left_shoulder', 'right_shoulder'),
                    id=7,
                    color=[51, 153, 255]),
                8:
                dict(
                    link=('left_shoulder', 'left_elbow'),
                    id=8,
                    color=[0, 255, 0]),
                9:
                dict(
                    link=('right_shoulder', 'right_elbow'),
                    id=9,
                    color=[255, 128, 0]),
                10:
                dict(
                    link=('left_elbow', 'left_wrist'),
                    id=10,
                    color=[0, 255, 0]),
                11:
                dict(
                    link=('right_elbow', 'right_wrist'),
                    id=11,
                    color=[255, 128, 0]),
                12:
                dict(
                    link=('left_eye', 'right_eye'),
                    id=12,
                    color=[51, 153, 255]),
                13:
                dict(link=('nose', 'left_eye'), id=13, color=[51, 153, 255]),
                14:
                dict(link=('nose', 'right_eye'), id=14, color=[51, 153, 255]),
                15:
                dict(
                    link=('left_eye', 'left_ear'), id=15, color=[51, 153,
                                                                 255]),
                16:
                dict(
                    link=('right_eye', 'right_ear'),
                    id=16,
                    color=[51, 153, 255]),
                17:
                dict(
                    link=('left_ear', 'left_shoulder'),
                    id=17,
                    color=[51, 153, 255]),
                18:
                dict(
                    link=('right_ear', 'right_shoulder'),
                    id=18,
                    color=[51, 153, 255])
            }),
            joint_weights=[
                1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.2, 1.2, 1.5, 1.5, 1.0,
                1.0, 1.2, 1.2, 1.5, 1.5
            ],
            sigmas=[
                0.026, 0.025, 0.025, 0.035, 0.035, 0.079, 0.079, 0.072, 0.072,
                0.062, 0.062, 0.107, 0.107, 0.087, 0.087, 0.089, 0.089
            ])),
    test=dict(
        type='TopDownCocoDataset',
        ann_file='data/coco/annotations/person_keypoints_val2017.json',
        img_prefix='data/coco/val2017/',
        data_cfg=dict(
            image_size=[192, 256],
            heatmap_size=[48, 64],
            num_output_channels=17,
            num_joints=17,
            dataset_channel=[[
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
            ]],
            inference_channel=[
                0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
            ],
            soft_nms=False,
            nms_thr=1.0,
            oks_thr=0.9,
            vis_thr=0.2,
            use_gt_bbox=False,
            det_bbox_thr=0.0,
            bbox_file=
            'data/coco/person_detection_results/COCO_val2017_detections_AP_H_56_person.json'
        ),
        pipeline=[
            dict(type='LoadImageFromFile'),
            dict(type='TopDownAffine'),
            dict(type='ToTensor'),
            dict(
                type='NormalizeTensor',
                mean=[0.485, 0.456, 0.406],
                std=[0.229, 0.224, 0.225]),
            dict(
                type='Collect',
                keys=['img'],
                meta_keys=[
                    'image_file', 'center', 'scale', 'rotation', 'bbox_score',
                    'flip_pairs'
                ])
        ],
        dataset_info=dict(
            dataset_name='coco',
            paper_info=dict(
                author=
                'Lin, Tsung-Yi and Maire, Michael and Belongie, Serge and Hays, James and Perona, Pietro and Ramanan, Deva and Doll{\'a}r, Piotr and Zitnick, C Lawrence',
                title='Microsoft coco: Common objects in context',
                container='European conference on computer vision',
                year='2014',
                homepage='http://cocodataset.org/'),
            keypoint_info=dict({
                0:
                dict(
                    name='nose',
                    id=0,
                    color=[51, 153, 255],
                    type='upper',
                    swap=''),
                1:
                dict(
                    name='left_eye',
                    id=1,
                    color=[51, 153, 255],
                    type='upper',
                    swap='right_eye'),
                2:
                dict(
                    name='right_eye',
                    id=2,
                    color=[51, 153, 255],
                    type='upper',
                    swap='left_eye'),
                3:
                dict(
                    name='left_ear',
                    id=3,
                    color=[51, 153, 255],
                    type='upper',
                    swap='right_ear'),
                4:
                dict(
                    name='right_ear',
                    id=4,
                    color=[51, 153, 255],
                    type='upper',
                    swap='left_ear'),
                5:
                dict(
                    name='left_shoulder',
                    id=5,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_shoulder'),
                6:
                dict(
                    name='right_shoulder',
                    id=6,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_shoulder'),
                7:
                dict(
                    name='left_elbow',
                    id=7,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_elbow'),
                8:
                dict(
                    name='right_elbow',
                    id=8,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_elbow'),
                9:
                dict(
                    name='left_wrist',
                    id=9,
                    color=[0, 255, 0],
                    type='upper',
                    swap='right_wrist'),
                10:
                dict(
                    name='right_wrist',
                    id=10,
                    color=[255, 128, 0],
                    type='upper',
                    swap='left_wrist'),
                11:
                dict(
                    name='left_hip',
                    id=11,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_hip'),
                12:
                dict(
                    name='right_hip',
                    id=12,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_hip'),
                13:
                dict(
                    name='left_knee',
                    id=13,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_knee'),
                14:
                dict(
                    name='right_knee',
                    id=14,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_knee'),
                15:
                dict(
                    name='left_ankle',
                    id=15,
                    color=[0, 255, 0],
                    type='lower',
                    swap='right_ankle'),
                16:
                dict(
                    name='right_ankle',
                    id=16,
                    color=[255, 128, 0],
                    type='lower',
                    swap='left_ankle')
            }),
            skeleton_info=dict({
                0:
                dict(
                    link=('left_ankle', 'left_knee'), id=0, color=[0, 255, 0]),
                1:
                dict(link=('left_knee', 'left_hip'), id=1, color=[0, 255, 0]),
                2:
                dict(
                    link=('right_ankle', 'right_knee'),
                    id=2,
                    color=[255, 128, 0]),
                3:
                dict(
                    link=('right_knee', 'right_hip'),
                    id=3,
                    color=[255, 128, 0]),
                4:
                dict(
                    link=('left_hip', 'right_hip'), id=4, color=[51, 153,
                                                                 255]),
                5:
                dict(
                    link=('left_shoulder', 'left_hip'),
                    id=5,
                    color=[51, 153, 255]),
                6:
                dict(
                    link=('right_shoulder', 'right_hip'),
                    id=6,
                    color=[51, 153, 255]),
                7:
                dict(
                    link=('left_shoulder', 'right_shoulder'),
                    id=7,
                    color=[51, 153, 255]),
                8:
                dict(
                    link=('left_shoulder', 'left_elbow'),
                    id=8,
                    color=[0, 255, 0]),
                9:
                dict(
                    link=('right_shoulder', 'right_elbow'),
                    id=9,
                    color=[255, 128, 0]),
                10:
                dict(
                    link=('left_elbow', 'left_wrist'),
                    id=10,
                    color=[0, 255, 0]),
                11:
                dict(
                    link=('right_elbow', 'right_wrist'),
                    id=11,
                    color=[255, 128, 0]),
                12:
                dict(
                    link=('left_eye', 'right_eye'),
                    id=12,
                    color=[51, 153, 255]),
                13:
                dict(link=('nose', 'left_eye'), id=13, color=[51, 153, 255]),
                14:
                dict(link=('nose', 'right_eye'), id=14, color=[51, 153, 255]),
                15:
                dict(
                    link=('left_eye', 'left_ear'), id=15, color=[51, 153,
                                                                 255]),
                16:
                dict(
                    link=('right_eye', 'right_ear'),
                    id=16,
                    color=[51, 153, 255]),
                17:
                dict(
                    link=('left_ear', 'left_shoulder'),
                    id=17,
                    color=[51, 153, 255]),
                18:
                dict(
                    link=('right_ear', 'right_shoulder'),
                    id=18,
                    color=[51, 153, 255])
            }),
            joint_weights=[
                1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.2, 1.2, 1.5, 1.5, 1.0,
                1.0, 1.2, 1.2, 1.5, 1.5
            ],
            sigmas=[
                0.026, 0.025, 0.025, 0.035, 0.035, 0.079, 0.079, 0.072, 0.072,
                0.062, 0.062, 0.107, 0.107, 0.087, 0.087, 0.089, 0.089
            ])))
