"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneAssociation = exports.PSTNResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const pstn_function_1 = require("../resources/pstn/pstn-function");
class PSTNResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const PSTNResourceProvider = new custom_resources_1.Provider(this, 'PSTNResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.pstnCustomResource = new aws_cdk_lib_1.CustomResource(this, 'pstnCustomResource', {
            serviceToken: PSTNResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        const constructName = 'PSTNResources';
        const existing = stack.node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        const pstnCustomResourceRole = new aws_iam_1.Role(this, 'pstnCustomResourceRole', {
            description: 'Amazon Chime PSTN Resources',
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateSipRule',
                                'chime:DeleteSipRule',
                                'chime:UpdateSipRule',
                                'chime:GetSipRule',
                                'chime:CreateSipMediaApplication',
                                'chime:DeleteSipMediaApplication',
                                'chime:GetPhoneNumberOrder',
                                'chime:SearchAvailablePhoneNumbers',
                                'chime:CreatePhoneNumberOrder',
                                'chime:DeletePhoneNumber',
                                'chime:GetPhoneNumber',
                                'chime:CreateVoiceConnector',
                                'chime:PutVoiceConnectorStreamingConfiguration',
                                'chime:PutVoiceConnectorTermination',
                                'chime:PutVoiceConnectorOrigination',
                                'chime:PutVoiceConnectorLoggingConfiguration',
                                'chime:ListPhoneNumbers',
                                'chime:AssociatePhoneNumbersWithVoiceConnector',
                                'chime:DisassociatePhoneNumbersFromVoiceConnector',
                                'chime:DeleteVoiceConnector',
                                'chime:PutSipMediaApplicationAlexaSkillConfiguration',
                                'chime:PutSipMediaApplicationLoggingConfiguration',
                                'logs:GetLogDelivery',
                                'logs:DeleteLogDelivery',
                                'logs:ListLogDeliveries',
                                'logs:CreateLogGroup',
                                'logs:DescribeResourcePolicies',
                                'logs:PutResourcePolicy',
                                'logs:DescribeLogGroups',
                                'logs:CreateLogDelivery',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new pstn_function_1.PstnFunction(this, 'pstnResourcesFunction', {
            role: pstnCustomResourceRole,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        // const fn = new Function(this, 'pstnResourcesFunction', {
        //   runtime: Runtime.NODEJS_18_X,
        //   architecture: Architecture.ARM_64,
        //   role: pstnCustomResourceRole,
        //   timeout: Duration.seconds(60),
        //   handler: 'index.handler',
        //   code: Code.fromAsset(path.join(__dirname, '../../src/resources/pstn')),
        // });
        return fn;
    }
}
exports.PSTNResources = PSTNResources;
_a = JSII_RTTI_SYMBOL_1;
PSTNResources[_a] = { fqn: "cdk-amazon-chime-resources.PSTNResources", version: "2.0.12" };
class PhoneAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.phoneAssociationResource = new custom_resources_1.AwsCustomResource(this, 'phoneAssociation', {
            onCreate: {
                service: 'Chime',
                action: 'associatePhoneNumbersWithVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                    ForceAssociate: true,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(aws_cdk_lib_1.Names.uniqueId(this)),
            },
            onDelete: {
                service: 'Chime',
                action: 'disassociatePhoneNumbersFromVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(aws_cdk_lib_1.Names.uniqueId(this)),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.PhoneAssociation = PhoneAssociation;
_b = JSII_RTTI_SYMBOL_1;
PhoneAssociation[_b] = { fqn: "cdk-amazon-chime-resources.PhoneAssociation", version: "2.0.12" };
//# sourceMappingURL=data:application/json;base64,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