"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteVoiceConnector = exports.UpdateVoiceConnector = exports.CreateVoiceConnector = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_voice_1 = require("@aws-sdk/client-chime-sdk-voice");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeSDKVoiceClient = new client_chime_sdk_voice_1.ChimeSDKVoiceClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createVoiceConnectorResponse;
let createVoiceConnectorParams;
let getParameterCommandOutput;
let voiceConnectorId;
let phoneNumbersToDisassociate;
let routes;
let terminationConfiguration;
let streamingConfiguration;
let loggingConfiguration;
let deleteVoiceConnectorResponse;
exports.CreateVoiceConnector = async (uid, props) => {
    console.log(`Creating Voice Connector: ${uid}`);
    console.log(`Create Voice Connector Props: ${JSON.stringify(props)}`);
    createVoiceConnectorParams = {
        Name: props.name,
        RequireEncryption: props.encryption,
        AwsRegion: props.region,
    };
    console.log(`createVoiceConnectorParams: ${JSON.stringify(createVoiceConnectorParams)}`);
    try {
        createVoiceConnectorResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.CreateVoiceConnectorCommand(createVoiceConnectorParams));
        console.log(`createVoiceConnectorResponse: ${JSON.stringify(createVoiceConnectorResponse)}`);
        if (createVoiceConnectorResponse.VoiceConnector &&
            createVoiceConnectorResponse.VoiceConnector.VoiceConnectorId) {
            voiceConnectorId =
                createVoiceConnectorResponse.VoiceConnector?.VoiceConnectorId;
        }
        else {
            throw new Error('Voice Connector failed to create');
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    console.log(`Voice Connector Created: ${voiceConnectorId}`);
    if (props.origination) {
        await putOrigination(voiceConnectorId, props.origination);
    }
    if (props.termination) {
        await putTermination(voiceConnectorId, props.termination);
    }
    if (props.streaming) {
        await putStreaming(voiceConnectorId, props.streaming);
    }
    if (props.logging) {
        await putLogging(voiceConnectorId, props.logging);
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: '/chime/voiceConnector' + uid,
            Value: voiceConnectorId,
            Description: 'Voice Connector ID',
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        voiceConnectorId: voiceConnectorId,
    };
};
exports.UpdateVoiceConnector = async (uid, props) => {
    console.log(`Creating Voice Connector: ${uid}`);
    console.log(`Create Voice Connector Props: ${JSON.stringify(props)}`);
    createVoiceConnectorParams = {
        Name: props.name,
        RequireEncryption: props.encryption,
        AwsRegion: props.region,
    };
    console.log(`updateVoiceConnectorParams: ${JSON.stringify(createVoiceConnectorParams)}`);
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/voiceConnector' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
            voiceConnectorId = getParameterCommandOutput.Parameter.Value;
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    if (props.origination) {
        await putOrigination(voiceConnectorId, props.origination);
    }
    if (props.termination) {
        await putTermination(voiceConnectorId, props.termination);
    }
    if (props.streaming) {
        await putStreaming(voiceConnectorId, props.streaming);
    }
    if (props.logging) {
        await putLogging(voiceConnectorId, props.logging);
    }
};
exports.DeleteVoiceConnector = async (uid) => {
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/voiceConnector' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
            voiceConnectorId = getParameterCommandOutput.Parameter.Value;
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    console.log(`voiceConnectorId to delete: ${voiceConnectorId}`);
    try {
        const phoneNumbersAssociated = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.ListPhoneNumbersCommand({
            FilterName: 'VoiceConnectorId',
            FilterValue: voiceConnectorId,
        }));
        console.log(`phoneNumbers to disassociate:  ${JSON.stringify(phoneNumbersAssociated)}`);
        if (phoneNumbersAssociated.PhoneNumbers &&
            phoneNumbersAssociated.PhoneNumbers.length > 0) {
            phoneNumbersAssociated.PhoneNumbers.forEach(async (phoneNumber) => {
                phoneNumbersToDisassociate.push(phoneNumber.PhoneNumberId);
            });
            console.log(`Disassociate Phone Numbers: ${phoneNumbersToDisassociate}`);
            await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.DisassociatePhoneNumbersFromVoiceConnectorCommand({
                VoiceConnectorId: voiceConnectorId,
                E164PhoneNumbers: phoneNumbersToDisassociate,
            }));
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    console.log(`Deleting Voice Connector: ${voiceConnectorId}`);
    try {
        deleteVoiceConnectorResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.DeleteVoiceConnectorCommand({
            VoiceConnectorId: voiceConnectorId,
        }));
        console.log(`Delete Voice Connector Response: ${deleteVoiceConnectorResponse}`);
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: '/chime/voiceConnector' + uid }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
const putOrigination = async (originationVoiceConnectorId, originations) => {
    console.log(`originations:  ${JSON.stringify(originations)}`);
    routes = [];
    originations.forEach(async (origination) => {
        routes.push({
            Protocol: origination.protocol,
            Host: origination.host,
            Port: parseInt(origination.port),
            Priority: parseInt(origination.priority),
            Weight: parseInt(origination.weight),
        });
    });
    console.log(`routes:  ${JSON.stringify(routes)}`);
    try {
        await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.PutVoiceConnectorOriginationCommand({
            VoiceConnectorId: originationVoiceConnectorId,
            Origination: {
                Routes: routes,
                Disabled: false,
            },
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
const putTermination = async (terminationVoiceConnectorId, termination) => {
    console.log(`termination:  ${JSON.stringify(termination)}`);
    terminationConfiguration = {
        CallingRegions: termination.callingRegions,
        CidrAllowedList: termination.terminationCidrs,
        CpsLimit: parseInt(termination.cpsLimit),
    };
    console.log(`terminationConfiguration:  ${JSON.stringify(terminationConfiguration)}`);
    try {
        await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.PutVoiceConnectorTerminationCommand({
            VoiceConnectorId: terminationVoiceConnectorId,
            Termination: terminationConfiguration,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
const putStreaming = async (streamingVoiceConnectorId, streaming) => {
    console.log(`streaming:  ${JSON.stringify(streaming)}`);
    streamingConfiguration = {
        StreamingNotificationTargets: streaming.notificationTarget,
        Disabled: false,
        DataRetentionInHours: parseInt(streaming.dataRetention),
    };
    console.log(`streamingConfiguration:  ${JSON.stringify(streamingConfiguration)}`);
    try {
        await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.PutVoiceConnectorStreamingConfigurationCommand({
            VoiceConnectorId: streamingVoiceConnectorId,
            StreamingConfiguration: streamingConfiguration,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
const putLogging = async (loggingVoiceConnectorId, logging) => {
    console.log(`logging:  ${JSON.stringify(logging)}`);
    loggingConfiguration = {
        ...(logging.enableSIPLogs && { EnableSIPLogs: logging.enableSIPLogs }),
        ...(logging.enableMediaMetricLogs && {
            EnableMediaMetricLogs: logging.enableMediaMetricLogs,
        }),
    };
    console.log(`loggingConfiguration:  ${JSON.stringify(loggingConfiguration)}`);
    try {
        await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.PutVoiceConnectorLoggingConfigurationCommand({
            VoiceConnectorId: loggingVoiceConnectorId,
            LoggingConfiguration: loggingConfiguration,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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