import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { DeleteMessagingStreamingConfigurationsRequest } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link DeleteMessagingStreamingConfigurationsCommand}.
 */
export interface DeleteMessagingStreamingConfigurationsCommandInput extends DeleteMessagingStreamingConfigurationsRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteMessagingStreamingConfigurationsCommand}.
 */
export interface DeleteMessagingStreamingConfigurationsCommandOutput extends __MetadataBearer {
}
/**
 * @public
 * <p>Deletes the streaming configurations for an <code>AppInstance</code>. For more information, see
 *          <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html">Streaming messaging data</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, DeleteMessagingStreamingConfigurationsCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, DeleteMessagingStreamingConfigurationsCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const command = new DeleteMessagingStreamingConfigurationsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param DeleteMessagingStreamingConfigurationsCommandInput - {@link DeleteMessagingStreamingConfigurationsCommandInput}
 * @returns {@link DeleteMessagingStreamingConfigurationsCommandOutput}
 * @see {@link DeleteMessagingStreamingConfigurationsCommandInput} for command's `input` shape.
 * @see {@link DeleteMessagingStreamingConfigurationsCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class DeleteMessagingStreamingConfigurationsCommand extends $Command<DeleteMessagingStreamingConfigurationsCommandInput, DeleteMessagingStreamingConfigurationsCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: DeleteMessagingStreamingConfigurationsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: DeleteMessagingStreamingConfigurationsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteMessagingStreamingConfigurationsCommandInput, DeleteMessagingStreamingConfigurationsCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
