import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { GetPhoneNumberRequest, GetPhoneNumberResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link GetPhoneNumberCommand}.
 */
export interface GetPhoneNumberCommandInput extends GetPhoneNumberRequest {
}
/**
 * @public
 *
 * The output of {@link GetPhoneNumberCommand}.
 */
export interface GetPhoneNumberCommandOutput extends GetPhoneNumberResponse, __MetadataBearer {
}
export declare class GetPhoneNumberCommand extends $Command<GetPhoneNumberCommandInput, GetPhoneNumberCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: GetPhoneNumberCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: GetPhoneNumberCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetPhoneNumberCommandInput, GetPhoneNumberCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
