import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { GetProxySessionRequest, GetProxySessionResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link GetProxySessionCommand}.
 */
export interface GetProxySessionCommandInput extends GetProxySessionRequest {
}
/**
 * @public
 *
 * The output of {@link GetProxySessionCommand}.
 */
export interface GetProxySessionCommandOutput extends GetProxySessionResponse, __MetadataBearer {
}
export declare class GetProxySessionCommand extends $Command<GetProxySessionCommandInput, GetProxySessionCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: GetProxySessionCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: GetProxySessionCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetProxySessionCommandInput, GetProxySessionCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
