import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { PutVoiceConnectorTerminationCredentialsRequest } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link PutVoiceConnectorTerminationCredentialsCommand}.
 */
export interface PutVoiceConnectorTerminationCredentialsCommandInput extends PutVoiceConnectorTerminationCredentialsRequest {
}
/**
 * @public
 *
 * The output of {@link PutVoiceConnectorTerminationCredentialsCommand}.
 */
export interface PutVoiceConnectorTerminationCredentialsCommandOutput extends __MetadataBearer {
}
export declare class PutVoiceConnectorTerminationCredentialsCommand extends $Command<PutVoiceConnectorTerminationCredentialsCommandInput, PutVoiceConnectorTerminationCredentialsCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: PutVoiceConnectorTerminationCredentialsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: PutVoiceConnectorTerminationCredentialsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<PutVoiceConnectorTerminationCredentialsCommandInput, PutVoiceConnectorTerminationCredentialsCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
