RsInstrument module provides convenient way of communicating with R&S instruments.

Check out the full documentation here: https://rsinstrument.readthedocs.io/

Version history:

	Version 1.8.1.41 (11.10.2020)
	    - Fixed Python 3.8.5+ warnings
	    - Extended documentation, added offline installer
	    - Filled package's __init__ file with the exposed API. This simplifies the import statement. Instead of:
            from RsInstrument.RsInstrument import RsInstrument
            use the following:
            from RsInstrument import *
            This statement also imports user enums, exceptions, and event argument prototypes
	
	Version 1.7.0.37 (01.10.2020)
		- Replaced 'import visa' with 'import pyvisa' to remove Python 3.8 pyvisa warnings
		- Added option to set the termination characters for reading and writing. Until now, it was fixed to '\\n' (Linefeed). Set it in the constructor 'options' string: DriverSetup=(TerminationCharacter = '\\r'). Default value is still '\\n'
		- Added static method RsInstrument.assert_minimum_version() raising assertion exception if the RsInstrument version does not fulfill at minimum the entered version
		- Added 'Hameg' to the list of supported instruments

	Version 1.6.0.32 (21.09.2020)
		- Added documentation on readthedocs.org
		- Code changes only relevant for the auto-generated drivers

	Version 1.5.0.30 (17.09.2020)
		- Added recognition of RsVisa library location for linux when using options string 'SelectVisa=rs'
		- Fixed bug in reading binary data 16 bit

	Version 1.4.0.29 (04.09.2020)
		- Fixed error for instruments that do not support \*OPT? query

	Version 1.3.0.28 (18.08.2020)
		- Implemented SocketIO plugin which allows the remote-control without any VISA installation
		- Implemented finding resources as a static method of the RsInstrument class

	Version 1.2.0.25 (03.08.2020)
		- Fixed reading of long strings for NRP-Zxx sessions

	Version 1.1.0.24 (16.06.2020)
		- Fixed simulation mode switching
		- Added Repeated capability

	Version 1.0.0.21
		- First released version