# Copyright 2016 Mario Graff (https://github.com/mgraffg) and Ranyart R. Suarez (https://github.com/RanyartRodrigo)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import numpy as np


def test_command_line():
    from b4msa.command_line import CommandLine
    import os
    import sys
    fname = os.path.dirname(__file__) + '/text.json'
    c = CommandLine()
    sys.argv = ['b4msa', '-k', '2', fname]
    c.main()
    os.unlink(c.get_output())
    # assert False


def test_nparams():
    from b4msa.command_line import CommandLine
    import os
    import sys
    fname = os.path.dirname(__file__) + '/text.json'
    c = CommandLine()
    sys.argv = ['b4msa', '-k', '2', '-s', '11', fname]
    c.main()
    os.unlink(c.get_output())


def test_main():
    from b4msa.command_line import params
    import os
    import sys
    import tempfile
    output = tempfile.mktemp()
    fname = os.path.dirname(__file__) + '/text.json'
    sys.argv = ['b4msa', '-o', output, '-k', '2', fname]
    params()
    os.unlink(output)


def test_pool():
    from b4msa.command_line import CommandLine
    import os
    import sys
    fname = os.path.dirname(__file__) + '/text.json'
    c = CommandLine()
    sys.argv = ['b4msa', '-k', '2', '-s', '11', '-n', '2', fname]
    c.main()
    os.unlink(c.get_output())


def test_output():
    from b4msa.command_line import CommandLine
    import os
    import sys
    import tempfile
    output = tempfile.mktemp()
    fname = os.path.dirname(__file__) + '/text.json'
    c = CommandLine()
    sys.argv = ['b4msa', '-o', output, '-k', '2', fname]
    c.main()
    assert os.path.isfile(output)
    os.unlink(output)


def test_seed():
    try:
        from mock import MagicMock
    except ImportError:
        from unittest.mock import MagicMock
    from b4msa.command_line import CommandLine
    import os
    import sys
    fname = os.path.dirname(__file__) + '/text.json'
    seed = np.random.seed
    np.random.seed = MagicMock()
    c = CommandLine()
    sys.argv = ['b4msa', '-s', '2', '--seed', '1', '-k', '2', fname]
    c.main()
    os.unlink(c.get_output())
    np.random.seed.assert_called_once_with(1)
    np.random.seed = seed


def test_train():
    from b4msa.command_line import CommandLine, CommandLineTrain
    import os
    import sys
    import tempfile
    output = tempfile.mktemp()
    fname = os.path.dirname(__file__) + '/text.json'
    c = CommandLine()
    sys.argv = ['b4msa', '-o', output, '-k', '2', fname, '-s', '2']
    c.main()
    assert os.path.isfile(output)
    with open(output) as fpt:
        print(fpt.read())
    c = CommandLineTrain()
    sys.argv = ['b4msa', '-m', output, '-k', '2', fname]
    print(c.main())
    os.unlink(output)
    os.unlink(c.get_output())
        

def test_train2():
    from b4msa.command_line import CommandLine, train
    import os
    import sys
    import tempfile
    output = tempfile.mktemp()
    fname = os.path.dirname(__file__) + '/text.json'
    c = CommandLine()
    sys.argv = ['b4msa', '-o', output, '-k', '2', fname, '-s', '2']
    c.main()
    assert os.path.isfile(output)
    output2 = tempfile.mktemp()
    sys.argv = ['b4msa', '-m', output, '-k', '2', fname, '-o', output2]
    train()
    os.unlink(output)
    os.unlink(output2)


def test_test():
    from b4msa.command_line import params, train, test
    import os
    import sys
    import tempfile
    output = tempfile.mktemp()
    fname = os.path.dirname(__file__) + '/text.json'
    sys.argv = ['b4msa', '-o', output, '-k', '2', fname, '-s', '2']
    params()
    sys.argv = ['b4msa', '-m', output, '-k', '2', fname, '-o', output]
    train()
    output2 = tempfile.mktemp()
    sys.argv = ['b4msa', '-m', output, '-k', '2', fname, '-o', output2]
    test()
    os.unlink(output)
    os.unlink(output2)
    
