import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataUpcloudIpAddressesConfig extends cdktf.TerraformMetaArguments {
}
export interface DataUpcloudIpAddressesAddresses {
}
export declare function dataUpcloudIpAddressesAddressesToTerraform(struct?: DataUpcloudIpAddressesAddresses): any;
export declare class DataUpcloudIpAddressesAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataUpcloudIpAddressesAddresses | undefined;
    set internalValue(value: DataUpcloudIpAddressesAddresses | undefined);
    get access(): string;
    get address(): string;
    get family(): string;
    get floating(): cdktf.IResolvable;
    get mac(): string;
    get partOfPlan(): cdktf.IResolvable;
    get ptrRecord(): string;
    get server(): string;
    get zone(): string;
}
export declare class DataUpcloudIpAddressesAddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataUpcloudIpAddressesAddressesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/d/ip_addresses upcloud_ip_addresses}
*/
export declare class DataUpcloudIpAddresses extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "upcloud_ip_addresses";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/d/ip_addresses upcloud_ip_addresses} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataUpcloudIpAddressesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataUpcloudIpAddressesConfig);
    private _addresses;
    get addresses(): DataUpcloudIpAddressesAddressesList;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-upcloud-ip-addresses.d.ts.map