import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataUpcloudTagsConfig extends cdktf.TerraformMetaArguments {
}
export interface DataUpcloudTagsTags {
}
export declare function dataUpcloudTagsTagsToTerraform(struct?: DataUpcloudTagsTags): any;
export declare class DataUpcloudTagsTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataUpcloudTagsTags | undefined;
    set internalValue(value: DataUpcloudTagsTags | undefined);
    get description(): string;
    get name(): string;
    get servers(): string[];
}
export declare class DataUpcloudTagsTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataUpcloudTagsTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/d/tags upcloud_tags}
*/
export declare class DataUpcloudTags extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "upcloud_tags";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/d/tags upcloud_tags} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataUpcloudTagsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataUpcloudTagsConfig);
    get id(): string;
    private _tags;
    get tags(): DataUpcloudTagsTagsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-upcloud-tags.d.ts.map