import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the load balancer to which the backend is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#loadbalancer LoadbalancerBackend#loadbalancer}
    */
    readonly loadbalancer: string;
    /**
    * The name of the backend must be unique within the load balancer service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#name LoadbalancerBackend#name}
    */
    readonly name: string;
    /**
    * Domain Name Resolver used with dynamic type members.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend#resolver_name LoadbalancerBackend#resolver_name}
    */
    readonly resolverName?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend upcloud_loadbalancer_backend}
*/
export declare class LoadbalancerBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_backend upcloud_loadbalancer_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerBackendConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerBackendConfig);
    get id(): string;
    private _loadbalancer?;
    get loadbalancer(): string;
    set loadbalancer(value: string);
    get loadbalancerInput(): string | undefined;
    get members(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resolverName?;
    get resolverName(): string;
    set resolverName(value: string);
    resetResolverName(): void;
    get resolverNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-backend.d.ts.map