import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerDynamicCertificateBundleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Certificate hostnames.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_dynamic_certificate_bundle#hostnames LoadbalancerDynamicCertificateBundle#hostnames}
    */
    readonly hostnames: string[];
    /**
    * Private key type (`rsa` / `ecdsa`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_dynamic_certificate_bundle#key_type LoadbalancerDynamicCertificateBundle#key_type}
    */
    readonly keyType: string;
    /**
    * The name of the bundle must be unique within customer account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_dynamic_certificate_bundle#name LoadbalancerDynamicCertificateBundle#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_dynamic_certificate_bundle upcloud_loadbalancer_dynamic_certificate_bundle}
*/
export declare class LoadbalancerDynamicCertificateBundle extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_dynamic_certificate_bundle";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_dynamic_certificate_bundle upcloud_loadbalancer_dynamic_certificate_bundle} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerDynamicCertificateBundleConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerDynamicCertificateBundleConfig);
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    get hostnamesInput(): string[] | undefined;
    get id(): string;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    get keyTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notAfter(): string;
    get notBefore(): string;
    get operationalState(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-dynamic-certificate-bundle.d.ts.map