import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerManualCertificateBundleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Certificate within base64 string must be in PEM format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_manual_certificate_bundle#certificate LoadbalancerManualCertificateBundle#certificate}
    */
    readonly certificate: string;
    /**
    * Intermediate certificates within base64 string must be in PEM format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_manual_certificate_bundle#intermediates LoadbalancerManualCertificateBundle#intermediates}
    */
    readonly intermediates?: string;
    /**
    * The name of the bundle must be unique within customer account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_manual_certificate_bundle#name LoadbalancerManualCertificateBundle#name}
    */
    readonly name: string;
    /**
    * Private key within base64 string must be in PEM format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_manual_certificate_bundle#private_key LoadbalancerManualCertificateBundle#private_key}
    */
    readonly privateKey: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_manual_certificate_bundle upcloud_loadbalancer_manual_certificate_bundle}
*/
export declare class LoadbalancerManualCertificateBundle extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_manual_certificate_bundle";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_manual_certificate_bundle upcloud_loadbalancer_manual_certificate_bundle} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerManualCertificateBundleConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerManualCertificateBundleConfig);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    get certificateInput(): string | undefined;
    get id(): string;
    private _intermediates?;
    get intermediates(): string;
    set intermediates(value: string);
    resetIntermediates(): void;
    get intermediatesInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notAfter(): string;
    get notBefore(): string;
    get operationalState(): string;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-manual-certificate-bundle.d.ts.map