import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerStaticBackendMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the load balancer backend to which the member is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member#backend LoadbalancerStaticBackendMember#backend}
    */
    readonly backend: string;
    /**
    * Indicates if the member is enabled. Disabled members are excluded from load balancing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member#enabled LoadbalancerStaticBackendMember#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Server IP address in the customer private network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member#ip LoadbalancerStaticBackendMember#ip}
    */
    readonly ip: string;
    /**
    * Maximum number of sessions before queueing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member#max_sessions LoadbalancerStaticBackendMember#max_sessions}
    */
    readonly maxSessions: number;
    /**
    * The name of the member must be unique within the load balancer backend service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member#name LoadbalancerStaticBackendMember#name}
    */
    readonly name: string;
    /**
    * Server port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member#port LoadbalancerStaticBackendMember#port}
    */
    readonly port: number;
    /**
    * Used to adjust the server's weight relative to other servers.
                  All servers will receive a load proportional to their weight relative to the sum of all weights, so the higher the weight, the higher the load.
                  A value of 0 means the server will not participate in load balancing but will still accept persistent connections.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member#weight LoadbalancerStaticBackendMember#weight}
    */
    readonly weight: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member upcloud_loadbalancer_static_backend_member}
*/
export declare class LoadbalancerStaticBackendMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_static_backend_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_static_backend_member upcloud_loadbalancer_static_backend_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerStaticBackendMemberConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerStaticBackendMemberConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    get ipInput(): string | undefined;
    private _maxSessions?;
    get maxSessions(): number;
    set maxSessions(value: number);
    get maxSessionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=loadbalancer-static-backend-member.d.ts.map