import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ManagedDatabaseUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Password for the database user. Defaults to a random value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_user#password ManagedDatabaseUser#password}
    */
    readonly password?: string;
    /**
    * Service's UUID for which this user belongs to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_user#service ManagedDatabaseUser#service}
    */
    readonly service: string;
    /**
    * Name of the database user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_user#username ManagedDatabaseUser#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_user upcloud_managed_database_user}
*/
export declare class ManagedDatabaseUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_managed_database_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/managed_database_user upcloud_managed_database_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ManagedDatabaseUserConfig
    */
    constructor(scope: Construct, id: string, config: ManagedDatabaseUserConfig);
    get id(): string;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    get type(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=managed-database-user.d.ts.map