import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ObjectStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access key used to identify user.
                  Can be set to an empty string, which will tell the provider to get the access key from environment variable.
                  The environment variable should be "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_{name}".
                  {name} is the name given to object storage instance (so not the resource label), it should be all uppercased
                  and all dashes (-) should be replaced with underscores (_). For example, object storage named "my-files" would
                  use environment variable named "UPCLOUD_OBJECT_STORAGE_ACCESS_KEY_MY_FILES".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#access_key ObjectStorage#access_key}
    */
    readonly accessKey: string;
    /**
    * The description of the object storage instance to be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#description ObjectStorage#description}
    */
    readonly description?: string;
    /**
    * The name of the object storage instance to be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#name ObjectStorage#name}
    */
    readonly name: string;
    /**
    * The secret key used to authenticate user.
                  Can be set to an empty string, which will tell the provider to get the secret key from environment variable.
                  The environment variable should be "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_{name}".
                  {name} is the name given to object storage instance (so not the resource label), it should be all uppercased
                  and all dashes (-) should be replaced with underscores (_). For example, object storage named "my-files" would
                  use environment variable named "UPCLOUD_OBJECT_STORAGE_SECRET_KEY_MY_FILES".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#secret_key ObjectStorage#secret_key}
    */
    readonly secretKey: string;
    /**
    * The size of the object storage instance in gigabytes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#size ObjectStorage#size}
    */
    readonly size: number;
    /**
    * The zone in which the object storage instance will be created
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#zone ObjectStorage#zone}
    */
    readonly zone: string;
    /**
    * bucket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#bucket ObjectStorage#bucket}
    */
    readonly bucket?: ObjectStorageBucket[] | cdktf.IResolvable;
}
export interface ObjectStorageBucket {
    /**
    * The name of the bucket
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage#name ObjectStorage#name}
    */
    readonly name: string;
}
export declare function objectStorageBucketToTerraform(struct?: ObjectStorageBucket | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage upcloud_object_storage}
*/
export declare class ObjectStorage extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_object_storage";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/object_storage upcloud_object_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ObjectStorageConfig
    */
    constructor(scope: Construct, id: string, config: ObjectStorageConfig);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    get created(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    get secretKeyInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    get state(): string;
    get url(): string;
    get usedSpace(): number;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _bucket?;
    get bucket(): ObjectStorageBucket[] | cdktf.IResolvable;
    set bucket(value: ObjectStorageBucket[] | cdktf.IResolvable);
    resetBucket(): void;
    get bucketInput(): cdktf.IResolvable | ObjectStorageBucket[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=object-storage.d.ts.map