import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UpcloudProviderConfig {
    /**
    * Password for UpCloud API user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud#password UpcloudProvider#password}
    */
    readonly password: string;
    /**
    * Maximum number of retries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud#retry_max UpcloudProvider#retry_max}
    */
    readonly retryMax?: number;
    /**
    * Maximum time to wait between retries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud#retry_wait_max_sec UpcloudProvider#retry_wait_max_sec}
    */
    readonly retryWaitMaxSec?: number;
    /**
    * Minimum time to wait between retries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud#retry_wait_min_sec UpcloudProvider#retry_wait_min_sec}
    */
    readonly retryWaitMinSec?: number;
    /**
    * UpCloud username with API access
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud#username UpcloudProvider#username}
    */
    readonly username: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud#alias UpcloudProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud upcloud}
*/
export declare class UpcloudProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "upcloud";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud upcloud} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UpcloudProviderConfig
    */
    constructor(scope: Construct, id: string, config: UpcloudProviderConfig);
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    get passwordInput(): string | undefined;
    private _retryMax?;
    get retryMax(): number | undefined;
    set retryMax(value: number | undefined);
    resetRetryMax(): void;
    get retryMaxInput(): number | undefined;
    private _retryWaitMaxSec?;
    get retryWaitMaxSec(): number | undefined;
    set retryWaitMaxSec(value: number | undefined);
    resetRetryWaitMaxSec(): void;
    get retryWaitMaxSecInput(): number | undefined;
    private _retryWaitMinSec?;
    get retryWaitMinSec(): number | undefined;
    set retryWaitMinSec(value: number | undefined);
    resetRetryWaitMinSec(): void;
    get retryWaitMinSecInput(): number | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=upcloud-provider.d.ts.map