/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;

public class ChangesetCommentCheck
extends AbstractLiquibaseBasicForecastRule {
    @Override
    public SeverityEnum getSeverity() {
        return SeverityEnum.MINOR;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet) {
        if (changeSet.getComments() == null || changeSet.getComments().isEmpty()) {
            return this.setResultUnsuccessful("Liquibase recommends that authors include comments about the purpose and impact of a changeset in <comment> elements to prevent the development of tribal knowledge and ensure that the purpose of a given changeset is easily understood by other people who use this changelog.", null);
        }
        return this.setResultSuccessful(true, null);
    }

    @Override
    public String getName() {
        return "Changesets Must Have a Comment Assigned";
    }

    @Override
    public String getDescription() {
        return "This check enforces the Liquibase recommendation that comments be added to each changeset to document the purpose of a changeset for other/future consumers of this changelog";
    }

    @Override
    public String getShortName() {
        return "ChangesetCommentCheck";
    }

    @Override
    public int getPriority() {
        return 176;
    }

    @Override
    public List<DynamicRuleParameterEnum> getParameters() {
        return null;
    }
}

