/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.CustomizeJsonParser;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.SecurityUtils;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobCancelResponse;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.ProjectReference;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.simba.googlebigquery.dsi.exceptions.OperationCanceledException;
import com.simba.googlebigquery.googlebigquery.client.BQGetQueryResultsResponse;
import com.simba.googlebigquery.googlebigquery.client.BQQueryResponse;
import com.simba.googlebigquery.googlebigquery.client.BQServiceKey;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.googlebigquery.utils.BQCustomParser;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.json.JSONObject;

public class BQClient {
    private static final String AUTH_CODE_PROCEDURE_STR = "Please obtain an authorization code from the following URL,\n and input it into the text box: ";
    private static final String AUTH_CODE_REQUIRED_STR = "Authorization Code Required";
    private static final long DATASETLIST_MAXRESULTS = 1000L;
    private static final long DEFAULT_ACCESS_TOKEN_EXPIRATION_MS = 3600000L;
    private static final String ERROR_REASON_RATE_LIMIT_EXCEEDED = "rateLimitExceeded";
    private static final String ERROR_REASON_TABLE_UNAVAILABLE = "tableUnavailable";
    private static final String ERROR_RESPONSE_MESSAGE_KEY = "message";
    private static final long EXPIRE_TIME = 86400000L;
    private static final String HIDDEN_DATASET = "_simba_jdbc";
    private static final int MAX_RETRIES = 5;
    private static final int MAX_HTAPI_STREAMS = 1;
    private static final String OAUTH_ACCESS_TYPE = "offline";
    private static final String OAUTH_APPROVAL_PROMPT = "force";
    private static final String OAUTH_AUTH_URI = "https://accounts.google.com/o/oauth2/auth";
    private static final String OAUTH_REDIRECT_URI = "urn:ietf:wg:oauth:2.0:oob";
    private static final String OAUTH_TOKEN_URI = "https://oauth2.googleapis.com/token";
    private static final String PREFIX_TABLE_NAME = "temp_table_";
    private static final String QUERY_TYPE_DROP_PREFIX = "DROP_";
    private static final String QUERY_TYPE_SCRIPT = "SCRIPT";
    private static final long RETRY_TIMEOUT_MS = 10000L;
    private static final String SCRIPT_OPTION_KEY = "scriptOptions.keyResultStatement";
    private static final String SCRIPT_OPTION_VALUE = "FIRST_SELECT";
    private static final String SIMBA_PREFIX = "SimbaJDBC_Job_";
    private static final long TABLELIST_MAXRESULTS = 1000L;
    private static final String WRITE_TRUNCATE = "WRITE_TRUNCATE";
    private Bigquery m_bqClient;
    private final BQConnectionOptions m_connectionOptions;
    private final ILogger m_connLogger;
    private BigQueryReadClient m_readClient;
    private GoogleCredentials m_bqStorageCredential;
    private ReadSession m_readSession = null;
    private String m_tableReference = null;
    private String m_userAgent = null;

    public BQClient(ILogger iLogger, BQConnectionOptions bQConnectionOptions) {
        this.m_connLogger = iLogger;
        this.m_connectionOptions = bQConnectionOptions;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SimbaJDBCDriverforGoogleBigQuery");
        stringBuilder.append("/");
        stringBuilder.append("1.2");
        stringBuilder.append(" (GPN:Simba;)");
        this.m_userAgent = stringBuilder.toString();
    }

    public JobCancelResponse cancelQuery(final String string, final String string2, final String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                Bigquery.Jobs.Cancel cancel = BQClient.this.m_bqClient.jobs().cancel(string, string2);
                cancel.setLocation(string3);
                return cancel.execute();
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_CANCEL_FAIL_ERR.name(), (Throwable)exception);
            }
        };
        return (JobCancelResponse)requestWithRetry.executeWithRetry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBQResponse executeQuery(String string, ArrayList<QueryParameter> arrayList, String string2, String string3, boolean bl, BQConnectionOptions.QueryDialect queryDialect, String string4, boolean bl2, Object object, AtomicBoolean atomicBoolean) throws ErrorException {
        Object object2;
        Object object3;
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[]{string, string2, string3, bl, queryDialect, null != string4 ? "with CMEK" : "default key", atomicBoolean});
        Job job = null;
        GetQueryResultsResponse getQueryResultsResponse = null;
        QueryResponse queryResponse = null;
        List<JobList.Jobs> list = null;
        boolean bl3 = false;
        long l = 0L;
        if (bl2) {
            object3 = this.setupQueryRequest(string, arrayList, string2, string3, queryDialect);
            try {
                LogUtilities.logDebug("Executing using jobs.query().", this.m_connLogger);
                object2 = this.m_bqClient.jobs().query(string2, (QueryRequest)object3);
                l = System.currentTimeMillis();
                queryResponse = this.executeJobsQuery((Bigquery.Jobs.Query)object2);
            }
            catch (IOException iOException) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_EXECUTION_ERR.name(), this.parseErrorMessage(iOException.getMessage()), (Throwable)iOException);
            }
            if (null != queryResponse && !queryResponse.getJobComplete().booleanValue()) {
                LogUtilities.logInfo("jobs.query execution timed out. Falling back to jobs.getQueryResults().", this.m_connLogger);
                bl3 = true;
            }
        } else {
            LogUtilities.logDebug("Executing using jobs.insert().", this.m_connLogger);
            object3 = object;
            synchronized (object3) {
                if (atomicBoolean.get()) {
                    throw new OperationCanceledException(101, BQMessageKey.EXEC_QUERY_CANCELLED_ERR.name());
                }
                object2 = this.setupInsertJob(string, arrayList, string2, string3, bl, queryDialect, string4);
                l = System.currentTimeMillis();
                job = this.insertJob((Job)object2, string2);
            }
        }
        if (!bl2 || bl3) {
            object3 = bl3 ? queryResponse.getJobReference().getProjectId() : job.getJobReference().getProjectId();
            object2 = bl3 ? queryResponse.getJobReference().getJobId() : job.getJobReference().getJobId();
            String string5 = bl3 ? queryResponse.getJobReference().getLocation() : job.getJobReference().getLocation();
            Object object4 = object;
            synchronized (object4) {
                String string6;
                do {
                    if (!atomicBoolean.get()) {
                        long l2 = System.currentTimeMillis();
                        long l3 = this.m_connectionOptions.m_timeout - (l2 - l);
                        if (0L > l3) {
                            this.cancelQuery(string2, (String)object2, string5);
                            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_TIMEOUT_ERR.name());
                        }
                    } else {
                        this.cancelQuery(string2, (String)object2, string5);
                        throw new OperationCanceledException(101, BQMessageKey.EXEC_QUERY_CANCELLED_ERR.name());
                    }
                    RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger, (String)object3, (String)object2, string5){
                        final /* synthetic */ String val$projId;
                        final /* synthetic */ String val$jobId;
                        final /* synthetic */ String val$location;
                        {
                            this.val$projId = string;
                            this.val$jobId = string2;
                            this.val$location = string3;
                            super(iLogger);
                        }

                        @Override
                        public void throwException(Exception exception) throws ErrorException {
                            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_EXECUTION_ERR.name(), BQClient.this.parseErrorMessage(exception.getMessage()), (Throwable)exception);
                        }

                        @Override
                        public Object execute() throws Exception {
                            return BQClient.this.m_bqClient.jobs().getQueryResults(this.val$projId, this.val$jobId).setTimeoutMs(Long.valueOf(10000L)).setMaxResults(Long.valueOf(((BQClient)BQClient.this).m_connectionOptions.m_maxResults)).setLocation(this.val$location).execute();
                        }
                    };
                    getQueryResultsResponse = (GetQueryResultsResponse)requestWithRetry.executeWithRetry();
                } while (!getQueryResultsResponse.getJobComplete().booleanValue());
                if (!bl2 && ((string6 = job.getStatistics().getQuery().getStatementType()).equalsIgnoreCase(QUERY_TYPE_SCRIPT) || string6.contains(QUERY_TYPE_DROP_PREFIX))) {
                    list = this.retrieveChildJobs(string2, (String)object2);
                }
            }
        }
        if (bl2 && !bl3) {
            return new BQQueryResponse(queryResponse);
        }
        return new BQGetQueryResultsResponse(job, getQueryResultsResponse, list);
    }

    public List<TableFieldSchema> getColumns(final String string, final String string2, final String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string3);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                TableSchema tableSchema = ((Table)BQClient.this.m_bqClient.tables().get(string, string2, string3).execute()).getSchema();
                List list = null;
                if (null != tableSchema) {
                    list = tableSchema.getFields();
                }
                return list;
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_TABLE_ERR.name(), exception.getMessage(), (Throwable)exception);
            }
        };
        return (List)requestWithRetry.executeWithRetry();
    }

    public List<DatasetList> getDatasetLists(final String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                ArrayList<DatasetList> arrayList = new ArrayList<DatasetList>();
                DatasetList datasetList = (DatasetList)BQClient.this.m_bqClient.datasets().list(string).setMaxResults(Long.valueOf(1000L)).execute();
                arrayList.add(datasetList);
                String string2 = datasetList.getNextPageToken();
                while (null != string2) {
                    datasetList = (DatasetList)BQClient.this.m_bqClient.datasets().list(string).setPageToken(string2).setMaxResults(Long.valueOf(1000L)).execute();
                    arrayList.add(datasetList);
                    string2 = datasetList.getNextPageToken();
                }
                return arrayList;
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_DATASET_ERR.name(), exception.getMessage());
            }
        };
        return (List)requestWithRetry.executeWithRetry();
    }

    public ArrayList<String> getProjects() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                String[] stringArray;
                ProjectList projectList = new ProjectList();
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = projectList.getNextPageToken();
                do {
                    stringArray = BQClient.this.m_bqClient.projects().list();
                    stringArray.setPageToken(string);
                    projectList = (ProjectList)stringArray.execute();
                    String[] stringArray2 = projectList.getProjects();
                    if (null != stringArray2 && !stringArray2.isEmpty()) {
                        arrayList.addAll(stringArray2.stream().map(ProjectList.Projects::getProjectReference).map(ProjectReference::getProjectId).collect(Collectors.toList()));
                        continue;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("projects.list returned 0 projects.");
                    if (null != string && !string.isEmpty()) {
                        stringBuilder.append("\t").append("The nextPageToken for sent request: ").append(string).append(". ").append("The previous call returned an invalid page token.");
                    }
                    if (null != projectList.getNextPageToken() && !projectList.getNextPageToken().isEmpty()) {
                        stringBuilder.append("\t").append("The nextPageToken from received response: ").append(string).append(". ").append("Projects are still expected, but none were returned.");
                    }
                    LogUtilities.logTrace(stringBuilder.toString(), BQClient.this.m_connLogger);
                } while (null != (string = projectList.getNextPageToken()) && !string.isEmpty());
                if (null != ((BQClient)BQClient.this).m_connectionOptions.m_additionalProjects && 0 != (stringArray = ((BQClient)BQClient.this).m_connectionOptions.m_additionalProjects.trim().split(",")).length) {
                    for (String string2 : stringArray) {
                        if (string2.isEmpty()) continue;
                        try {
                            DatasetList datasetList = (DatasetList)BQClient.this.m_bqClient.datasets().list(string2).setMaxResults(Long.valueOf(1L)).execute();
                            if (null == datasetList) continue;
                            arrayList.add(string2);
                        }
                        catch (IOException iOException) {
                            String string3 = iOException.getMessage();
                            if (null == string3) continue;
                            LogUtilities.logWarning(string3, BQClient.this.m_connLogger);
                        }
                    }
                }
                return arrayList;
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_PROJECTLIST_OBJ_ERR.name(), exception.getMessage());
            }
        };
        return (ArrayList)requestWithRetry.executeWithRetry();
    }

    public GetQueryResultsResponse getQueryResults(String string, String string2, String string3, String string4, long l, long l2, BQBufferManager bQBufferManager) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string4, l, l2, bQBufferManager);
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff.Builder().setMaxElapsedTimeMillis((int)l).build();
        int n = 1;
        boolean bl = false;
        HttpResponse httpResponse = null;
        GetQueryResultsResponse getQueryResultsResponse = null;
        do {
            try {
                if (1 != n) {
                    this.waitToRetryOrStop(exponentialBackOff, false, null, null, null);
                }
                Bigquery.Jobs.GetQueryResults getQueryResults = this.m_bqClient.jobs().getQueryResults(string2, string).setLocation(string3).setTimeoutMs(Long.valueOf(l));
                getQueryResults.setMaxResults(Long.valueOf(l2));
                if (null != string4) {
                    getQueryResults.setPageToken(string4);
                }
                httpResponse = getQueryResults.executeUnparsed();
                JsonParser jsonParser = JacksonFactory.getDefaultInstance().createJsonParser(httpResponse.getContent(), httpResponse.getContentCharset());
                BQCustomParser bQCustomParser = new BQCustomParser(bQBufferManager);
                getQueryResultsResponse = (GetQueryResultsResponse)jsonParser.parse(GetQueryResultsResponse.class, true, (CustomizeJsonParser)bQCustomParser);
                if (null != bQCustomParser.getException()) {
                    throw bQCustomParser.getException();
                }
                bl = false;
            }
            catch (Exception exception) {
                if (5 >= n) {
                    LogUtilities.logTrace(exception, this.m_connLogger);
                    bl = true;
                }
                if (exception instanceof ErrorException) {
                    throw (ErrorException)exception;
                }
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_GET_RESPONSE_ERR.name(), (Throwable)exception);
            }
            ++n;
        } while (bl);
        return getQueryResultsResponse;
    }

    public Table getTable(final String string, final String string2, final String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string3);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                return BQClient.this.m_bqClient.tables().get(string, string2, string3).execute();
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_TABLE_ERR.name(), exception.getMessage(), (Throwable)exception);
            }
        };
        return (Table)requestWithRetry.executeWithRetry();
    }

    public List<TableList> getTableList(final String string, final String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                Object object;
                DatasetList datasetList;
                ArrayList<DatasetList> arrayList = new ArrayList<DatasetList>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (null != string2 && !string2.isEmpty()) {
                    arrayList2.add(string2);
                } else {
                    List<DatasetList> list = BQClient.this.getDatasetLists(string);
                    Iterator<DatasetList> object2 = list.iterator();
                    while (object2.hasNext()) {
                        datasetList = object2.next();
                        object = datasetList.getDatasets();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            DatasetList.Datasets datasets = (DatasetList.Datasets)iterator.next();
                            DatasetReference datasetReference = datasets.getDatasetReference();
                            if (datasetReference == null) continue;
                            arrayList2.add(datasetReference.getDatasetId());
                        }
                    }
                }
                for (String string3 : arrayList2) {
                    datasetList = (TableList)BQClient.this.m_bqClient.tables().list(string, string3).setMaxResults(Long.valueOf(1000L)).execute();
                    arrayList.add(datasetList);
                    object = datasetList.getNextPageToken();
                    while (null != object) {
                        datasetList = (TableList)BQClient.this.m_bqClient.tables().list(string, string3).setPageToken((String)object).setMaxResults(Long.valueOf(1000L)).execute();
                        arrayList.add(datasetList);
                        object = datasetList.getNextPageToken();
                    }
                }
                return arrayList;
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_TABLE_ERR.name(), exception.getMessage(), (Throwable)exception);
            }
        };
        return (List)requestWithRetry.executeWithRetry();
    }

    public Routine getFunction(final String string, final String string2, final String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, string3);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                return BQClient.this.m_bqClient.routines().get(string, string2, string3).execute();
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_FUNCTION_ERR.name(), exception.getMessage(), (Throwable)exception);
            }
        };
        return (Routine)requestWithRetry.executeWithRetry();
    }

    public List<ListRoutinesResponse> getFunctionList(final String string, final String string2, final String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                Object object;
                DatasetList datasetList;
                ArrayList<DatasetList> arrayList = new ArrayList<DatasetList>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (null != string2 && !string2.isEmpty()) {
                    arrayList2.add(string2);
                } else {
                    List<DatasetList> list = BQClient.this.getDatasetLists(string);
                    Iterator<DatasetList> object2 = list.iterator();
                    while (object2.hasNext()) {
                        datasetList = object2.next();
                        object = datasetList.getDatasets();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            DatasetList.Datasets datasets = (DatasetList.Datasets)iterator.next();
                            DatasetReference datasetReference = datasets.getDatasetReference();
                            if (datasetReference == null) continue;
                            arrayList2.add(datasetReference.getDatasetId());
                        }
                    }
                }
                for (String string4 : arrayList2) {
                    datasetList = (ListRoutinesResponse)BQClient.this.m_bqClient.routines().list(string, string4).set("filter", (Object)string3).set("readMask", (Object)"routineReference,arguments,returnType").setMaxResults(Long.valueOf(1000L)).execute();
                    arrayList.add(datasetList);
                    object = datasetList.getNextPageToken();
                    while (null != object) {
                        datasetList = (ListRoutinesResponse)BQClient.this.m_bqClient.routines().list(string, string4).setPageToken((String)object).setMaxResults(Long.valueOf(1000L)).execute();
                        arrayList.add(datasetList);
                        object = datasetList.getNextPageToken();
                    }
                }
                return arrayList;
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_FUNCTION_ERR.name(), exception.getMessage(), (Throwable)exception);
            }
        };
        return (List)requestWithRetry.executeWithRetry();
    }

    public Job prepare(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        Job job = this.createJobAndPopulateJobId(string2);
        JobConfiguration jobConfiguration = new JobConfiguration();
        JobConfigurationQuery jobConfigurationQuery = new JobConfigurationQuery();
        jobConfigurationQuery.setQuery(string);
        jobConfigurationQuery.setParameterMode("POSITIONAL");
        jobConfigurationQuery.setUseLegacySql(Boolean.valueOf(false));
        if (!this.m_connectionOptions.m_queryProperties.isEmpty()) {
            jobConfigurationQuery.setConnectionProperties(this.m_connectionOptions.m_queryProperties);
        }
        this.setDefaultDataSet(jobConfigurationQuery, string3);
        jobConfiguration.setQuery(jobConfigurationQuery);
        jobConfiguration.setDryRun(Boolean.valueOf(true));
        job.setConfiguration(jobConfiguration);
        job = this.insertJob(job, string2);
        return job;
    }

    public void applicationDefaultOAuth(BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        GoogleCredential googleCredential = null;
        JacksonFactory jacksonFactory = JacksonFactory.getDefaultInstance();
        HttpTransport httpTransport = this.createHttpTransport(trustStoreSettings, proxySettings);
        try {
            googleCredential = GoogleCredential.getApplicationDefault((HttpTransport)httpTransport, (JsonFactory)jacksonFactory);
        }
        catch (IOException iOException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_APPLICATION_DEFAULT_ERR.name(), (Throwable)iOException);
        }
        if (googleCredential.createScopedRequired()) {
            googleCredential = googleCredential.createScoped(Collections.singleton("https://www.googleapis.com/auth/bigquery"));
        }
        googleCredential = googleCredential.createScoped(this.getScopes());
        this.createAndTestClient((Credential)googleCredential, (JsonFactory)jacksonFactory, httpTransport);
        if (this.m_connectionOptions.m_forceHTAPI || this.m_connectionOptions.m_enableHighThroughPutAPI) {
            BQJTransportFactory bQJTransportFactory = new BQJTransportFactory(trustStoreSettings, proxySettings);
            try {
                this.m_bqStorageCredential = GoogleCredentials.getApplicationDefault((HttpTransportFactory)bQJTransportFactory);
            }
            catch (IOException iOException) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_BIGQUERYSTORAGECLIENT_OAUTH_TOKEN_ERR.name(), BQConnectionOptions.OAuthMechanism.APPLICATION_DEFAULT_CREDENTIALS.name(), (Throwable)iOException);
            }
            this.createBigQueryStorageClient();
        }
    }

    public void serviceAccountOAuth(String string, BQServiceKey bQServiceKey, BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        GoogleCredential googleCredential;
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        JacksonFactory jacksonFactory = JacksonFactory.getDefaultInstance();
        HttpTransport httpTransport = this.createHttpTransport(trustStoreSettings, proxySettings);
        try {
            switch (bQServiceKey.getType()) {
                case JSON: {
                    googleCredential = GoogleCredential.fromStream((InputStream)new FileInputStream(bQServiceKey.getKey()), (HttpTransport)httpTransport, (JsonFactory)jacksonFactory);
                    break;
                }
                case P12: {
                    googleCredential = new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory((JsonFactory)jacksonFactory).setServiceAccountId(string).setServiceAccountPrivateKeyFromP12File(new File(bQServiceKey.getKey())).build();
                    break;
                }
                case PLAINTEXT: {
                    googleCredential = GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(bQServiceKey.getKey().getBytes()), (HttpTransport)httpTransport, (JsonFactory)jacksonFactory);
                    break;
                }
                default: {
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_INVALID_PVT_KEY_FILE.name());
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_SECURITY_ERR.name(), generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        catch (IOException iOException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), iOException.getMessage(), (Throwable)iOException);
        }
        googleCredential = googleCredential.createScoped(this.getScopes());
        this.createAndTestClient((Credential)googleCredential, (JsonFactory)jacksonFactory, httpTransport);
        if (this.m_connectionOptions.m_forceHTAPI || this.m_connectionOptions.m_enableHighThroughPutAPI) {
            this.serviceAccountOAuthBQStorageClient(string, bQServiceKey, trustStoreSettings, proxySettings);
            this.createBigQueryStorageClient();
        }
    }

    public void tokenMethodOAuth(String string, String string2, String string3, String string4, BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        if ((null == string || string.isEmpty()) && (null == string2 || string2.isEmpty())) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_TOKEN.name());
        }
        TokenResponse tokenResponse = new TokenResponse();
        JacksonFactory jacksonFactory = JacksonFactory.getDefaultInstance();
        HttpTransport httpTransport = this.createHttpTransport(trustStoreSettings, proxySettings);
        GoogleCredential googleCredential = null;
        Date date = this.getAccessTokenExpirationDate(tokenResponse);
        if (null != string && null == string2) {
            tokenResponse.setAccessToken(string);
            googleCredential = new GoogleCredential().setFromTokenResponse(tokenResponse);
        } else {
            if (null == string3 || string3.isEmpty()) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_CLIENT_ID.name());
            }
            if (null == string4 || string4.isEmpty()) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_CLIENT_SECRET.name());
            }
            tokenResponse.setRefreshToken(string2);
            if (null != string) {
                tokenResponse.setAccessToken(string);
            }
            googleCredential = new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory((JsonFactory)jacksonFactory).setClientSecrets(string3, string4).build().setFromTokenResponse(tokenResponse);
        }
        this.createAndTestClient((Credential)googleCredential, (JsonFactory)jacksonFactory, httpTransport);
        if (this.m_connectionOptions.m_forceHTAPI || this.m_connectionOptions.m_enableHighThroughPutAPI) {
            BQJTransportFactory bQJTransportFactory = new BQJTransportFactory(trustStoreSettings, proxySettings);
            UserCredentials.Builder builder = UserCredentials.newBuilder().setClientId(string3).setClientSecret(string4).setTokenServerUri(URI.create(OAUTH_TOKEN_URI)).setHttpTransportFactory((HttpTransportFactory)bQJTransportFactory);
            if (null != string) {
                builder.setAccessToken(new AccessToken(string, date));
            }
            if (null != string2) {
                builder.setRefreshToken(string2);
            }
            this.m_bqStorageCredential = builder.build();
            this.createBigQueryStorageClient();
        }
    }

    public void userAccountOAuth(BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        Credential credential;
        GoogleTokenResponse googleTokenResponse;
        JacksonFactory jacksonFactory;
        HttpTransport httpTransport;
        Object object;
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        GoogleClientSecrets googleClientSecrets = new GoogleClientSecrets();
        GoogleClientSecrets.Details details = new GoogleClientSecrets.Details();
        details.setAuthUri(OAUTH_AUTH_URI).setTokenUri(OAUTH_TOKEN_URI).setClientId(this.m_connectionOptions.m_OAuthClientId).setClientSecret(this.m_connectionOptions.m_OAuthClientSecret);
        googleClientSecrets.setInstalled(details);
        Collection<String> collection = this.getScopes();
        String string = new GoogleAuthorizationCodeRequestUrl(googleClientSecrets, OAUTH_REDIRECT_URI, collection).build();
        JFrame jFrame = new JFrame("Frame");
        jFrame.setDefaultCloseOperation(2);
        String string2 = (String)JOptionPane.showInputDialog(jFrame, AUTH_CODE_PROCEDURE_STR, AUTH_CODE_REQUIRED_STR, -1, null, null, string);
        jFrame.dispose();
        jFrame = null;
        try {
            object = null;
            httpTransport = this.createHttpTransport(trustStoreSettings, proxySettings);
            jacksonFactory = new JacksonFactory();
            object = new GoogleAuthorizationCodeFlow.Builder(httpTransport, (JsonFactory)jacksonFactory, googleClientSecrets, collection).setAccessType(OAUTH_ACCESS_TYPE).setApprovalPrompt(OAUTH_APPROVAL_PROMPT).build();
            googleTokenResponse = object.newTokenRequest(string2).setRedirectUri(OAUTH_REDIRECT_URI).execute();
            credential = object.createAndStoreCredential((TokenResponse)googleTokenResponse, null);
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_GOOGLE_AUTH_ERR.name(), (Throwable)exception);
        }
        this.createAndTestClient(credential, (JsonFactory)jacksonFactory, httpTransport);
        if (this.m_connectionOptions.m_forceHTAPI || this.m_connectionOptions.m_enableHighThroughPutAPI) {
            try {
                object = new Date(googleTokenResponse.getExpiresInSeconds() * 1000L);
                BQJTransportFactory bQJTransportFactory = new BQJTransportFactory(trustStoreSettings, proxySettings);
                this.m_bqStorageCredential = UserCredentials.newBuilder().setClientId(this.m_connectionOptions.m_OAuthClientId).setClientSecret(this.m_connectionOptions.m_OAuthClientSecret).setTokenServerUri(URI.create(OAUTH_TOKEN_URI)).setAccessToken(new AccessToken(googleTokenResponse.getAccessToken(), (Date)object)).setRefreshToken(googleTokenResponse.getRefreshToken()).setHttpTransportFactory((HttpTransportFactory)bQJTransportFactory).build();
            }
            catch (Exception exception) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_BIGQUERYSTORAGECLIENT_OAUTH_TOKEN_ERR.name(), BQConnectionOptions.OAuthMechanism.USER_ACCOUNT.name(), (Throwable)exception);
            }
            this.createBigQueryStorageClient();
        }
    }

    public void createBigQueryStorageClient() throws ErrorException {
        try {
            BigQueryJDBCCredentialsProvider bigQueryJDBCCredentialsProvider = new BigQueryJDBCCredentialsProvider();
            GBQHeaderProvider gBQHeaderProvider = new GBQHeaderProvider();
            BigQueryReadSettings.Builder builder = BigQueryReadSettings.newBuilder();
            builder.setCredentialsProvider((CredentialsProvider)bigQueryJDBCCredentialsProvider);
            if (!this.m_connectionOptions.m_highThroughPutRootURL.isEmpty()) {
                builder.setEndpoint(this.m_connectionOptions.m_highThroughPutRootURL);
            }
            builder.setHeaderProvider((HeaderProvider)gBQHeaderProvider);
            this.m_readClient = BigQueryReadClient.create((BigQueryReadSettings)builder.build());
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_BIGQUERYSTORAGECLIENT_OBJ_ERR.name(), this.m_connectionOptions.m_OAuthType.toString(), (Throwable)exception);
        }
    }

    public ReadSession createSession(String string, String string2) throws ErrorException {
        if (null == this.m_tableReference) {
            try {
                this.m_tableReference = this.getTableReference(string, string2);
            }
            catch (GoogleJsonResponseException | ErrorException throwable) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_HTAPI_COPY_DATA_TO_TEMP_ERR.name(), throwable);
            }
        }
        ReadSession.Builder builder = ReadSession.newBuilder().setTable(this.m_tableReference).setDataFormat(DataFormat.AVRO);
        CreateReadSessionRequest createReadSessionRequest = CreateReadSessionRequest.newBuilder().setReadSession(builder).setParent("projects/" + this.m_connectionOptions.m_projectId).setMaxStreamCount(1).build();
        this.m_readSession = this.m_readClient.createReadSession(createReadSessionRequest);
        return this.m_readSession;
    }

    public BigQueryReadClient getBigQueryStorageClient() {
        return this.m_readClient;
    }

    public ReadSession getReadSession() {
        return this.m_readSession;
    }

    public void resetHTAPIVariables() {
        this.m_tableReference = null;
    }

    private void serviceAccountOAuthBQStorageClient(String string, BQServiceKey bQServiceKey, BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        BQJTransportFactory bQJTransportFactory = new BQJTransportFactory(trustStoreSettings, proxySettings);
        try {
            switch (bQServiceKey.getType()) {
                case JSON: {
                    this.m_bqStorageCredential = GoogleCredentials.fromStream((InputStream)new FileInputStream(bQServiceKey.getKey()), (HttpTransportFactory)bQJTransportFactory);
                    break;
                }
                case P12: {
                    PrivateKey privateKey = SecurityUtils.loadPrivateKeyFromKeyStore((KeyStore)SecurityUtils.getPkcs12KeyStore(), (InputStream)new FileInputStream(bQServiceKey.getKey()), (String)"notasecret", (String)"privatekey", (String)"notasecret");
                    this.m_bqStorageCredential = ServiceAccountCredentials.newBuilder().setClientEmail(string).setPrivateKey(privateKey).setHttpTransportFactory((HttpTransportFactory)bQJTransportFactory).build();
                    break;
                }
                case PLAINTEXT: {
                    this.m_bqStorageCredential = GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(bQServiceKey.getKey().getBytes()), (HttpTransportFactory)bQJTransportFactory);
                    break;
                }
                default: {
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_INVALID_PVT_KEY_FILE.name());
                }
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_BIGQUERYSTORAGECLIENT_OAUTH_TOKEN_ERR.name(), BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT.name(), (Throwable)exception);
        }
    }

    private String getTableReference(String string, String string2) throws ErrorException, GoogleJsonResponseException {
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff.Builder().setMaxElapsedTimeMillis((int)this.m_connectionOptions.m_timeout).build();
        Job job = this.getJob(this.m_connectionOptions.m_projectId, string, string2, this.m_connectionOptions.m_timeout - exponentialBackOff.getElapsedTimeMillis());
        TableReference tableReference = job.getConfiguration().getQuery().getDestinationTable();
        return "projects/" + tableReference.getProjectId() + "/datasets/" + tableReference.getDatasetId() + "/tables/" + tableReference.getTableId();
    }

    private boolean containsErrorReasonOnly(GoogleJsonResponseException googleJsonResponseException, String string) {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[]{googleJsonResponseException, string});
        if (null == googleJsonResponseException.getDetails() || null == googleJsonResponseException.getDetails().getErrors()) {
            return false;
        }
        for (GoogleJsonError.ErrorInfo errorInfo : googleJsonResponseException.getDetails().getErrors()) {
            if (null == errorInfo.getReason() || errorInfo.getReason().equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    private void createAndTestClient(Credential credential, JsonFactory jsonFactory, HttpTransport httpTransport) throws ErrorException {
        Bigquery.Builder builder = new Bigquery.Builder(httpTransport, jsonFactory, (HttpRequestInitializer)credential);
        builder.setApplicationName(this.m_userAgent);
        if (!this.m_connectionOptions.m_rootURL.isEmpty()) {
            builder.setRootUrl(this.m_connectionOptions.m_rootURL);
        }
        this.m_bqClient = builder.build();
        try {
            this.prepare("select 1", this.m_connectionOptions.m_projectId, this.m_connectionOptions.m_defaultDataSet);
        }
        catch (ErrorException errorException) {
            if (errorException.hasMessageParams()) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), errorException.getMessageParams(), (Throwable)errorException);
            }
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name());
        }
    }

    private void createDataset(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string);
        assert (null != string && !string.isEmpty());
        assert (null != string2 && !string2.isEmpty());
        DatasetReference datasetReference = new DatasetReference();
        datasetReference.setProjectId(string).setDatasetId(string2);
        Dataset dataset = new Dataset();
        dataset.setDatasetReference(datasetReference);
        if (string2.equals(HIDDEN_DATASET)) {
            dataset.setDefaultTableExpirationMs(Long.valueOf(86400000L));
        } else {
            dataset.setDefaultTableExpirationMs(Long.valueOf(this.m_connectionOptions.m_largeResultsDatasetExpirationTime));
        }
        if (!this.m_connectionOptions.m_location.isEmpty()) {
            dataset.setLocation(this.m_connectionOptions.m_location);
        }
        this.insertDataset(string, dataset);
    }

    private NetHttpTransport.Builder initializeHttpTransport(BQConnectionOptions.TrustStoreSettings trustStoreSettings, final BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        try {
            Proxy proxy = null;
            if (null != proxySettings) {
                if (null != proxySettings.m_uid) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            PasswordAuthentication passwordAuthentication = null;
                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(proxySettings.m_host) && this.getRequestingPort() == proxySettings.m_port) {
                                passwordAuthentication = new PasswordAuthentication(proxySettings.m_uid, proxySettings.m_pwd.toCharArray());
                            }
                            return passwordAuthentication;
                        }
                    });
                }
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettings.m_host, proxySettings.m_port));
            }
            NetHttpTransport.Builder builder = new NetHttpTransport.Builder().setProxy(proxy);
            if (null != trustStoreSettings) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(trustStoreSettings.m_trustStore);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
                }
                builder.trustCertificatesFromJavaKeyStore((InputStream)fileInputStream, trustStoreSettings.m_trustStorePwd);
            } else {
                builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
            }
            return builder;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_SECURITY_ERR.name(), generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        catch (IOException iOException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), iOException.getMessage(), (Throwable)iOException);
        }
    }

    private HttpTransport createHttpTransport(BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        NetHttpTransport.Builder builder = this.initializeHttpTransport(trustStoreSettings, proxySettings);
        return builder.build();
    }

    private Job createJobAndPopulateJobId(String string) {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string);
        Job job = new Job();
        JobReference jobReference = new JobReference();
        jobReference.setJobId(this.generateJobId());
        if (!this.m_connectionOptions.m_location.isEmpty()) {
            jobReference.setLocation(this.m_connectionOptions.m_location);
        }
        job.setJobReference(jobReference);
        return job;
    }

    private String generateJobId() {
        LogUtilities.logFunctionEntrance(this.m_connLogger, new Object[0]);
        return SIMBA_PREFIX + UUID.randomUUID().toString();
    }

    private void createTempTableForLargeResults(JobConfigurationQuery jobConfigurationQuery, String string) throws ErrorException {
        SimpleDateFormat simpleDateFormat;
        LogUtilities.logFunctionEntrance(this.m_connLogger, jobConfigurationQuery, string);
        String string2 = this.m_connectionOptions.m_largeResultDataset;
        String string3 = this.m_connectionOptions.m_largeResultTable;
        if (null == string2) {
            string2 = HIDDEN_DATASET;
        }
        if (null == string3) {
            simpleDateFormat = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss_SSS");
            string3 = PREFIX_TABLE_NAME + simpleDateFormat.format(new Date()) + "_" + UUID.randomUUID().toString();
        }
        try {
            this.getDataset(string, string2);
        }
        catch (Exception exception) {
            this.createDataset(string, string2);
        }
        simpleDateFormat = new TableReference();
        simpleDateFormat.setProjectId(string).setDatasetId(string2).setTableId(string3);
        jobConfigurationQuery.setDestinationTable((TableReference)simpleDateFormat).setAllowLargeResults(Boolean.valueOf(true)).setWriteDisposition(WRITE_TRUNCATE);
    }

    private Dataset getDataset(final String string, final String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2);
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public Object execute() throws Exception {
                return BQClient.this.m_bqClient.datasets().get(string, string2).execute();
            }

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_DATASET_ERR.name(), exception.getMessage());
            }
        };
        return (Dataset)requestWithRetry.executeWithRetry();
    }

    public Job getJob(String string, String string2, String string3, long l) throws GoogleJsonResponseException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, string2, l);
        if (0L > l) {
            this.cancelQuery(string, string2, string3);
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_TIMEOUT_ERR.name());
        }
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff.Builder().setMaxElapsedTimeMillis((int)l).build();
        int n = 1;
        boolean bl = false;
        Job job = null;
        do {
            try {
                if (1 != n) {
                    this.waitToRetryOrStop(exponentialBackOff, true, string, string2, string3);
                }
                Bigquery.Jobs.Get get = this.m_bqClient.jobs().get(string, string2);
                get.setLocation(string3);
                job = (Job)get.execute();
                bl = false;
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                if (exception instanceof GoogleJsonResponseException && null != ((GoogleJsonResponseException)((Object)exception)).getDetails()) {
                    GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)((Object)exception);
                    int n2 = googleJsonResponseException.getDetails().getCode();
                    if (404 == n2) {
                        throw googleJsonResponseException;
                    }
                }
                if (5 >= n) {
                    LogUtilities.logTrace(exception, this.m_connLogger);
                    bl = true;
                }
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_GET_ERR.name(), (Throwable)exception);
            }
            ++n;
        } while (bl);
        return job;
    }

    private Collection<String> getScopes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("https://www.googleapis.com/auth/bigquery");
        if (this.m_connectionOptions.m_requestGoogleDriveScope) {
            arrayList.add("https://www.googleapis.com/auth/drive");
        }
        return arrayList;
    }

    private void insertDataset(String string, Dataset dataset) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, string, dataset);
        try {
            this.m_bqClient.datasets().insert(string, dataset).execute();
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_DATASET_ERR.name(), exception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Job insertJob(Job job, String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, job, string);
        Bigquery.Jobs.Insert insert = null;
        Job job2 = null;
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff.Builder().setMaxElapsedTimeMillis((int)this.m_connectionOptions.m_timeout).build();
        boolean bl = true;
        int n = 1;
        do {
            try {
                if (1 != n) {
                    LogUtilities.logTrace("Try " + n + "/" + 5, this.m_connLogger);
                    this.waitToRetryOrStop(exponentialBackOff, false, null, null, null);
                }
                insert = this.m_bqClient.jobs().insert(string, job);
                insert.setProjectId(string);
                job2 = (Job)insert.execute();
                ErrorProto errorProto = job2.getStatus().getErrorResult();
                if (null != errorProto) {
                    if (5 < n || !this.shouldBeRetried(errorProto)) throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_EXECUTION_ERR.name(), errorProto.getMessage());
                    job.getJobReference().setJobId(this.generateJobId());
                    bl = true;
                } else {
                    bl = false;
                }
            }
            catch (GoogleJsonResponseException googleJsonResponseException) {
                if (null == googleJsonResponseException.getDetails()) {
                    this.throwExecException((Exception)((Object)googleJsonResponseException));
                }
                if (5 >= n) {
                    int n2 = googleJsonResponseException.getDetails().getCode();
                    if (409 == n2) {
                        block17: {
                            try {
                                job2 = this.getJob(string, job.getJobReference().getJobId(), null, this.m_connectionOptions.m_timeout - exponentialBackOff.getElapsedTimeMillis());
                            }
                            catch (GoogleJsonResponseException googleJsonResponseException2) {
                                if (null == googleJsonResponseException2.getDetails()) {
                                    this.throwExecException((Exception)((Object)googleJsonResponseException2));
                                    break block17;
                                }
                                if (404 != googleJsonResponseException2.getDetails().getCode()) break block17;
                                this.throwExecException((Exception)((Object)googleJsonResponseException));
                            }
                        }
                        bl = false;
                    }
                    if (this.shouldBeRetried(googleJsonResponseException)) {
                        LogUtilities.logTrace((Exception)((Object)googleJsonResponseException), this.m_connLogger);
                        bl = true;
                    } else {
                        this.throwExecException((Exception)((Object)googleJsonResponseException));
                    }
                }
                this.throwExecException((Exception)((Object)googleJsonResponseException));
            }
            catch (ErrorException errorException) {
                throw errorException;
            }
            catch (Exception exception) {
                if (5 >= n) {
                    LogUtilities.logTrace(exception, this.m_connLogger);
                    bl = true;
                }
                this.throwExecException(exception);
            }
            ++n;
        } while (bl);
        return job2;
    }

    private QueryResponse executeJobsQuery(final Bigquery.Jobs.Query query) throws ErrorException {
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_EXECUTION_ERR.name(), BQClient.this.parseErrorMessage(exception.getMessage()), (Throwable)exception);
            }

            @Override
            public Object execute() throws Exception {
                return query.execute();
            }
        };
        return (QueryResponse)requestWithRetry.executeWithRetry();
    }

    private List<JobList.Jobs> retrieveChildJobs(final String string, final String string2) throws ErrorException {
        RequestWithRetry requestWithRetry = new RequestWithRetry(this.m_connLogger){

            @Override
            public void throwException(Exception exception) throws ErrorException {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_EXECUTION_ERR.name(), exception.getMessage(), (Throwable)exception);
            }

            @Override
            public Object execute() throws Exception {
                JobList jobList;
                ArrayList arrayList = new ArrayList();
                String string3 = null;
                do {
                    if (null == (jobList = (JobList)BQClient.this.m_bqClient.jobs().list(string).setParentJobId(string2).setPageToken(string3).setMaxResults(Long.valueOf(((BQClient)BQClient.this).m_connectionOptions.m_maxResults)).execute()).getJobs()) continue;
                    arrayList.addAll(jobList.getJobs());
                } while (null != (string3 = jobList.getNextPageToken()) && !string3.isEmpty());
                return arrayList;
            }
        };
        List list = (List)requestWithRetry.executeWithRetry();
        if (null != list && !list.isEmpty()) {
            Collections.reverse(list);
        } else {
            list = null;
        }
        return list;
    }

    private void setEncryptionKey(JobConfigurationQuery jobConfigurationQuery, String string) {
        if (null != string) {
            EncryptionConfiguration encryptionConfiguration = new EncryptionConfiguration();
            encryptionConfiguration.setKmsKeyName(string);
            jobConfigurationQuery.setDestinationEncryptionConfiguration(encryptionConfiguration);
        }
    }

    private void setDefaultDataSet(JobConfigurationQuery jobConfigurationQuery, String string) {
        if (null != string) {
            DatasetReference datasetReference = new DatasetReference();
            datasetReference.setDatasetId(string);
            jobConfigurationQuery.setDefaultDataset(datasetReference);
        }
    }

    private Job setupInsertJob(String string, ArrayList<QueryParameter> arrayList, String string2, String string3, boolean bl, BQConnectionOptions.QueryDialect queryDialect, String string4) throws ErrorException {
        JobConfigurationQuery jobConfigurationQuery = new JobConfigurationQuery();
        if (bl) {
            this.createTempTableForLargeResults(jobConfigurationQuery, string2);
        }
        Job job = this.createJobAndPopulateJobId(string2);
        JobConfiguration jobConfiguration = new JobConfiguration();
        jobConfigurationQuery.setQuery(string).setUseQueryCache(Boolean.valueOf(this.m_connectionOptions.m_useQueryCache));
        if (BQConnectionOptions.QueryDialect.SQL == queryDialect) {
            jobConfigurationQuery.setUseLegacySql(Boolean.valueOf(false));
        } else if (BQConnectionOptions.QueryDialect.BIG_QUERY == queryDialect) {
            jobConfigurationQuery.setUseLegacySql(Boolean.valueOf(true));
        }
        if (!arrayList.isEmpty()) {
            jobConfigurationQuery.setParameterMode("POSITIONAL");
            jobConfigurationQuery.setQueryParameters(arrayList);
        }
        if (!this.m_connectionOptions.m_queryProperties.isEmpty()) {
            jobConfigurationQuery.setConnectionProperties(this.m_connectionOptions.m_queryProperties);
        }
        this.setDefaultDataSet(jobConfigurationQuery, string3);
        this.setEncryptionKey(jobConfigurationQuery, string4);
        jobConfigurationQuery.set(SCRIPT_OPTION_KEY, (Object)SCRIPT_OPTION_VALUE);
        jobConfiguration.setQuery(jobConfigurationQuery);
        job.setConfiguration(jobConfiguration);
        return job;
    }

    private QueryRequest setupQueryRequest(String string, ArrayList<QueryParameter> arrayList, String string2, String string3, BQConnectionOptions.QueryDialect queryDialect) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setDryRun(Boolean.valueOf(false));
        queryRequest.setQuery(string);
        queryRequest.setMaxResults(Long.valueOf(this.m_connectionOptions.m_maxResults));
        queryRequest.setUseQueryCache(Boolean.valueOf(this.m_connectionOptions.m_useQueryCache));
        queryRequest.setUseLegacySql(Boolean.valueOf(BQConnectionOptions.QueryDialect.BIG_QUERY == queryDialect));
        if (!arrayList.isEmpty()) {
            queryRequest.setParameterMode("POSITIONAL");
            queryRequest.setQueryParameters(arrayList);
        }
        if (!this.m_connectionOptions.m_queryProperties.isEmpty()) {
            queryRequest.setConnectionProperties(this.m_connectionOptions.m_queryProperties);
        }
        if (null != string3) {
            DatasetReference datasetReference = new DatasetReference();
            datasetReference.setDatasetId(string3);
            queryRequest.setDefaultDataset(datasetReference);
        }
        return queryRequest;
    }

    private boolean shouldBeRetried(GoogleJsonResponseException googleJsonResponseException) {
        int n = googleJsonResponseException.getDetails().getCode();
        if (417 == n || 500 <= n && 599 >= n) {
            return true;
        }
        if (400 == n) {
            return this.containsErrorReasonOnly(googleJsonResponseException, ERROR_REASON_TABLE_UNAVAILABLE);
        }
        if (403 == n) {
            return this.containsErrorReasonOnly(googleJsonResponseException, ERROR_REASON_RATE_LIMIT_EXCEEDED);
        }
        return false;
    }

    private boolean shouldBeRetried(ErrorProto errorProto) {
        boolean bl = false;
        String string = errorProto.getReason();
        if (null != string && (string.equalsIgnoreCase(ERROR_REASON_RATE_LIMIT_EXCEEDED) || string.equalsIgnoreCase(ERROR_REASON_TABLE_UNAVAILABLE))) {
            bl = true;
        }
        return bl;
    }

    private void throwExecException(Exception exception) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_connLogger, exception);
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_EXECUTION_ERR.name(), exception.getMessage());
    }

    private void waitToRetryOrStop(ExponentialBackOff exponentialBackOff, boolean bl, String string, String string2, String string3) throws IOException, ErrorException, InterruptedException {
        long l = exponentialBackOff.nextBackOffMillis();
        if (-1L == l) {
            if (bl) {
                this.cancelQuery(string, string2, string3);
            }
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_TIMEOUT_ERR.name());
        }
        Thread.sleep(l);
    }

    private Date getAccessTokenExpirationDate(TokenResponse tokenResponse) {
        Long l = tokenResponse.getExpiresInSeconds();
        l = null != l ? Long.valueOf(l * 1000L) : Long.valueOf(3600000L);
        return new Date(l);
    }

    private String parseErrorMessage(String string) {
        try {
            String string2 = string.substring(string.indexOf("{"));
            JSONObject jSONObject = new JSONObject(string2);
            return jSONObject.getString(ERROR_RESPONSE_MESSAGE_KEY);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private class GBQHeaderProvider
    implements HeaderProvider {
        private GBQHeaderProvider() {
        }

        public Map<String, String> getHeaders() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("user-agent", BQClient.this.m_userAgent);
            return hashMap;
        }
    }

    private class BQJTransportFactory
    implements HttpTransportFactory {
        NetHttpTransport.Builder m_transportBuilder;

        public BQJTransportFactory(BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
            this.m_transportBuilder = BQClient.this.initializeHttpTransport(trustStoreSettings, proxySettings);
        }

        public HttpTransport create() {
            return this.m_transportBuilder.build();
        }
    }

    private class BigQueryJDBCCredentialsProvider
    implements CredentialsProvider {
        private BigQueryJDBCCredentialsProvider() {
        }

        public Credentials getCredentials() throws IOException {
            BQClient.this.m_bqStorageCredential = BQClient.this.m_bqStorageCredential.createScoped(BQClient.this.getScopes());
            return BQClient.this.m_bqStorageCredential;
        }
    }

    private abstract class RequestWithRetry {
        private final ILogger m_connLogger;

        public RequestWithRetry(ILogger iLogger) {
            this.m_connLogger = iLogger;
        }

        public abstract Object execute() throws Exception;

        public abstract void throwException(Exception var1) throws ErrorException;

        public Object executeWithRetry() throws ErrorException {
            ExponentialBackOff exponentialBackOff = new ExponentialBackOff.Builder().build();
            int n = 1;
            boolean bl = false;
            Object object = null;
            do {
                try {
                    if (1 != n) {
                        BQClient.this.waitToRetryOrStop(exponentialBackOff, false, null, null, null);
                    }
                    object = this.execute();
                    bl = false;
                }
                catch (Exception exception) {
                    if (5 >= n) {
                        LogUtilities.logTrace(exception, this.m_connLogger);
                        bl = true;
                    }
                    this.throwException(exception);
                }
                ++n;
            } while (bl);
            return object;
        }
    }
}

