/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.simba.googlebigquery.googlebigquery.client.BQClient;
import com.simba.googlebigquery.googlebigquery.client.BQGetQueryResultsResponse;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.BQAvroReader;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class BQBufferManager {
    private final BQClient m_client;
    private final BQConnectionOptions m_connectionOptions;
    private String m_jobId = null;
    private String m_location = null;
    private boolean m_keepFetching;
    private final ILogger m_logger;
    private LinkedBlockingQueue<Future<IBQResponse>> m_bufferQueue;
    private LinkedBlockingQueue<GenericRecord> m_recordQueue;
    private ServerStream<ReadRowsResponse> m_stream;
    private ExecutorService m_threadPool;
    private HashSet<String> m_tokensSoFar = new HashSet();
    private boolean m_isHTAPIReading = false;
    private boolean m_firstPageOnlyNeeded;
    private Exception m_stoppedFetchingOnError;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BQBufferManager(ILogger iLogger, BQConnection bQConnection, String string, String string2, IBQResponse iBQResponse) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, bQConnection, string);
        this.m_client = bQConnection.getClient();
        this.m_connectionOptions = bQConnection.getSettings();
        this.m_jobId = string;
        this.m_location = string2;
        this.m_keepFetching = true;
        this.m_logger = iLogger;
        if (this.m_connectionOptions.m_forceHTAPI || this.m_connectionOptions.m_enableHighThroughPutAPI) {
            this.m_firstPageOnlyNeeded = true;
            this.processTheFirstPage(iBQResponse);
        }
        if (this.m_isHTAPIReading) {
            this.m_threadPool = Executors.newFixedThreadPool(1);
            if (null == this.m_stream) throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_STREAM_SET_ERR.name(), "No stream");
            ReadSession readSession = this.m_client.getReadSession();
            Schema schema = new Schema.Parser().parse(readSession.getAvroSchema().getSchema());
            this.m_recordQueue = new LinkedBlockingQueue(100);
            this.m_threadPool.submit(new BQAvroReader(schema, this.m_stream, this, this.m_logger));
            return;
        } else {
            this.m_firstPageOnlyNeeded = false;
            this.m_threadPool = Executors.newFixedThreadPool(this.m_connectionOptions.m_fetchThreadCount);
            this.m_bufferQueue = new LinkedBlockingQueue(this.m_connectionOptions.m_fetchThreadCount * 2);
            String string3 = null != iBQResponse ? iBQResponse.getPageToken() : null;
            this.startFetchingAPageWithToken(string3);
        }
    }

    public void cleanUp() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_threadPool.shutdownNow();
        try {
            this.m_threadPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (null != this.m_bufferQueue && !this.m_bufferQueue.isEmpty()) {
            try {
                Future<IBQResponse> future = this.m_bufferQueue.take();
                if (future.cancel(true)) continue;
                future.get();
            }
            catch (Exception exception) {}
        }
        if (null != this.m_stream) {
            this.m_client.resetHTAPIVariables();
            try {
                this.m_stream.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IBQResponse getNextBuffer() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.isRunning() && this.m_bufferQueue.isEmpty()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_INVALID_GET_NEXT_BUFFER.name());
        }
        try {
            IBQResponse iBQResponse = this.m_bufferQueue.take().get();
            return iBQResponse;
        }
        catch (Exception exception) {
            this.stop();
            this.cleanUp();
            if (exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_BUFFER_GET_ERR.name(), (Throwable)exception);
        }
    }

    public GenericRecord getNextRow() throws ErrorException {
        if (this.m_keepFetching || !this.m_recordQueue.isEmpty()) {
            try {
                return this.m_recordQueue.take();
            }
            catch (InterruptedException interruptedException) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_STREAM_GET_ERR.name(), interruptedException.getMessage(), (Throwable)interruptedException);
            }
        }
        if (null != this.m_stoppedFetchingOnError) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_STREAM_GET_ERR.name(), this.m_stoppedFetchingOnError.getMessage(), (Throwable)this.m_stoppedFetchingOnError);
        }
        return null;
    }

    public void addRow(GenericRecord genericRecord) throws InterruptedException {
        if (null != genericRecord) {
            this.m_recordQueue.put(genericRecord);
        } else {
            this.m_keepFetching = false;
        }
    }

    public void startFetchingAPageWithToken(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        if (this.m_keepFetching && !this.m_tokensSoFar.contains(string)) {
            try {
                this.m_bufferQueue.put(this.m_threadPool.submit(new GetResultsResponse(this, string)));
                this.m_tokensSoFar.add(string);
            }
            catch (Exception exception) {
                this.stop();
                this.cleanUp();
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_BUFFER_SET_ERR.name(), (Throwable)exception);
            }
        }
    }

    public void stop() {
        LogUtilities.logFunctionEntrance(this.m_logger, this.m_keepFetching, this.m_isHTAPIReading);
        this.m_keepFetching = false;
        this.m_isHTAPIReading = false;
    }

    public void stopOnError(Exception exception) {
        LogUtilities.logFunctionEntrance(this.m_logger, this.m_keepFetching, this.m_isHTAPIReading);
        this.m_stoppedFetchingOnError = exception;
        this.m_keepFetching = false;
        this.m_isHTAPIReading = false;
    }

    private synchronized boolean isRunning() {
        return this.m_keepFetching;
    }

    private void processTheFirstPage(IBQResponse iBQResponse) throws ErrorException {
        boolean bl;
        boolean bl2;
        LogUtilities.logFunctionEntrance(this.m_logger, this.m_connectionOptions.m_forceHTAPI);
        GetQueryResultsResponse getQueryResultsResponse = null;
        long l = 0L;
        long l2 = 0L;
        boolean bl3 = bl2 = iBQResponse != null && null != iBQResponse.getRows();
        if (bl2) {
            this.m_keepFetching = true;
            if (null != iBQResponse.getTotalRows()) {
                l = iBQResponse.getTotalRows().longValue();
            }
            if (null != iBQResponse.getRows()) {
                l2 = iBQResponse.getRows().size();
            }
        } else {
            getQueryResultsResponse = this.m_client.getQueryResults(this.m_jobId, this.m_connectionOptions.m_projectId, this.m_location, null, this.m_connectionOptions.m_timeout, this.m_connectionOptions.m_maxResults, this);
            if (null != getQueryResultsResponse) {
                this.m_keepFetching = true;
                l = null != getQueryResultsResponse.getTotalRows() ? getQueryResultsResponse.getTotalRows().longValue() : 0L;
                l2 = null != getQueryResultsResponse.getRows() ? (long)getQueryResultsResponse.getRows().size() : 0L;
            }
        }
        boolean bl4 = l > (long)this.m_connectionOptions.m_highThroughPutMinTableSize;
        boolean bl5 = bl = l2 > 0L && (long)this.m_connectionOptions.m_highThroughPutTotalRowsToFirstPageRowsRatio < l / l2;
        if (this.m_connectionOptions.m_forceHTAPI || bl4 && bl) {
            try {
                this.startReadingWithHTAPI();
                this.m_isHTAPIReading = true;
            }
            catch (Exception exception) {
                ErrorException errorException = BQDriver.s_BQMessages.createGeneralException(BQMessageKey.STORAGE_API_INIT_ERR, exception.getMessage(), (Throwable)exception);
                if (this.m_connectionOptions.m_forceHTAPI || exception instanceof PermissionDeniedException) {
                    throw errorException;
                }
                LogUtilities.logInfo(errorException, this.m_logger);
                LogUtilities.logInfo("Fallback to using the standard API", this.m_logger);
                this.m_isHTAPIReading = false;
            }
        }
        LogUtilities.logInfo("Retrieving data using the " + (this.m_isHTAPIReading ? "Storage API" : "standard API"), this.m_logger);
    }

    public void startReadingWithHTAPI() throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ReadSession readSession = this.m_client.createSession(this.m_jobId, this.m_location);
        int n = readSession.getStreamsCount();
        if (1 != n) {
            this.m_client.resetHTAPIVariables();
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_STREAM_GET_ERR.name(), "Unexpected number of stream returned. Returned " + n + " but expected 1");
        }
        this.initStream(readSession.getStreams(0).getName());
    }

    public boolean isHTAPIReading() {
        return this.m_isHTAPIReading;
    }

    public boolean isFirstPageOnlyNeeded() {
        return this.m_firstPageOnlyNeeded;
    }

    private void initStream(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            StreamReader streamReader = new StreamReader(this.m_client.getBigQueryStorageClient(), string);
            this.m_stream = streamReader.call();
        }
        catch (Exception exception) {
            this.stop();
            this.cleanUp();
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_STREAM_SET_ERR.name(), (Throwable)exception);
        }
    }

    private class StreamReader
    implements Callable<ServerStream<ReadRowsResponse>> {
        private BigQueryReadClient m_readClient;
        private String m_streamName;

        public StreamReader(BigQueryReadClient bigQueryReadClient, String string) {
            this.m_readClient = bigQueryReadClient;
            this.m_streamName = string;
        }

        @Override
        public ServerStream<ReadRowsResponse> call() throws Exception {
            ReadRowsRequest readRowsRequest = ReadRowsRequest.newBuilder().setReadStream(this.m_streamName).build();
            ServerStream serverStream = this.m_readClient.readRowsCallable().call((Object)readRowsRequest);
            return serverStream;
        }
    }

    private class GetResultsResponse
    implements Callable<IBQResponse> {
        private BQBufferManager m_bufferManager;
        private String m_pageToken;

        private GetResultsResponse(BQBufferManager bQBufferManager2, String string) {
            LogUtilities.logFunctionEntrance(BQBufferManager.this.m_logger, bQBufferManager2, string);
            this.m_bufferManager = bQBufferManager2;
            this.m_pageToken = string;
        }

        @Override
        public IBQResponse call() throws ErrorException {
            LogUtilities.logFunctionEntrance(BQBufferManager.this.m_logger, this.m_pageToken);
            GetQueryResultsResponse getQueryResultsResponse = BQBufferManager.this.m_client.getQueryResults(BQBufferManager.this.m_jobId, ((BQBufferManager)BQBufferManager.this).m_connectionOptions.m_projectId, BQBufferManager.this.m_location, this.m_pageToken, ((BQBufferManager)BQBufferManager.this).m_connectionOptions.m_timeout, ((BQBufferManager)BQBufferManager.this).m_connectionOptions.m_maxResults, this.m_bufferManager);
            return new BQGetQueryResultsResponse(null, getQueryResultsResponse);
        }
    }
}

