/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.license.validators;

import com.simba.googlebigquery.license.interfaces.IValidationInfoProvider;
import com.simba.googlebigquery.license.interfaces.IValidator;
import com.simba.googlebigquery.license.interfaces.LicenseInfo;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureValidator
implements IValidator {
    @Override
    public boolean validate(IValidationInfoProvider iValidationInfoProvider, ArrayList<String> arrayList) {
        boolean bl = false;
        LicenseInfo licenseInfo = iValidationInfoProvider.getLicenseInfo();
        RSAPublicKey rSAPublicKey = licenseInfo.getLicenseType().equals("Evaluation") ? iValidationInfoProvider.getTrialPublicKey() : iValidationInfoProvider.getProductionPublicKey();
        byte[] byArray = licenseInfo.getLicenseInfoAsText().replaceAll("\\s+", "").getBytes();
        byte[] byArray2 = new byte[byArray.length + 8];
        byte[] byArray3 = licenseInfo.getBitMask();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = i < byArray.length ? byArray[i] : byArray3[i - byArray.length];
        }
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(rSAPublicKey);
            signature.update(byArray2);
            bl = signature.verify(iValidationInfoProvider.getLicenseInfo().getLicenseSignature());
            if (!bl) {
                arrayList.add("Invalid signature or license was tampered with");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string = String.format("Internal Licensing error: %s", noSuchAlgorithmException.getMessage());
            arrayList.add(string);
        }
        catch (InvalidKeyException invalidKeyException) {
            String string = String.format("Invalid signature: %s", invalidKeyException.getMessage());
            arrayList.add(string);
        }
        catch (SignatureException signatureException) {
            String string = String.format("Invalid signature: %s", signatureException.getMessage());
            arrayList.add(string);
        }
        return bl;
    }
}

