/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.auth;

import com.amazon.redshift.amazonaws.annotation.SdkInternalApi;
import com.amazon.redshift.amazonaws.annotation.ThreadSafe;
import com.amazon.redshift.amazonaws.auth.SessionCredentialsHolder;
import com.amazon.redshift.amazonaws.internal.SdkPredicate;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
@ThreadSafe
class ShouldDoAsyncSessionRefresh
extends SdkPredicate<SessionCredentialsHolder> {
    private static final long ASYNC_REFRESH_EXPIRATION_IN_MILLIS = TimeUnit.MINUTES.toMillis(5L);

    ShouldDoAsyncSessionRefresh() {
    }

    @Override
    public boolean test(SessionCredentialsHolder sessionCredentialsHolder) {
        Date expiryTime = sessionCredentialsHolder.getSessionCredentialsExpiration();
        if (expiryTime != null) {
            long timeRemaining = expiryTime.getTime() - System.currentTimeMillis();
            return timeRemaining < ASYNC_REFRESH_EXPIRATION_IN_MILLIS;
        }
        return false;
    }
}

