/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.http.apache;

import com.amazon.redshift.amazonaws.annotation.SdkInternalApi;
import com.amazon.redshift.amazonaws.util.StringUtils;
import com.amazon.redshift.shaded.apache.http.HttpException;
import com.amazon.redshift.shaded.apache.http.HttpHost;
import com.amazon.redshift.shaded.apache.http.HttpRequest;
import com.amazon.redshift.shaded.apache.http.impl.conn.DefaultRoutePlanner;
import com.amazon.redshift.shaded.apache.http.impl.conn.DefaultSchemePortResolver;
import com.amazon.redshift.shaded.apache.http.protocol.HttpContext;

@SdkInternalApi
public class SdkProxyRoutePlanner
extends DefaultRoutePlanner {
    private HttpHost proxy;
    private String[] hostPatterns;

    public SdkProxyRoutePlanner(String proxyHost, int proxyPort, String nonProxyHosts) {
        super(DefaultSchemePortResolver.INSTANCE);
        this.proxy = new HttpHost(proxyHost, proxyPort);
        this.parseNonProxyHosts(nonProxyHosts);
    }

    private void parseNonProxyHosts(String nonProxyHosts) {
        if (!StringUtils.isNullOrEmpty(nonProxyHosts)) {
            String[] hosts = nonProxyHosts.split("\\|");
            this.hostPatterns = new String[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                this.hostPatterns[i] = hosts[i].toLowerCase().replace("*", ".*?");
            }
        }
    }

    boolean doesTargetMatchNonProxyHosts(HttpHost target) {
        if (this.hostPatterns == null) {
            return false;
        }
        String targetHost = target.getHostName().toLowerCase();
        for (String pattern : this.hostPatterns) {
            if (!targetHost.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return this.doesTargetMatchNonProxyHosts(target) ? null : this.proxy;
    }
}

