/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.internal.SdkInternalList;
import com.amazon.redshift.amazonaws.services.redshift.model.CreateTagsRequest;
import com.amazon.redshift.amazonaws.services.redshift.model.Tag;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    @Override
    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        SdkInternalList tagsList;
        if (createTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTagsRequest> request = new DefaultRequest<CreateTagsRequest>(createTagsRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateTags");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTagsRequest.getResourceName() != null) {
            request.addParameter("ResourceName", StringUtils.fromString(createTagsRequest.getResourceName()));
        }
        if (!(tagsList = (SdkInternalList)createTagsRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

