/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.services.redshift.model.IPRange;
import com.amazon.redshift.amazonaws.services.redshift.model.Tag;
import com.amazon.redshift.amazonaws.services.redshift.model.transform.TagStaxUnmarshaller;
import com.amazon.redshift.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.redshift.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.redshift.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class IPRangeStaxUnmarshaller
implements Unmarshaller<IPRange, StaxUnmarshallerContext> {
    private static IPRangeStaxUnmarshaller instance;

    @Override
    public IPRange unmarshall(StaxUnmarshallerContext context) throws Exception {
        IPRange iPRange = new IPRange();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return iPRange;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    iPRange.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CIDRIP", targetDepth)) {
                    iPRange.setCIDRIP(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    iPRange.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                iPRange.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return iPRange;
    }

    public static IPRangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IPRangeStaxUnmarshaller();
        }
        return instance;
    }
}

