"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const app = new cdk.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new cdk.Stack(app, 'demo-stack', { env });
const provider = new _1.Provider(stack, 'GithubOpenIdConnectProvider');
provider.createRole('gh-oidc-role', [
    { owner: 'pahud', repo: 'gitpod-workspace' },
    { owner: 'pahud', repo: 'github-codespace' },
    { owner: 'pahud', repo: 'vscode' },
]);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQXFDO0FBQ3JDLHlCQUE4QjtBQUU5QixNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEdBQUcsR0FBRztJQUNWLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQjtJQUN0QyxPQUFPLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUI7Q0FDekMsQ0FBQztBQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsWUFBWSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUV4RCxNQUFNLFFBQVEsR0FBRyxJQUFJLFdBQVEsQ0FBQyxLQUFLLEVBQUUsNkJBQTZCLENBQUMsQ0FBQztBQUNwRSxRQUFRLENBQUMsVUFBVSxDQUFDLGNBQWMsRUFDaEM7SUFDRSxFQUFFLEtBQUssRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLGtCQUFrQixFQUFFO0lBQzVDLEVBQUUsS0FBSyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsa0JBQWtCLEVBQUU7SUFDNUMsRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUU7Q0FDbkMsQ0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgUHJvdmlkZXIgfSBmcm9tICcuLyc7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNvbnN0IGVudiA9IHtcbiAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04sXG4gIGFjY291bnQ6IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX0FDQ09VTlQsXG59O1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnZGVtby1zdGFjaycsIHsgZW52IH0pO1xuXG5jb25zdCBwcm92aWRlciA9IG5ldyBQcm92aWRlcihzdGFjaywgJ0dpdGh1Yk9wZW5JZENvbm5lY3RQcm92aWRlcicpO1xucHJvdmlkZXIuY3JlYXRlUm9sZSgnZ2gtb2lkYy1yb2xlJyxcbiAgW1xuICAgIHsgb3duZXI6ICdwYWh1ZCcsIHJlcG86ICdnaXRwb2Qtd29ya3NwYWNlJyB9LFxuICAgIHsgb3duZXI6ICdwYWh1ZCcsIHJlcG86ICdnaXRodWItY29kZXNwYWNlJyB9LFxuICAgIHsgb3duZXI6ICdwYWh1ZCcsIHJlcG86ICd2c2NvZGUnIH0sXG4gIF0sXG4pOyJdfQ==