import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
/**
 * Represents a GitHub repository.
 *
 * @stability stable
 */
export interface RepositoryConfig {
    /**
     * The owner of the repository.
     *
     * @stability stable
     */
    readonly owner: string;
    /**
     * The name of the repository.
     *
     * @stability stable
     */
    readonly repo: string;
    /**
     * The sub prefix string from the JWT token used to be validated by AWS.
     *
     * Appended after `repo:${owner}/${repo}:`
     * in an IAM role trust relationship. The default value '*' indicates all branches and all tags from this repo.
     *
     * Example:
     * repo:octo-org/octo-repo:ref:refs/heads/demo-branch - only allowed from `demo-branch`
     * repo:octo-org/octo-repo:ref:refs/tags/demo-tag - only allowed from `demo-tag`.
     * repo:octo-org/octo-repo:pull_request - only allowed from the `pull_request` event.
     * repo:octo-org/octo-repo:environment:Production - only allowd from `Production` environment name.
     *
     * @default '*'
     * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect#configuring-the-oidc-trust-with-the-cloud
     * @stability stable
     */
    readonly filter?: string;
}
/**
 * @stability stable
 */
export declare abstract class ProviderBase extends cdk.Resource {
    /**
     * @stability stable
     */
    abstract readonly openIdConnectProvider: iam.IOpenIdConnectProvider;
    /**
     *
     * @param repo a list of repositories
     * @returns a list of subjects
     */
    private formatSubject;
    /**
     * @stability stable
     */
    createRole(id: string, repo: RepositoryConfig[], roleProps?: iam.RoleProps): iam.Role;
}
/**
 * The Github OpenID Connect Provider.
 *
 * @stability stable
 */
export declare class Provider extends ProviderBase {
    /**
     * import the existing provider.
     *
     * @stability stable
     */
    static fromAccount(scope: cdk.Construct, id: string): ProviderBase;
    /**
     * @stability stable
     */
    readonly issuer: string;
    /**
     * @stability stable
     */
    readonly openIdConnectProvider: iam.IOpenIdConnectProvider;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string);
}
