"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = exports.ProviderBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const DEFAULTS = {
    issuer: 'token.actions.githubusercontent.com',
    thumbprint: 'a031c46782e6e6c662c2c87c76da9aa62ccabd8e',
};
/**
 * @stability stable
 */
class ProviderBase extends cdk.Resource {
    /**
     *
     * @param repo a list of repositories
     * @returns a list of subjects
     */
    formatSubject(repo) {
        return repo.map(r => { var _c; return `repo:${r.owner}/${r.repo}:${(_c = r.filter) !== null && _c !== void 0 ? _c : '*'}`; });
    }
    /**
     * @stability stable
     */
    createRole(id, repo, roleProps) {
        if (repo.length == 0) {
            throw new Error('Error - at least one repository is required');
        }
        const role = new iam.Role(this, id, {
            ...roleProps,
            assumedBy: new iam.OpenIdConnectPrincipal(this.openIdConnectProvider, {
                StringLike: {
                    [`${DEFAULTS.issuer}:sub`]: this.formatSubject(repo),
                },
            }),
        });
        return role;
    }
}
exports.ProviderBase = ProviderBase;
_a = JSII_RTTI_SYMBOL_1;
ProviderBase[_a] = { fqn: "@pahud/cdk-github-oidc.ProviderBase", version: "0.0.12" };
/**
 * The Github OpenID Connect Provider.
 *
 * @stability stable
 */
class Provider extends ProviderBase {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id);
        /**
         * @stability stable
         */
        this.issuer = DEFAULTS.issuer;
        this.openIdConnectProvider = new iam.OpenIdConnectProvider(this, `Provider${id}`, {
            url: `https://${DEFAULTS.issuer}`,
            clientIds: ['sts.amazonaws.com'],
            thumbprints: [`${DEFAULTS.thumbprint}`],
        });
    }
    /**
     * import the existing provider.
     *
     * @stability stable
     */
    static fromAccount(scope, id) {
        class Import extends ProviderBase {
            constructor(s, i) {
                super(s, i);
                // arn:aws:iam::xxxxxxxxxxxx:oidc-provider/token.actions.githubusercontent.com
                const arn = cdk.Stack.of(scope).formatArn({
                    resource: 'oidc-provider',
                    service: 'iam',
                    region: '',
                    resourceName: DEFAULTS.issuer,
                });
                this.openIdConnectProvider = iam.OpenIdConnectProvider.fromOpenIdConnectProviderArn(scope, `Provider${id}`, arn);
            }
        }
        return new Import(scope, id);
    }
}
exports.Provider = Provider;
_b = JSII_RTTI_SYMBOL_1;
Provider[_b] = { fqn: "@pahud/cdk-github-oidc.Provider", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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