#
# Copyright © 2012 - 2020 Michal Čihař <michal@cihar.com>
#
# This file is part of Weblate <https://weblate.org/>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

"""License data definitions.

This is an automatically generated file, see scripts/generate-license-data
"""

LICENSES = (
    (
        "Glide",
        "3dfx Glide License",
        "http://www.users.on.net/~triforce/glidexp/COPYING.txt",
        False,
    ),
    (
        "Abstyles",
        "Abstyles License",
        "https://fedoraproject.org/wiki/Licensing/Abstyles",
        False,
    ),
    (
        "AFL-1.1",
        "Academic Free License v1.1",
        "http://opensource.linux-mirror.org/licenses/afl-1.1.txt",
        True,
    ),
    (
        "AFL-1.2",
        "Academic Free License v1.2",
        "http://opensource.linux-mirror.org/licenses/afl-1.2.txt",
        True,
    ),
    (
        "AFL-2.0",
        "Academic Free License v2.0",
        "http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt",
        True,
    ),
    (
        "AFL-2.1",
        "Academic Free License v2.1",
        "http://opensource.linux-mirror.org/licenses/afl-2.1.txt",
        True,
    ),
    (
        "AFL-3.0",
        "Academic Free License v3.0",
        "http://www.rosenlaw.com/AFL3.0.htm",
        True,
    ),
    (
        "AMPAS",
        "Academy of Motion Picture Arts and Sciences BSD",
        "https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD",
        False,
    ),
    (
        "APL-1.0",
        "Adaptive Public License 1.0",
        "https://opensource.org/licenses/APL-1.0",
        True,
    ),
    (
        "Adobe-Glyph",
        "Adobe Glyph List License",
        "https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph",
        False,
    ),
    (
        "APAFML",
        "Adobe Postscript AFM License",
        "https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM",
        False,
    ),
    (
        "Adobe-2006",
        "Adobe Systems Incorporated Source Code License Agreement",
        "https://fedoraproject.org/wiki/Licensing/AdobeLicense",
        False,
    ),
    (
        "AGPL-1.0-only",
        "Affero General Public License v1.0 only",
        "http://www.affero.org/oagpl.html",
        False,
    ),
    (
        "AGPL-1.0-or-later",
        "Affero General Public License v1.0 or later",
        "http://www.affero.org/oagpl.html",
        False,
    ),
    (
        "Afmparse",
        "Afmparse License",
        "https://fedoraproject.org/wiki/Licensing/Afmparse",
        False,
    ),
    (
        "Aladdin",
        "Aladdin Free Public License",
        "http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm",
        False,
    ),
    (
        "ADSL",
        "Amazon Digital Services License",
        "https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense",
        False,
    ),
    (
        "AMDPLPA",
        "AMD's plpa_map.c License",
        "https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License",
        False,
    ),
    (
        "ANTLR-PD",
        "ANTLR Software Rights Notice",
        "http://www.antlr2.org/license.html",
        False,
    ),
    (
        "Apache-1.0",
        "Apache License 1.0",
        "http://www.apache.org/licenses/LICENSE-1.0",
        True,
    ),
    (
        "Apache-1.1",
        "Apache License 1.1",
        "http://apache.org/licenses/LICENSE-1.1",
        True,
    ),
    (
        "Apache-2.0",
        "Apache License 2.0",
        "http://www.apache.org/licenses/LICENSE-2.0",
        True,
    ),
    (
        "AML",
        "Apple MIT License",
        "https://fedoraproject.org/wiki/Licensing/Apple_MIT_License",
        False,
    ),
    (
        "APSL-1.0",
        "Apple Public Source License 1.0",
        "https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0",
        True,
    ),
    (
        "APSL-1.1",
        "Apple Public Source License 1.1",
        "http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE",
        True,
    ),
    (
        "APSL-1.2",
        "Apple Public Source License 1.2",
        "http://www.samurajdata.se/opensource/mirror/licenses/apsl.php",
        True,
    ),
    (
        "APSL-2.0",
        "Apple Public Source License 2.0",
        "http://www.opensource.apple.com/license/apsl/",
        True,
    ),
    (
        "Artistic-1.0",
        "Artistic License 1.0",
        "https://opensource.org/licenses/Artistic-1.0",
        True,
    ),
    (
        "Artistic-1.0-Perl",
        "Artistic License 1.0 (Perl)",
        "http://dev.perl.org/licenses/artistic.html",
        True,
    ),
    (
        "Artistic-1.0-cl8",
        "Artistic License 1.0 w/clause 8",
        "https://opensource.org/licenses/Artistic-1.0",
        True,
    ),
    (
        "Artistic-2.0",
        "Artistic License 2.0",
        "http://www.perlfoundation.org/artistic_license_2_0",
        True,
    ),
    (
        "AAL",
        "Attribution Assurance License",
        "https://opensource.org/licenses/attribution",
        True,
    ),
    (
        "Bahyph",
        "Bahyph License",
        "https://fedoraproject.org/wiki/Licensing/Bahyph",
        False,
    ),
    ("Barr", "Barr License", "https://fedoraproject.org/wiki/Licensing/Barr", False),
    (
        "Beerware",
        "Beerware License",
        "https://fedoraproject.org/wiki/Licensing/Beerware",
        False,
    ),
    (
        "BitTorrent-1.0",
        "BitTorrent Open Source License v1.0",
        "http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s",
        False,
    ),
    (
        "BitTorrent-1.1",
        "BitTorrent Open Source License v1.1",
        "http://directory.fsf.org/wiki/License:BitTorrentOSL1.1",
        True,
    ),
    (
        "BlueOak-1.0.0",
        "Blue Oak Model License 1.0.0",
        "https://blueoakcouncil.org/license/1.0.0",
        False,
    ),
    (
        "BSL-1.0",
        "Boost Software License 1.0",
        "http://www.boost.org/LICENSE_1_0.txt",
        True,
    ),
    (
        "Borceux",
        "Borceux license",
        "https://fedoraproject.org/wiki/Licensing/Borceux",
        False,
    ),
    (
        "BSD-1-Clause",
        "BSD 1-Clause License",
        "https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823",
        True,
    ),
    (
        "BSD-2-Clause",
        'BSD 2-Clause "Simplified" License',
        "https://opensource.org/licenses/BSD-2-Clause",
        True,
    ),
    (
        "BSD-2-Clause-Views",
        "BSD 2-Clause with views sentence",
        "http://www.freebsd.org/copyright/freebsd-license.html",
        False,
    ),
    (
        "BSD-3-Clause",
        'BSD 3-Clause "New" or "Revised" License',
        "https://opensource.org/licenses/BSD-3-Clause",
        True,
    ),
    (
        "BSD-3-Clause-Clear",
        "BSD 3-Clause Clear License",
        "http://labs.metacarta.com/license-explanation.html#license",
        True,
    ),
    (
        "BSD-3-Clause-No-Nuclear-License",
        "BSD 3-Clause No Nuclear License",
        "http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-License-2014",
        "BSD 3-Clause No Nuclear License 2014",
        "https://java.net/projects/javaeetutorial/pages/BerkeleyLicense",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-Warranty",
        "BSD 3-Clause No Nuclear Warranty",
        "https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt",
        False,
    ),
    (
        "BSD-3-Clause-Open-MPI",
        "BSD 3-Clause Open MPI variant",
        "https://www.open-mpi.org/community/license.php",
        False,
    ),
    (
        "BSD-4-Clause",
        'BSD 4-Clause "Original" or "Old" License',
        "http://directory.fsf.org/wiki/License:BSD_4Clause",
        True,
    ),
    (
        "BSD-Protection",
        "BSD Protection License",
        "https://fedoraproject.org/wiki/Licensing/BSD_Protection_License",
        False,
    ),
    (
        "BSD-Source-Code",
        "BSD Source Code Attribution",
        "https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt",
        False,
    ),
    (
        "BSD-3-Clause-Attribution",
        "BSD with attribution",
        "https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution",
        False,
    ),
    ("0BSD", "BSD Zero Clause License", "http://landley.net/toybox/license.html", True),
    (
        "BSD-2-Clause-Patent",
        "BSD-2-Clause Plus Patent License",
        "https://opensource.org/licenses/BSDplusPatent",
        True,
    ),
    (
        "BSD-4-Clause-UC",
        "BSD-4-Clause (University of California-Specific)",
        "http://www.freebsd.org/copyright/license.html",
        False,
    ),
    (
        "bzip2-1.0.5",
        "bzip2 and libbzip2 License v1.0.5",
        "https://sourceware.org/bzip2/1.0.5/bzip2-manual-1.0.5.html",
        False,
    ),
    (
        "bzip2-1.0.6",
        "bzip2 and libbzip2 License v1.0.6",
        "https://sourceware.org/git/?p=bzip2.git;a=blob;f=LICENSE;hb=bzip2-1.0.6",
        False,
    ),
    (
        "Caldera",
        "Caldera License",
        "http://www.lemis.com/grog/UNIX/ancient-source-all.pdf",
        False,
    ),
    (
        "CECILL-1.0",
        "CeCILL Free Software License Agreement v1.0",
        "http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html",
        False,
    ),
    (
        "CECILL-1.1",
        "CeCILL Free Software License Agreement v1.1",
        "http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html",
        False,
    ),
    (
        "CECILL-2.0",
        "CeCILL Free Software License Agreement v2.0",
        "http://www.cecill.info/licences/Licence_CeCILL_V2-en.html",
        True,
    ),
    (
        "CECILL-2.1",
        "CeCILL Free Software License Agreement v2.1",
        "http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html",
        True,
    ),
    (
        "CECILL-B",
        "CeCILL-B Free Software License Agreement",
        "http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html",
        True,
    ),
    (
        "CECILL-C",
        "CeCILL-C Free Software License Agreement",
        "http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html",
        True,
    ),
    (
        "CERN-OHL-1.1",
        "CERN Open Hardware Licence v1.1",
        "https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1",
        False,
    ),
    (
        "CERN-OHL-1.2",
        "CERN Open Hardware Licence v1.2",
        "https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2",
        False,
    ),
    (
        "CERN-OHL-P-2.0",
        "CERN Open Hardware Licence Version 2 - Permissive",
        "https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2",
        False,
    ),
    (
        "CERN-OHL-S-2.0",
        "CERN Open Hardware Licence Version 2 - Strongly Reciprocal",
        "https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2",
        False,
    ),
    (
        "CERN-OHL-W-2.0",
        "CERN Open Hardware Licence Version 2 - Weakly Reciprocal",
        "https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2",
        False,
    ),
    (
        "ClArtistic",
        "Clarified Artistic License",
        "http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/",
        True,
    ),
    (
        "MIT-CMU",
        "CMU License",
        "https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style",
        False,
    ),
    ("CNRI-Jython", "CNRI Jython License", "http://www.jython.org/license.html", False),
    (
        "CNRI-Python",
        "CNRI Python License",
        "https://opensource.org/licenses/CNRI-Python",
        True,
    ),
    (
        "CNRI-Python-GPL-Compatible",
        "CNRI Python Open Source GPL Compatible License Agreement",
        "http://www.python.org/download/releases/1.6.1/download_win/",
        False,
    ),
    (
        "CPOL-1.02",
        "Code Project Open License 1.02",
        "http://www.codeproject.com/info/cpol10.aspx",
        False,
    ),
    (
        "CDDL-1.0",
        "Common Development and Distribution License 1.0",
        "https://opensource.org/licenses/cddl1",
        True,
    ),
    (
        "CDDL-1.1",
        "Common Development and Distribution License 1.1",
        "http://glassfish.java.net/public/CDDL+GPL_1_1.html",
        False,
    ),
    (
        "CPAL-1.0",
        "Common Public Attribution License 1.0",
        "https://opensource.org/licenses/CPAL-1.0",
        True,
    ),
    (
        "CPL-1.0",
        "Common Public License 1.0",
        "https://opensource.org/licenses/CPL-1.0",
        True,
    ),
    (
        "CDLA-Permissive-1.0",
        "Community Data License Agreement Permissive 1.0",
        "https://cdla.io/permissive-1-0",
        False,
    ),
    (
        "CDLA-Sharing-1.0",
        "Community Data License Agreement Sharing 1.0",
        "https://cdla.io/sharing-1-0",
        False,
    ),
    (
        "CATOSL-1.1",
        "Computer Associates Trusted Open Source License 1.1",
        "https://opensource.org/licenses/CATOSL-1.1",
        True,
    ),
    (
        "Condor-1.1",
        "Condor Public License v1.1",
        "http://research.cs.wisc.edu/condor/license.html#condor",
        True,
    ),
    (
        "copyleft-next-0.3.0",
        "copyleft-next 0.3.0",
        "https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0",
        False,
    ),
    (
        "copyleft-next-0.3.1",
        "copyleft-next 0.3.1",
        "https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1",
        False,
    ),
    (
        "CC-BY-1.0",
        "Creative Commons Attribution 1.0 Generic",
        "https://creativecommons.org/licenses/by/1.0/legalcode",
        False,
    ),
    (
        "CC-BY-2.0",
        "Creative Commons Attribution 2.0 Generic",
        "https://creativecommons.org/licenses/by/2.0/legalcode",
        False,
    ),
    (
        "CC-BY-2.5",
        "Creative Commons Attribution 2.5 Generic",
        "https://creativecommons.org/licenses/by/2.5/legalcode",
        False,
    ),
    (
        "CC-BY-3.0-AT",
        "Creative Commons Attribution 3.0 Austria",
        "https://creativecommons.org/licenses/by/3.0/at/legalcode",
        False,
    ),
    (
        "CC-BY-3.0",
        "Creative Commons Attribution 3.0 Unported",
        "https://creativecommons.org/licenses/by/3.0/legalcode",
        False,
    ),
    (
        "CC-BY-4.0",
        "Creative Commons Attribution 4.0 International",
        "https://creativecommons.org/licenses/by/4.0/legalcode",
        True,
    ),
    (
        "CC-BY-ND-1.0",
        "Creative Commons Attribution No Derivatives 1.0 Generic",
        "https://creativecommons.org/licenses/by-nd/1.0/legalcode",
        False,
    ),
    (
        "CC-BY-ND-2.0",
        "Creative Commons Attribution No Derivatives 2.0 Generic",
        "https://creativecommons.org/licenses/by-nd/2.0/legalcode",
        False,
    ),
    (
        "CC-BY-ND-2.5",
        "Creative Commons Attribution No Derivatives 2.5 Generic",
        "https://creativecommons.org/licenses/by-nd/2.5/legalcode",
        False,
    ),
    (
        "CC-BY-ND-3.0",
        "Creative Commons Attribution No Derivatives 3.0 Unported",
        "https://creativecommons.org/licenses/by-nd/3.0/legalcode",
        False,
    ),
    (
        "CC-BY-ND-4.0",
        "Creative Commons Attribution No Derivatives 4.0 International",
        "https://creativecommons.org/licenses/by-nd/4.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-1.0",
        "Creative Commons Attribution Non Commercial 1.0 Generic",
        "https://creativecommons.org/licenses/by-nc/1.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-2.0",
        "Creative Commons Attribution Non Commercial 2.0 Generic",
        "https://creativecommons.org/licenses/by-nc/2.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-2.5",
        "Creative Commons Attribution Non Commercial 2.5 Generic",
        "https://creativecommons.org/licenses/by-nc/2.5/legalcode",
        False,
    ),
    (
        "CC-BY-NC-3.0",
        "Creative Commons Attribution Non Commercial 3.0 Unported",
        "https://creativecommons.org/licenses/by-nc/3.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-4.0",
        "Creative Commons Attribution Non Commercial 4.0 International",
        "https://creativecommons.org/licenses/by-nc/4.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-ND-1.0",
        "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic",
        "https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-ND-2.0",
        "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic",
        "https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-ND-2.5",
        "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic",
        "https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0-IGO",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO",
        "https://creativecommons.org/licenses/by-nc-nd/3.0/igo/legalcode",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported",
        "https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-ND-4.0",
        "Creative Commons Attribution Non Commercial No Derivatives 4.0 International",
        "https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-SA-1.0",
        "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic",
        "https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-SA-2.0",
        "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic",
        "https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-SA-2.5",
        "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic",
        "https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode",
        False,
    ),
    (
        "CC-BY-NC-SA-3.0",
        "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported",
        "https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode",
        False,
    ),
    (
        "CC-BY-NC-SA-4.0",
        "Creative Commons Attribution Non Commercial Share Alike 4.0 International",
        "https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode",
        False,
    ),
    (
        "CC-BY-SA-1.0",
        "Creative Commons Attribution Share Alike 1.0 Generic",
        "https://creativecommons.org/licenses/by-sa/1.0/legalcode",
        False,
    ),
    (
        "CC-BY-SA-2.0-UK",
        "Creative Commons Attribution Share Alike 2.0 England and Wales",
        "https://creativecommons.org/licenses/by-sa/2.0/uk/legalcode",
        False,
    ),
    (
        "CC-BY-SA-2.0",
        "Creative Commons Attribution Share Alike 2.0 Generic",
        "https://creativecommons.org/licenses/by-sa/2.0/legalcode",
        False,
    ),
    (
        "CC-BY-SA-2.5",
        "Creative Commons Attribution Share Alike 2.5 Generic",
        "https://creativecommons.org/licenses/by-sa/2.5/legalcode",
        False,
    ),
    (
        "CC-BY-SA-3.0",
        "Creative Commons Attribution Share Alike 3.0 Unported",
        "https://creativecommons.org/licenses/by-sa/3.0/legalcode",
        False,
    ),
    (
        "CC-BY-SA-4.0",
        "Creative Commons Attribution Share Alike 4.0 International",
        "https://creativecommons.org/licenses/by-sa/4.0/legalcode",
        True,
    ),
    (
        "CC-BY-SA-3.0-AT",
        "Creative Commons Attribution-Share Alike 3.0 Austria",
        "https://creativecommons.org/licenses/by-sa/3.0/at/legalcode",
        False,
    ),
    (
        "CC-PDDC",
        "Creative Commons Public Domain Dedication and Certification",
        "https://creativecommons.org/licenses/publicdomain/",
        False,
    ),
    (
        "CC0-1.0",
        "Creative Commons Zero v1.0 Universal",
        "https://creativecommons.org/publicdomain/zero/1.0/legalcode",
        True,
    ),
    (
        "Crossword",
        "Crossword License",
        "https://fedoraproject.org/wiki/Licensing/Crossword",
        False,
    ),
    (
        "CAL-1.0",
        "Cryptographic Autonomy License 1.0",
        "http://cryptographicautonomylicense.com/license-text.html",
        True,
    ),
    (
        "CAL-1.0-Combined-Work-Exception",
        "Cryptographic Autonomy License 1.0 (Combined Work Exception)",
        "http://cryptographicautonomylicense.com/license-text.html",
        True,
    ),
    (
        "CrystalStacker",
        "CrystalStacker License",
        "https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker",
        False,
    ),
    (
        "CUA-OPL-1.0",
        "CUA Office Public License v1.0",
        "https://opensource.org/licenses/CUA-OPL-1.0",
        True,
    ),
    ("Cube", "Cube License", "https://fedoraproject.org/wiki/Licensing/Cube", False),
    (
        "curl",
        "curl License",
        "https://github.com/bagder/curl/blob/master/COPYING",
        False,
    ),
    (
        "D-FSL-1.0",
        "Deutsche Freie Software Lizenz",
        "http://www.dipp.nrw.de/d-fsl/lizenzen/",
        False,
    ),
    (
        "diffmark",
        "diffmark license",
        "https://fedoraproject.org/wiki/Licensing/diffmark",
        False,
    ),
    (
        "WTFPL",
        "Do What The F*ck You Want To Public License",
        "http://www.wtfpl.net/about/",
        True,
    ),
    ("DOC", "DOC License", "http://www.cs.wustl.edu/~schmidt/ACE-copying.html", False),
    (
        "Dotseqn",
        "Dotseqn License",
        "https://fedoraproject.org/wiki/Licensing/Dotseqn",
        False,
    ),
    ("DSDP", "DSDP License", "https://fedoraproject.org/wiki/Licensing/DSDP", False),
    (
        "dvipdfm",
        "dvipdfm License",
        "https://fedoraproject.org/wiki/Licensing/dvipdfm",
        False,
    ),
    (
        "EPL-1.0",
        "Eclipse Public License 1.0",
        "http://www.eclipse.org/legal/epl-v10.html",
        True,
    ),
    (
        "EPL-2.0",
        "Eclipse Public License 2.0",
        "https://www.eclipse.org/legal/epl-2.0",
        True,
    ),
    (
        "ECL-1.0",
        "Educational Community License v1.0",
        "https://opensource.org/licenses/ECL-1.0",
        True,
    ),
    (
        "ECL-2.0",
        "Educational Community License v2.0",
        "https://opensource.org/licenses/ECL-2.0",
        True,
    ),
    (
        "eGenix",
        "eGenix.com Public License 1.1.0",
        "http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf",
        False,
    ),
    (
        "EFL-1.0",
        "Eiffel Forum License v1.0",
        "http://www.eiffel-nice.org/license/forum.txt",
        True,
    ),
    (
        "EFL-2.0",
        "Eiffel Forum License v2.0",
        "http://www.eiffel-nice.org/license/eiffel-forum-license-2.html",
        True,
    ),
    (
        "MIT-advertising",
        "Enlightenment License (e16)",
        "https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising",
        False,
    ),
    (
        "MIT-enna",
        "enna License",
        "https://fedoraproject.org/wiki/Licensing/MIT#enna",
        False,
    ),
    (
        "Entessa",
        "Entessa Public License v1.0",
        "https://opensource.org/licenses/Entessa",
        True,
    ),
    ("EPICS", "EPICS Open License", "https://epics.anl.gov/license/open.php", False),
    (
        "ErlPL-1.1",
        "Erlang Public License v1.1",
        "http://www.erlang.org/EPLICENSE",
        False,
    ),
    (
        "etalab-2.0",
        "Etalab Open License 2.0",
        "https://github.com/DISIC/politique-de-contribution-open-source/blob/master/LICENSE.pdf",
        False,
    ),
    (
        "EUDatagrid",
        "EU DataGrid Software License",
        "http://eu-datagrid.web.cern.ch/eu-datagrid/license.html",
        True,
    ),
    (
        "EUPL-1.0",
        "European Union Public License 1.0",
        "http://ec.europa.eu/idabc/en/document/7330.html",
        False,
    ),
    (
        "EUPL-1.1",
        "European Union Public License 1.1",
        "https://joinup.ec.europa.eu/software/page/eupl/licence-eupl",
        True,
    ),
    (
        "EUPL-1.2",
        "European Union Public License 1.2",
        "https://joinup.ec.europa.eu/page/eupl-text-11-12",
        True,
    ),
    (
        "Eurosym",
        "Eurosym License",
        "https://fedoraproject.org/wiki/Licensing/Eurosym",
        False,
    ),
    ("Fair", "Fair License", "http://fairlicense.org/", True),
    (
        "MIT-feh",
        "feh License",
        "https://fedoraproject.org/wiki/Licensing/MIT#feh",
        False,
    ),
    (
        "Frameworx-1.0",
        "Frameworx Open License 1.0",
        "https://opensource.org/licenses/Frameworx-1.0",
        True,
    ),
    (
        "FreeImage",
        "FreeImage Public License v1.0",
        "http://freeimage.sourceforge.net/freeimage-license.txt",
        False,
    ),
    (
        "FTL",
        "Freetype Project License",
        "http://freetype.fis.uniroma2.it/FTL.TXT",
        True,
    ),
    (
        "FSFAP",
        "FSF All Permissive License",
        "https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html",
        True,
    ),
    (
        "FSFUL",
        "FSF Unlimited License",
        "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License",
        False,
    ),
    (
        "FSFULLR",
        "FSF Unlimited License (with License Retention)",
        "https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant",
        False,
    ),
    (
        "Giftware",
        "Giftware License",
        "http://liballeg.org/license.html#allegro-4-the-giftware-license",
        False,
    ),
    ("GL2PS", "GL2PS License", "http://www.geuz.org/gl2ps/COPYING.GL2PS", False),
    (
        "Glulxe",
        "Glulxe License",
        "https://fedoraproject.org/wiki/Licensing/Glulxe",
        False,
    ),
    (
        "AGPL-3.0-only",
        "GNU Affero General Public License v3.0 only",
        "https://www.gnu.org/licenses/agpl.txt",
        True,
    ),
    (
        "AGPL-3.0-or-later",
        "GNU Affero General Public License v3.0 or later",
        "https://www.gnu.org/licenses/agpl.txt",
        True,
    ),
    (
        "GFDL-1.1-only",
        "GNU Free Documentation License v1.1 only",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
        True,
    ),
    (
        "GFDL-1.1-invariants-only",
        "GNU Free Documentation License v1.1 only - invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
        False,
    ),
    (
        "GFDL-1.1-no-invariants-only",
        "GNU Free Documentation License v1.1 only - no invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
        False,
    ),
    (
        "GFDL-1.1-or-later",
        "GNU Free Documentation License v1.1 or later",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
        True,
    ),
    (
        "GFDL-1.1-invariants-or-later",
        "GNU Free Documentation License v1.1 or later - invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
        False,
    ),
    (
        "GFDL-1.1-no-invariants-or-later",
        "GNU Free Documentation License v1.1 or later - no invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
        False,
    ),
    (
        "GFDL-1.2-only",
        "GNU Free Documentation License v1.2 only",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
        True,
    ),
    (
        "GFDL-1.2-invariants-only",
        "GNU Free Documentation License v1.2 only - invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
        False,
    ),
    (
        "GFDL-1.2-no-invariants-only",
        "GNU Free Documentation License v1.2 only - no invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
        False,
    ),
    (
        "GFDL-1.2-or-later",
        "GNU Free Documentation License v1.2 or later",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
        True,
    ),
    (
        "GFDL-1.2-invariants-or-later",
        "GNU Free Documentation License v1.2 or later - invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
        False,
    ),
    (
        "GFDL-1.2-no-invariants-or-later",
        "GNU Free Documentation License v1.2 or later - no invariants",
        "https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
        False,
    ),
    (
        "GFDL-1.3-only",
        "GNU Free Documentation License v1.3 only",
        "https://www.gnu.org/licenses/fdl-1.3.txt",
        True,
    ),
    (
        "GFDL-1.3-invariants-only",
        "GNU Free Documentation License v1.3 only - invariants",
        "https://www.gnu.org/licenses/fdl-1.3.txt",
        False,
    ),
    (
        "GFDL-1.3-no-invariants-only",
        "GNU Free Documentation License v1.3 only - no invariants",
        "https://www.gnu.org/licenses/fdl-1.3.txt",
        False,
    ),
    (
        "GFDL-1.3-or-later",
        "GNU Free Documentation License v1.3 or later",
        "https://www.gnu.org/licenses/fdl-1.3.txt",
        True,
    ),
    (
        "GFDL-1.3-invariants-or-later",
        "GNU Free Documentation License v1.3 or later - invariants",
        "https://www.gnu.org/licenses/fdl-1.3.txt",
        False,
    ),
    (
        "GFDL-1.3-no-invariants-or-later",
        "GNU Free Documentation License v1.3 or later - no invariants",
        "https://www.gnu.org/licenses/fdl-1.3.txt",
        False,
    ),
    (
        "GPL-1.0-only",
        "GNU General Public License v1.0 only",
        "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html",
        False,
    ),
    (
        "GPL-1.0-or-later",
        "GNU General Public License v1.0 or later",
        "https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html",
        False,
    ),
    (
        "GPL-2.0-only",
        "GNU General Public License v2.0 only",
        "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html",
        True,
    ),
    (
        "GPL-2.0-or-later",
        "GNU General Public License v2.0 or later",
        "https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html",
        True,
    ),
    (
        "GPL-3.0-only",
        "GNU General Public License v3.0 only",
        "https://www.gnu.org/licenses/gpl-3.0-standalone.html",
        True,
    ),
    (
        "GPL-3.0-or-later",
        "GNU General Public License v3.0 or later",
        "https://www.gnu.org/licenses/gpl-3.0-standalone.html",
        True,
    ),
    (
        "LGPL-2.1-only",
        "GNU Lesser General Public License v2.1 only",
        "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html",
        True,
    ),
    (
        "LGPL-2.1-or-later",
        "GNU Lesser General Public License v2.1 or later",
        "https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html",
        True,
    ),
    (
        "LGPL-3.0-only",
        "GNU Lesser General Public License v3.0 only",
        "https://www.gnu.org/licenses/lgpl-3.0-standalone.html",
        True,
    ),
    (
        "LGPL-3.0-or-later",
        "GNU Lesser General Public License v3.0 or later",
        "https://www.gnu.org/licenses/lgpl-3.0-standalone.html",
        True,
    ),
    (
        "LGPL-2.0-only",
        "GNU Library General Public License v2 only",
        "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html",
        True,
    ),
    (
        "LGPL-2.0-or-later",
        "GNU Library General Public License v2 or later",
        "https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html",
        True,
    ),
    (
        "gnuplot",
        "gnuplot License",
        "https://fedoraproject.org/wiki/Licensing/Gnuplot",
        True,
    ),
    (
        "GLWTPL",
        "Good Luck With That Public License",
        "https://github.com/me-shaon/GLWTPL/commit/da5f6bc734095efbacb442c0b31e33a65b9d6e85",
        False,
    ),
    (
        "gSOAP-1.3b",
        "gSOAP Public License v1.3b",
        "http://www.cs.fsu.edu/~engelen/license.html",
        False,
    ),
    (
        "HaskellReport",
        "Haskell Language Report License",
        "https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License",
        False,
    ),
    (
        "Hippocratic-2.1",
        "Hippocratic License 2.1",
        "https://firstdonoharm.dev/version/2/1/license.html",
        False,
    ),
    (
        "HPND",
        "Historical Permission Notice and Disclaimer",
        "https://opensource.org/licenses/HPND",
        True,
    ),
    (
        "HPND-sell-variant",
        "Historical Permission Notice and Disclaimer - sell variant",
        "https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19",
        False,
    ),
    (
        "IBM-pibs",
        "IBM PowerPC Initialization and Boot Software",
        "http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d",
        False,
    ),
    (
        "IPL-1.0",
        "IBM Public License v1.0",
        "https://opensource.org/licenses/IPL-1.0",
        True,
    ),
    (
        "ICU",
        "ICU License",
        "http://source.icu-project.org/repos/icu/icu/trunk/license.html",
        False,
    ),
    (
        "ImageMagick",
        "ImageMagick License",
        "http://www.imagemagick.org/script/license.php",
        False,
    ),
    (
        "iMatix",
        "iMatix Standard Function Library Agreement",
        "http://legacy.imatix.com/html/sfl/sfl4.htm#license",
        True,
    ),
    (
        "Imlib2",
        "Imlib2 License",
        "http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING",
        True,
    ),
    (
        "IJG",
        "Independent JPEG Group License",
        "http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2",
        True,
    ),
    ("Info-ZIP", "Info-ZIP License", "http://www.info-zip.org/license.html", False),
    (
        "Intel-ACPI",
        "Intel ACPI Software License Agreement",
        "https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement",
        False,
    ),
    (
        "Intel",
        "Intel Open Source License",
        "https://opensource.org/licenses/Intel",
        True,
    ),
    (
        "Interbase-1.0",
        "Interbase Public License v1.0",
        "https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html",
        False,
    ),
    ("IPA", "IPA Font License", "https://opensource.org/licenses/IPA", True),
    (
        "ISC",
        "ISC License",
        "https://www.isc.org/downloads/software-support-policy/isc-license/",
        True,
    ),
    (
        "JPNIC",
        "Japan Network Information Center License",
        "https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366",
        False,
    ),
    (
        "JasPer-2.0",
        "JasPer License",
        "http://www.ece.uvic.ca/~mdadams/jasper/LICENSE",
        False,
    ),
    ("JSON", "JSON License", "http://www.json.org/license.html", False),
    (
        "LPPL-1.0",
        "LaTeX Project Public License v1.0",
        "http://www.latex-project.org/lppl/lppl-1-0.txt",
        False,
    ),
    (
        "LPPL-1.1",
        "LaTeX Project Public License v1.1",
        "http://www.latex-project.org/lppl/lppl-1-1.txt",
        False,
    ),
    (
        "LPPL-1.2",
        "LaTeX Project Public License v1.2",
        "http://www.latex-project.org/lppl/lppl-1-2.txt",
        True,
    ),
    (
        "LPPL-1.3a",
        "LaTeX Project Public License v1.3a",
        "http://www.latex-project.org/lppl/lppl-1-3a.txt",
        True,
    ),
    (
        "LPPL-1.3c",
        "LaTeX Project Public License v1.3c",
        "http://www.latex-project.org/lppl/lppl-1-3c.txt",
        True,
    ),
    (
        "Latex2e",
        "Latex2e License",
        "https://fedoraproject.org/wiki/Licensing/Latex2e",
        False,
    ),
    (
        "BSD-3-Clause-LBNL",
        "Lawrence Berkeley National Labs BSD variant license",
        "https://fedoraproject.org/wiki/Licensing/LBNLBSD",
        True,
    ),
    (
        "Leptonica",
        "Leptonica License",
        "https://fedoraproject.org/wiki/Licensing/Leptonica",
        False,
    ),
    (
        "LGPLLR",
        "Lesser General Public License For Linguistic Resources",
        "http://www-igm.univ-mlv.fr/~unitex/lgpllr.html",
        False,
    ),
    (
        "Libpng",
        "libpng License",
        "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt",
        False,
    ),
    (
        "libselinux-1.0",
        "libselinux public domain notice",
        "https://github.com/SELinuxProject/selinux/blob/master/libselinux/LICENSE",
        False,
    ),
    (
        "libtiff",
        "libtiff License",
        "https://fedoraproject.org/wiki/Licensing/libtiff",
        False,
    ),
    (
        "LAL-1.2",
        "Licence Art Libre 1.2",
        "http://artlibre.org/licence/lal/licence-art-libre-12/",
        False,
    ),
    ("LAL-1.3", "Licence Art Libre 1.3", "https://artlibre.org/", False),
    (
        "LiLiQ-P-1.1",
        "Licence Libre du Québec – Permissive version 1.1",
        "https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/",
        True,
    ),
    (
        "LiLiQ-Rplus-1.1",
        "Licence Libre du Québec – Réciprocité forte version 1.1",
        "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/",
        True,
    ),
    (
        "LiLiQ-R-1.1",
        "Licence Libre du Québec – Réciprocité version 1.1",
        "https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/",
        True,
    ),
    (
        "Linux-OpenIB",
        "Linux Kernel Variant of OpenIB.org license",
        "https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h",
        False,
    ),
    (
        "LPL-1.02",
        "Lucent Public License v1.02",
        "http://plan9.bell-labs.com/plan9/license.html",
        True,
    ),
    (
        "LPL-1.0",
        "Lucent Public License Version 1.0",
        "https://opensource.org/licenses/LPL-1.0",
        True,
    ),
    (
        "MakeIndex",
        "MakeIndex License",
        "https://fedoraproject.org/wiki/Licensing/MakeIndex",
        False,
    ),
    (
        "MTLL",
        "Matrix Template Library License",
        "https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License",
        False,
    ),
    (
        "MS-PL",
        "Microsoft Public License",
        "http://www.microsoft.com/opensource/licenses.mspx",
        True,
    ),
    (
        "MS-RL",
        "Microsoft Reciprocal License",
        "http://www.microsoft.com/opensource/licenses.mspx",
        True,
    ),
    (
        "MITNFA",
        "MIT +no-false-attribs license",
        "https://fedoraproject.org/wiki/Licensing/MITNFA",
        False,
    ),
    ("MIT", "MIT License", "https://opensource.org/licenses/MIT", True),
    ("MIT-0", "MIT No Attribution", "https://github.com/aws/mit-0", True),
    ("Motosoto", "Motosoto License", "https://opensource.org/licenses/Motosoto", True),
    (
        "MPL-1.0",
        "Mozilla Public License 1.0",
        "http://www.mozilla.org/MPL/MPL-1.0.html",
        True,
    ),
    (
        "MPL-1.1",
        "Mozilla Public License 1.1",
        "http://www.mozilla.org/MPL/MPL-1.1.html",
        True,
    ),
    ("MPL-2.0", "Mozilla Public License 2.0", "http://www.mozilla.org/MPL/2.0/", True),
    (
        "MPL-2.0-no-copyleft-exception",
        "Mozilla Public License 2.0 (no copyleft exception)",
        "http://www.mozilla.org/MPL/2.0/",
        True,
    ),
    ("mpich2", "mpich2 License", "https://fedoraproject.org/wiki/Licensing/MIT", False),
    (
        "MulanPSL-1.0",
        "Mulan Permissive Software License, Version 1",
        "https://license.coscl.org.cn/MulanPSL/",
        False,
    ),
    (
        "MulanPSL-2.0",
        "Mulan Permissive Software License, Version 2",
        "https://license.coscl.org.cn/MulanPSL2/",
        True,
    ),
    ("Multics", "Multics License", "https://opensource.org/licenses/Multics", True),
    ("Mup", "Mup License", "https://fedoraproject.org/wiki/Licensing/Mup", False),
    (
        "NASA-1.3",
        "NASA Open Source Agreement 1.3",
        "http://ti.arc.nasa.gov/opensource/nosa/",
        True,
    ),
    ("Naumen", "Naumen Public License", "https://opensource.org/licenses/Naumen", True),
    (
        "NBPL-1.0",
        "Net Boolean Public License v1",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894",
        False,
    ),
    (
        "Net-SNMP",
        "Net-SNMP License",
        "http://net-snmp.sourceforge.net/about/license.html",
        False,
    ),
    (
        "NetCDF",
        "NetCDF license",
        "http://www.unidata.ucar.edu/software/netcdf/copyright.html",
        False,
    ),
    (
        "NGPL",
        "Nethack General Public License",
        "https://opensource.org/licenses/NGPL",
        True,
    ),
    (
        "NOSL",
        "Netizen Open Source License",
        "http://bits.netizen.com.au/licenses/NOSL/nosl.txt",
        True,
    ),
    (
        "NPL-1.0",
        "Netscape Public License v1.0",
        "http://www.mozilla.org/MPL/NPL/1.0/",
        True,
    ),
    (
        "NPL-1.1",
        "Netscape Public License v1.1",
        "http://www.mozilla.org/MPL/NPL/1.1/",
        True,
    ),
    (
        "Newsletr",
        "Newsletr License",
        "https://fedoraproject.org/wiki/Licensing/Newsletr",
        False,
    ),
    (
        "NIST-PD",
        "NIST Public Domain Notice",
        "https://github.com/tcheneau/simpleRPL/blob/e645e69e38dd4e3ccfeceb2db8cba05b7c2e0cd3/LICENSE.txt",
        False,
    ),
    (
        "NIST-PD-fallback",
        "NIST Public Domain Notice with license fallback",
        "https://github.com/usnistgov/jsip/blob/59700e6926cbe96c5cdae897d9a7d2656b42abe3/LICENSE",
        False,
    ),
    (
        "NLPL",
        "No Limit Public License",
        "https://fedoraproject.org/wiki/Licensing/NLPL",
        False,
    ),
    (
        "Nokia",
        "Nokia Open Source License",
        "https://opensource.org/licenses/nokia",
        True,
    ),
    (
        "NCGL-UK-2.0",
        "Non-Commercial Government Licence",
        "https://github.com/spdx/license-list-XML/blob/master/src/Apache-2.0.xml",
        False,
    ),
    (
        "NPOSL-3.0",
        "Non-Profit Open Software License 3.0",
        "https://opensource.org/licenses/NOSL3.0",
        True,
    ),
    (
        "NLOD-1.0",
        "Norwegian Licence for Open Government Data",
        "http://data.norge.no/nlod/en/1.0",
        False,
    ),
    ("Noweb", "Noweb License", "https://fedoraproject.org/wiki/Licensing/Noweb", False),
    ("NRL", "NRL License", "http://web.mit.edu/network/isakmp/nrllicense.html", False),
    ("NTP", "NTP License", "https://opensource.org/licenses/NTP", True),
    (
        "NTP-0",
        "NTP No Attribution",
        "https://github.com/tytso/e2fsprogs/blob/master/lib/et/et_name.c",
        False,
    ),
    (
        "OCLC-2.0",
        "OCLC Research Public License 2.0",
        "http://www.oclc.org/research/activities/software/license/v2final.htm",
        True,
    ),
    (
        "ODbL-1.0",
        "ODC Open Database License v1.0",
        "http://www.opendatacommons.org/licenses/odbl/1.0/",
        True,
    ),
    (
        "PDDL-1.0",
        "ODC Public Domain Dedication & License 1.0",
        "http://opendatacommons.org/licenses/pddl/1.0/",
        False,
    ),
    (
        "OGC-1.0",
        "OGC Software License, Version 1.0",
        "https://www.ogc.org/ogc/software/1.0",
        False,
    ),
    (
        "OCCT-PL",
        "Open CASCADE Technology Public License",
        "http://www.opencascade.com/content/occt-public-license",
        False,
    ),
    (
        "ODC-By-1.0",
        "Open Data Commons Attribution License v1.0",
        "https://opendatacommons.org/licenses/by/1.0/",
        False,
    ),
    (
        "OGL-Canada-2.0",
        "Open Government Licence - Canada",
        "https://open.canada.ca/en/open-government-licence-canada",
        False,
    ),
    (
        "OGL-UK-1.0",
        "Open Government Licence v1.0",
        "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/",
        False,
    ),
    (
        "OGL-UK-2.0",
        "Open Government Licence v2.0",
        "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/",
        False,
    ),
    (
        "OGL-UK-3.0",
        "Open Government Licence v3.0",
        "http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/",
        False,
    ),
    (
        "OGTSL",
        "Open Group Test Suite License",
        "http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt",
        True,
    ),
    (
        "OLDAP-2.2.2",
        "Open LDAP Public License 2.2.2",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188",
        False,
    ),
    (
        "OLDAP-1.1",
        "Open LDAP Public License v1.1",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f",
        False,
    ),
    (
        "OLDAP-1.2",
        "Open LDAP Public License v1.2",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7",
        False,
    ),
    (
        "OLDAP-1.3",
        "Open LDAP Public License v1.3",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1",
        False,
    ),
    (
        "OLDAP-1.4",
        "Open LDAP Public License v1.4",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941",
        False,
    ),
    (
        "OLDAP-2.0",
        "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea",
        False,
    ),
    (
        "OLDAP-2.0.1",
        "Open LDAP Public License v2.0.1",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e",
        False,
    ),
    (
        "OLDAP-2.1",
        "Open LDAP Public License v2.1",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715",
        False,
    ),
    (
        "OLDAP-2.2",
        "Open LDAP Public License v2.2",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3",
        False,
    ),
    (
        "OLDAP-2.2.1",
        "Open LDAP Public License v2.2.1",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e",
        False,
    ),
    (
        "OLDAP-2.3",
        "Open LDAP Public License v2.3",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3",
        True,
    ),
    (
        "OLDAP-2.4",
        "Open LDAP Public License v2.4",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386",
        False,
    ),
    (
        "OLDAP-2.5",
        "Open LDAP Public License v2.5",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf",
        False,
    ),
    (
        "OLDAP-2.6",
        "Open LDAP Public License v2.6",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205",
        False,
    ),
    (
        "OLDAP-2.7",
        "Open LDAP Public License v2.7",
        "http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2",
        True,
    ),
    (
        "OLDAP-2.8",
        "Open LDAP Public License v2.8",
        "http://www.openldap.org/software/release/license.html",
        True,
    ),
    (
        "OML",
        "Open Market License",
        "https://fedoraproject.org/wiki/Licensing/Open_Market_License",
        False,
    ),
    (
        "OPL-1.0",
        "Open Public License v1.0",
        "http://old.koalateam.com/jackaroo/OPL_1_0.TXT",
        False,
    ),
    (
        "OSL-1.0",
        "Open Software License 1.0",
        "https://opensource.org/licenses/OSL-1.0",
        True,
    ),
    (
        "OSL-1.1",
        "Open Software License 1.1",
        "https://fedoraproject.org/wiki/Licensing/OSL1.1",
        True,
    ),
    (
        "OSL-2.0",
        "Open Software License 2.0",
        "http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html",
        True,
    ),
    (
        "OSL-2.1",
        "Open Software License 2.1",
        "http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm",
        True,
    ),
    (
        "OSL-3.0",
        "Open Software License 3.0",
        "https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm",
        True,
    ),
    (
        "O-UDA-1.0",
        "Open Use of Data Agreement v1.0",
        "https://github.com/microsoft/Open-Use-of-Data-Agreement/blob/v1.0/O-UDA-1.0.md",
        False,
    ),
    ("OpenSSL", "OpenSSL License", "http://www.openssl.org/source/license.html", True),
    (
        "OSET-PL-2.1",
        "OSET Public License version 2.1",
        "http://www.osetfoundation.org/public-license",
        True,
    ),
    ("PHP-3.0", "PHP License v3.0", "http://www.php.net/license/3_0.txt", True),
    ("PHP-3.01", "PHP License v3.01", "http://www.php.net/license/3_01.txt", True),
    (
        "Plexus",
        "Plexus Classworlds License",
        "https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License",
        False,
    ),
    (
        "libpng-2.0",
        "PNG Reference Library version 2",
        "http://www.libpng.org/pub/png/src/libpng-LICENSE.txt",
        False,
    ),
    (
        "PolyForm-Noncommercial-1.0.0",
        "PolyForm Noncommercial License 1.0.0",
        "https://polyformproject.org/licenses/noncommercial/1.0.0",
        False,
    ),
    (
        "PolyForm-Small-Business-1.0.0",
        "PolyForm Small Business License 1.0.0",
        "https://polyformproject.org/licenses/small-business/1.0.0",
        False,
    ),
    (
        "PostgreSQL",
        "PostgreSQL License",
        "http://www.postgresql.org/about/licence",
        True,
    ),
    (
        "psfrag",
        "psfrag License",
        "https://fedoraproject.org/wiki/Licensing/psfrag",
        False,
    ),
    (
        "psutils",
        "psutils License",
        "https://fedoraproject.org/wiki/Licensing/psutils",
        False,
    ),
    (
        "Python-2.0",
        "Python License 2.0",
        "https://opensource.org/licenses/Python-2.0",
        True,
    ),
    (
        "PSF-2.0",
        "Python Software Foundation License 2.0",
        "https://opensource.org/licenses/Python-2.0",
        False,
    ),
    (
        "QPL-1.0",
        "Q Public License 1.0",
        "http://doc.qt.nokia.com/3.3/license.html",
        True,
    ),
    ("Qhull", "Qhull License", "https://fedoraproject.org/wiki/Licensing/Qhull", False),
    (
        "Rdisc",
        "Rdisc License",
        "https://fedoraproject.org/wiki/Licensing/Rdisc_License",
        False,
    ),
    (
        "RPSL-1.0",
        "RealNetworks Public Source License v1.0",
        "https://helixcommunity.org/content/rpsl",
        True,
    ),
    (
        "RPL-1.1",
        "Reciprocal Public License 1.1",
        "https://opensource.org/licenses/RPL-1.1",
        True,
    ),
    (
        "RPL-1.5",
        "Reciprocal Public License 1.5",
        "https://opensource.org/licenses/RPL-1.5",
        True,
    ),
    (
        "RHeCos-1.1",
        "Red Hat eCos Public License v1.1",
        "http://ecos.sourceware.org/old-license.html",
        False,
    ),
    (
        "RSCPL",
        "Ricoh Source Code Public License",
        "http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml",
        True,
    ),
    (
        "RSA-MD",
        "RSA Message-Digest License",
        "http://www.faqs.org/rfcs/rfc1321.html",
        False,
    ),
    ("Ruby", "Ruby License", "http://www.ruby-lang.org/en/LICENSE.txt", True),
    (
        "SAX-PD",
        "Sax Public Domain Notice",
        "http://www.saxproject.org/copying.html",
        False,
    ),
    (
        "Saxpath",
        "Saxpath License",
        "https://fedoraproject.org/wiki/Licensing/Saxpath_License",
        False,
    ),
    (
        "SCEA",
        "SCEA Shared Source License",
        "http://research.scea.com/scea_shared_source_license.html",
        False,
    ),
    (
        "SWL",
        "Scheme Widget Library (SWL) Software License Agreement",
        "https://fedoraproject.org/wiki/Licensing/SWL",
        False,
    ),
    (
        "SMPPL",
        "Secure Messaging Protocol Public License",
        "https://github.com/dcblake/SMP/blob/master/Documentation/License.txt",
        False,
    ),
    (
        "Sendmail",
        "Sendmail License",
        "http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf",
        False,
    ),
    (
        "Sendmail-8.23",
        "Sendmail License 8.23",
        "https://www.proofpoint.com/sites/default/files/sendmail-license.pdf",
        False,
    ),
    (
        "SSPL-1.0",
        "Server Side Public License, v 1",
        "https://www.mongodb.com/licensing/server-side-public-license",
        False,
    ),
    (
        "SGI-B-1.0",
        "SGI Free Software License B v1.0",
        "http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html",
        False,
    ),
    (
        "SGI-B-1.1",
        "SGI Free Software License B v1.1",
        "http://oss.sgi.com/projects/FreeB/",
        False,
    ),
    (
        "SGI-B-2.0",
        "SGI Free Software License B v2.0",
        "http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf",
        True,
    ),
    (
        "OFL-1.0",
        "SIL Open Font License 1.0",
        "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web",
        True,
    ),
    (
        "OFL-1.0-no-RFN",
        "SIL Open Font License 1.0 with no Reserved Font Name",
        "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web",
        False,
    ),
    (
        "OFL-1.0-RFN",
        "SIL Open Font License 1.0 with Reserved Font Name",
        "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web",
        False,
    ),
    (
        "OFL-1.1",
        "SIL Open Font License 1.1",
        "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web",
        True,
    ),
    (
        "OFL-1.1-no-RFN",
        "SIL Open Font License 1.1 with no Reserved Font Name",
        "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web",
        True,
    ),
    (
        "OFL-1.1-RFN",
        "SIL Open Font License 1.1 with Reserved Font Name",
        "http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web",
        True,
    ),
    (
        "SimPL-2.0",
        "Simple Public License 2.0",
        "https://opensource.org/licenses/SimPL-2.0",
        True,
    ),
    (
        "Sleepycat",
        "Sleepycat License",
        "https://opensource.org/licenses/Sleepycat",
        True,
    ),
    (
        "SNIA",
        "SNIA Public License 1.1",
        "https://fedoraproject.org/wiki/Licensing/SNIA_Public_License",
        False,
    ),
    (
        "SHL-0.5",
        "Solderpad Hardware License v0.5",
        "https://solderpad.org/licenses/SHL-0.5/",
        False,
    ),
    (
        "SHL-0.51",
        "Solderpad Hardware License, Version 0.51",
        "https://solderpad.org/licenses/SHL-0.51/",
        False,
    ),
    (
        "Spencer-86",
        "Spencer License 86",
        "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License",
        False,
    ),
    (
        "Spencer-94",
        "Spencer License 94",
        "https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License",
        False,
    ),
    (
        "Spencer-99",
        "Spencer License 99",
        "http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c",
        False,
    ),
    (
        "blessing",
        "SQLite Blessing",
        "https://www.sqlite.org/src/artifact/e33a4df7e32d742a?ln=4-9",
        False,
    ),
    (
        "SSH-OpenSSH",
        "SSH OpenSSH license",
        "https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/LICENCE#L10",
        False,
    ),
    (
        "SSH-short",
        "SSH short notice",
        "https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/pathnames.h",
        False,
    ),
    (
        "SMLNJ",
        "Standard ML of New Jersey License",
        "https://www.smlnj.org/license.html",
        True,
    ),
    (
        "SugarCRM-1.1.3",
        "SugarCRM Public License v1.1.3",
        "http://www.sugarcrm.com/crm/SPL",
        False,
    ),
    (
        "SISSL",
        "Sun Industry Standards Source License v1.1",
        "http://www.openoffice.org/licenses/sissl_license.html",
        True,
    ),
    (
        "SISSL-1.2",
        "Sun Industry Standards Source License v1.2",
        "http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html",
        False,
    ),
    (
        "SPL-1.0",
        "Sun Public License v1.0",
        "https://opensource.org/licenses/SPL-1.0",
        True,
    ),
    (
        "Watcom-1.0",
        "Sybase Open Watcom Public License 1.0",
        "https://opensource.org/licenses/Watcom-1.0",
        True,
    ),
    (
        "TAPR-OHL-1.0",
        "TAPR Open Hardware License v1.0",
        "https://www.tapr.org/OHL",
        False,
    ),
    ("TCL", "TCL/TK License", "http://www.tcl.tk/software/tcltk/license.html", False),
    (
        "TCP-wrappers",
        "TCP Wrappers License",
        "http://rc.quest.com/topics/openssh/license.php#tcpwrappers",
        False,
    ),
    (
        "TU-Berlin-1.0",
        "Technische Universitaet Berlin License 1.0",
        "https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT",
        False,
    ),
    (
        "TU-Berlin-2.0",
        "Technische Universitaet Berlin License 2.0",
        "https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt",
        False,
    ),
    ("MirOS", "The MirOS Licence", "https://opensource.org/licenses/MirOS", True),
    (
        "Parity-6.0.0",
        "The Parity Public License 6.0.0",
        "https://paritylicense.com/versions/6.0.0.html",
        False,
    ),
    (
        "Parity-7.0.0",
        "The Parity Public License 7.0.0",
        "https://paritylicense.com/versions/7.0.0.html",
        False,
    ),
    ("Unlicense", "The Unlicense", "https://unlicense.org/", True),
    ("TMate", "TMate Open Source License", "http://svnkit.com/license.html", False),
    (
        "TORQUE-1.1",
        "TORQUE v2.5+ Software License v1.1",
        "https://fedoraproject.org/wiki/Licensing/TORQUEv1.1",
        False,
    ),
    (
        "TOSL",
        "Trusster Open Source License",
        "https://fedoraproject.org/wiki/Licensing/TOSL",
        False,
    ),
    (
        "Unicode-DFS-2015",
        "Unicode License Agreement - Data Files and Software (2015)",
        "https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html",
        False,
    ),
    (
        "Unicode-DFS-2016",
        "Unicode License Agreement - Data Files and Software (2016)",
        "http://www.unicode.org/copyright.html",
        True,
    ),
    (
        "Unicode-TOU",
        "Unicode Terms of Use",
        "http://www.unicode.org/copyright.html",
        False,
    ),
    (
        "UPL-1.0",
        "Universal Permissive License v1.0",
        "https://opensource.org/licenses/UPL",
        True,
    ),
    (
        "NCSA",
        "University of Illinois/NCSA Open Source License",
        "http://otm.illinois.edu/uiuc_openSource",
        True,
    ),
    (
        "UCL-1.0",
        "Upstream Compatibility License v1.0",
        "https://opensource.org/licenses/UCL-1.0",
        True,
    ),
    ("Vim", "Vim License", "http://vimdoc.sourceforge.net/htmldoc/uganda.html", True),
    (
        "VOSTROM",
        "VOSTROM Public License for Open Source",
        "https://fedoraproject.org/wiki/Licensing/VOSTROM",
        False,
    ),
    (
        "VSL-1.0",
        "Vovida Software License v1.0",
        "https://opensource.org/licenses/VSL-1.0",
        True,
    ),
    (
        "W3C-20150513",
        "W3C Software Notice and Document License (2015-05-13)",
        "https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document",
        False,
    ),
    (
        "W3C-19980720",
        "W3C Software Notice and License (1998-07-20)",
        "http://www.w3.org/Consortium/Legal/copyright-software-19980720.html",
        False,
    ),
    (
        "W3C",
        "W3C Software Notice and License (2002-12-31)",
        "http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html",
        True,
    ),
    (
        "Wsuipa",
        "Wsuipa License",
        "https://fedoraproject.org/wiki/Licensing/Wsuipa",
        False,
    ),
    ("Xnet", "X.Net License", "https://opensource.org/licenses/Xnet", True),
    ("X11", "X11 License", "http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3", True),
    ("Xerox", "Xerox License", "https://fedoraproject.org/wiki/Licensing/Xerox", False),
    (
        "XFree86-1.1",
        "XFree86 License 1.1",
        "http://www.xfree86.org/current/LICENSE4.html",
        True,
    ),
    (
        "xinetd",
        "xinetd License",
        "https://fedoraproject.org/wiki/Licensing/Xinetd_License",
        True,
    ),
    ("xpp", "XPP License", "https://fedoraproject.org/wiki/Licensing/xpp", False),
    (
        "XSkat",
        "XSkat License",
        "https://fedoraproject.org/wiki/Licensing/XSkat_License",
        False,
    ),
    (
        "YPL-1.0",
        "Yahoo! Public License v1.0",
        "http://www.zimbra.com/license/yahoo_public_license_1.0.html",
        False,
    ),
    (
        "YPL-1.1",
        "Yahoo! Public License v1.1",
        "http://www.zimbra.com/license/yahoo_public_license_1.1.html",
        True,
    ),
    ("Zed", "Zed License", "https://fedoraproject.org/wiki/Licensing/Zed", False),
    (
        "Zend-2.0",
        "Zend License v2.0",
        "https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt",
        True,
    ),
    (
        "Zimbra-1.3",
        "Zimbra Public License v1.3",
        "http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html",
        True,
    ),
    (
        "Zimbra-1.4",
        "Zimbra Public License v1.4",
        "http://www.zimbra.com/legal/zimbra-public-license-1-4",
        False,
    ),
    ("Zlib", "zlib License", "http://www.zlib.net/zlib_license.html", True),
    (
        "zlib-acknowledgement",
        "zlib/libpng License with Acknowledgement",
        "https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement",
        False,
    ),
    (
        "ZPL-1.1",
        "Zope Public License 1.1",
        "http://old.zope.org/Resources/License/ZPL-1.1",
        False,
    ),
    (
        "ZPL-2.0",
        "Zope Public License 2.0",
        "http://old.zope.org/Resources/License/ZPL-2.0",
        True,
    ),
    ("ZPL-2.1", "Zope Public License 2.1", "http://old.zope.org/Resources/ZPL/", True),
)
