# Python SDK for Buenbit public API

This client library is designed to interact with [Buenbit's](https://app.buenbit.com) public API. 
It can be used to fetch market data, placing orders and manage investments.

## Installation

    $ pip install buenbit

## Getting started

This SDK is build on top of [requests-openapi](https://github.com/wy-z/requests-openapi) which creates an HTTP client 
from buenbit's [openapi specification](). It uses the Python library 
[Requests](https://requests.readthedocs.io/en/master/) underneath. 
The client generates dynamically a method for each API endpoint operation exposed in the spec. 
You make HTTP requests by doing Python methods calls in the form of `client.operation_id(operation_parameters)`.

```python    
from buenbit import BuenbitApiClient
client = BuenbitApiClient.new_with(api_key=<YOUR_API_KEY>, api_secret=<YOUR_API_SECRET>)
response = client.get_investment_status(currency='dai')
response.status_code  # 200
dai_investment_status = response.json()['object']
dai_investment_status  # {'object': {'is_investing': True, 'aggregated_interests': '0.0', ...}, 'errors': []}
```

To see all defined operations you can do `client.operations` 

## Examples
You can find more examples in `examples.py`

### Get market tickers
Get bid/ask prices for each market:

```python 
response = client.market_tickers()
response.status_code  # 200
response_json = response.json()  # {"object": {"daiars": {"ask_currency": "ars", "bid_currency":"dai", "purchase_price":"... 
market_tickers = response_json['object']

daiars_market = market_tickers['daiars']
daiars_market['ask_currency']  # 'ars'
daiars_market['bid_currency']  # 'dai'
daiars_market['purchase_price']  # '119.5'
daiars_market['selling_price']  # '124.1'
```

### Place order
Create an order for a market
    
```python 
market_identifier = 'daiars'
volume = '5'
operation = 'buy'

request_body = {'market_identifier': market_identifier, 'volume': volume}
response = self.client.create_order(operation=operation, data=request_body)
response.status_code  # 201
response_json = response.json()  # {'object': {'side': 'buy', 'volume': '5.00', 'created_at': '07/08/2020 18:07',...}, 'errors': []}
```
