# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ciphey',
 'ciphey.basemods',
 'ciphey.basemods.Checkers',
 'ciphey.basemods.Crackers',
 'ciphey.basemods.Decoders',
 'ciphey.basemods.Resources',
 'ciphey.basemods.Searchers',
 'ciphey.iface']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'base58>=2.0.1,<3.0.0',
 'base91>=1.0.1,<2.0.0',
 'cipheycore>=0.3.1,<0.4.0',
 'cipheydists>=0.3.22,<0.4.0',
 'click-spinner>=0.1.10,<0.2.0',
 'click>=7.1.2,<8.0.0',
 'flake8>=3.8.2,<4.0.0',
 'loguru>=0.5.0,<0.6.0',
 'pybase62>=0.4.3,<0.5.0',
 'pylint>=2.5.2,<3.0.0',
 'pyyaml>=5.3.1,<6.0.0',
 'rich>=4,<7',
 'yaspin>=0.17,<1.1']

extras_require = \
{':python_version >= "3.7" and python_version < "3.8"': ['typing_inspect>=0.6.0,<0.7.0']}

entry_points = \
{'console_scripts': ['ciphey = ciphey.ciphey:main']}

setup_kwargs = {
    'name': 'ciphey',
    'version': '5.5.1',
    'description': 'Automated Decryption Tool',
    'long_description': '<p align="center">\nTranslations <br>\n<a href=https://github.com/Ciphey/Ciphey/tree/master/translations/id/README.md>🇮🇩 ID   </a>\n<a href=https://github.com/Ciphey/Ciphey/tree/master/translations/de/README.md>🇩🇪 DE   </a>\n <br><br>\n➡️ \n<a href="https://github.com/Ciphey/Ciphey/wiki">Documentation</a> |\n<a href="https://discord.ciphey.online">Discord</a> |\n <a href="https://github.com/Ciphey/Ciphey/wiki/Installation">Installation Guide</a>\n ⬅️\n\n<br>\n  <img src="Pictures_for_README/binoculars.png" alt="Ciphey">\n</p>\n\n<p align="center">\n  <img alt="GitHub commit activity" src="https://img.shields.io/github/commit-activity/m/ciphey/ciphey">\n<img src="https://pepy.tech/badge/ciphey">\n <img src="https://pepy.tech/badge/ciphey/month">\n  <a href="https://discord.gg/wM3scnc"><img alt="Discord" src="https://img.shields.io/discord/728245678895136898"></a>\n<a href="https://pypi.org/project/ciphey/"><img src="https://img.shields.io/pypi/v/ciphey.svg"></a>\n  <img src="https://img.shields.io/badge/License-MIT-yellow.svg" alt="Ciphey">\n\n  \n  <img src="https://github.com/brandonskerritt/Ciphey/workflows/Python%20application/badge.svg?branch=master" alt="Ciphey">\n<br>\nFully automated decryption/decoding/cracking tool using natural language processing & artificial intelligence, along with some common sense.\n</p>\n<hr>\n\n## [Installation Guide](https://github.com/Ciphey/Ciphey/wiki/Installation)\n\n| <p align="center"><a href="https://pypi.org/project/ciphey">🐍 Python | <p align="center"><a href="https://pypi.org/project/ciphey">🐋 Docker (Universal) |\n| --------------------------- | ---------------------------------|\n| <p align="center"><img src="Pictures_for_README/python.png" /></p> | <p align="center"><img src="Pictures_for_README/docker.png" /></p> |\n| `python3 -m pip install ciphey --upgrade`  | `docker run -it --rm remnux/ciphey` | \n\n\n| Linux       | Mac OS | Windows     |\n| ----------- | ------ | ----------- |\n| ![GitHub Workflow Status](https://img.shields.io/github/workflow/status/ciphey/ciphey/Python%20application?label=Linux) |![GitHub Workflow Status](https://img.shields.io/github/workflow/status/ciphey/ciphey/Python%20application?label=Mac%20OS) | ![GitHub Workflow Status](https://img.shields.io/github/workflow/status/ciphey/ciphey/Python%20application?label=Windows) |\n  \n\n<hr>\n\n# 🤔 What is this?\nInput encrypted text, get the decrypted text back.\n\n> "What type of encryption?"\n\nThat\'s the point. You don\'t know, you just know it\'s possibly encrypted. Ciphey will figure it out for you.\n\nCiphey can solve most things in 3 seconds or less.\n\n<p align="center" href="https://asciinema.org/a/336257">\n  <img src="Pictures_for_README/index.gif" alt="Ciphey demo">\n</p>\n\nCiphey aims to be a tool to automate a lot of decryptions & decodings such as multiple base encodings, classical ciphers, hashes or more advanced cryptography. \n\nIf you don\'t know much about cryptography, or you want to quickly check the ciphertext before working on it yourself, Ciphey is for you.\n\n**The technical part.** Ciphey uses a custom built artificial intelligence module (_AuSearch_) with a _Cipher Detection Interface_ to approximate what something is encrypted with. And then a custom-built, customisable natural language processing _Language Checker Interface_, which can detect when the given text becomes plaintext.\n\nNo neural networks or bloated AI here. We only use what is fast and minimal.\n\nAnd that\'s just the tip of the iceberg. For the full technical explanation, check out our [documentation](https://github.com/Ciphey/Ciphey/wiki).\n\n# ✨ Features\n\n- **30+ encryptions supported** such as encodings (binary, base64) and normal encryptions like Caesar cipher, repeating-key XOR and more. **[For the full list, click here](https://github.com/Ciphey/Ciphey/wiki/Supported-Ciphers)**\n- **Custom Built Artificial Intelligence with Augmented Search (AuSearch) for answering the question "what encryption was used?"** Resulting in decryptions taking less than 3 seconds. \n- **Custom built natural language processing module** Ciphey can determine whether something is plaintext or not. Whether that plaintext is JSON, a CTF flag or English Ciphey can get it in a couple of milliseconds.\n- **Multi Language Support** at present, only German & English (with AU, UK, CAN, USA variants).\n- **Supports encryptions and hashes** Which the alternatives such as CyberChef Magic do not. \n- **[C++ core](https://github.com/Ciphey/CipheyCore)** Blazingly fast.\n\n# 🔭 Ciphey vs CyberChef\n\n## 🔁 Base64 Encoded 42 times\n\n<table>\n  <tr>\n  <th>Name</th>\n    <th>⚡ Ciphey ⚡ </th>\n    <th>🐢 CyberChef 🐢</th>\n  </tr>\n  <tr>\n  <th>Gif</th>\n    <td><img src="Pictures_for_README/ciphey_gooder_cyberchef.gif" alt="The guy she tells you not to worry about"></td>\n    <td><img src="Pictures_for_README/not_dying.gif" alt="You"></td>\n  </tr>\n  <tr>\n  <th>Time</th>\n    <td>2 seconds</td>\n    <td>6 seconds</td>\n  </tr>\n    <tr>\n  <th>Setup</th>\n    <td><ul><li>Run ciphey on the file</li></ul></td>\n    <td><ul><li>Set the regex param to "{"</li><li>You need to know how many times to recurse</li><li>You need to know it\'s Base64 all the way down</li><li>You need to load CyberChef (it\'s a bloated JS app)</li><li>Know enough about CyberChef to create this pipeline</li><li>Invert the match</li></ul></td>\n  </tr>\n</table>\n\n\n<sub><b>Note</b> The gifs may load at different times, so one may appear significantly faster than another.</sub><br>\n<sub><b>A note on magic </b>CyberChef\'s most similar feature to Ciphey is Magic. Magic fails instantly on this input and crashes. The only way we could force CyberChef to compete was to manually define it.</sub>\n\n\nWe also tested CyberChef and Ciphey with a **6gb file**. Ciphey cracked it in **5 minutes and 54 seconds**. CyberChef crashed before it even started.\n\n\n\n## 📊 Ciphey vs Katana vs CyberChef Magic\n\n| **Name**                                   | ⚡ Ciphey ⚡ | 🗡️ Katana 🗡️ | 🐢 CyberChef Magic 🐢 |\n| ------------------------------------------ | ---------- | ---------- | ------------------- |\n| Advanced Language Checker                   | ✅          | ❌          | ✅                   |\n| Supports Encryptions                       | ✅          | ✅          | ❌                   |\n| Releases named after Dystopian themes 🌃    | ✅          | ❌          | ❌                   |\n| Supports hashes                            | ✅          | ✅          | ❌                   |\n| Easy to set up                             | ✅          | ❌          | ✅                   |\n| Can guess what something is encrypted with | ✅          | ❌          | ❌                   |\n| Created for hackers by hackers             | ✅          | ✅          | ❌                   |\n\n# 🎬 Getting Started\n\nIf you\'re having trouble with installing Ciphey, [read this.](https://github.com/Ciphey/Ciphey/wiki/Common-Issues-&-Their-Solutions)\n\n## ‼️ Important Links (Docs, Installation guide, Discord Support)\n\n| Installation Guide | Documentation | Discord | Docker Image (from REMnux)\n| ------------------ | ------------- | ------- | ------- | \n| 📖 [Installation Guide](https://github.com/Ciphey/Ciphey/wiki/Installation) | 📚 [Documentation](https://github.com/Ciphey/Ciphey/wiki) | 🦜 [Discord](https://discord.ciphey.online) | 🐋 [Docker Documentation](https://docs.remnux.org/run-tools-in-containers/remnux-containers#ciphey)\n\n## 🏃\u200d♀️Running Ciphey\nThere are 3 ways to run Ciphey.\n1. File Input `ciphey -f encrypted.txt`\n2. Unqualified input `ciphey -- "Encrypted input"`\n3. Normal way `ciphey -t "Encrypted input"`\n\n![Gif showing 3 ways to run Ciphey](Pictures_for_README/3ways.gif)\n\nTo get rid of the progress bars, probability table, and all the noise use the quiet mode.\n\n```ciphey -t "encrypted text here" -q```\n\nFor a full list of arguments, run `ciphey --help`.\n\n### ⚗️ Importing Ciphey\nYou can import Ciphey\\\'s main and use it in your own programs and code. `from Ciphey.__main__ import main`\n\n# 🎪 Contributors\nCiphey was invented by [Brandon](https://github.com/bee-san) in 2008, and revived in 2019. Ciphey wouldn\'t be where it was today without [Cyclic3](https://github.com/Cyclic3) - president of UoL\'s Cyber Security Society.\n\nCiphey was revived & recreated by the [Cyber Security Society](https://www.cybersoc.cf/) for use in CTFs. If you\'re ever in Liverpool, consider giving a talk or sponsoring our events. Email us at `cybersecurity@society.liverpoolguild.org` to find out more 🤠\n\n**Major Credit** to George H for working out how we could use proper algorithms to speed up the search process.\n**Special thanks** to [varghalladesign](https://www.facebook.com/varghalladesign) for designing the logo. Check out their other design work!\n\n## 🐕\u200d🦺 [Contributing](https://github.com/Ciphey/Ciphey/wiki/Contributing)\nDon\'t be afraid to contribute! We have many, many things you can do to help out. Each of them labelled and easily explained with examples. If you\'re trying to contribute but stuck, tag @bee-san or @cyclic3 in the GitHub issue ✨\n\nAlternatively, join the Discord group and send a message there (link in [contrib file](https://github.com/Ciphey/Ciphey/wiki/Contributing)) or at the top of this README as a badge.\n\nPlease read the [contributing file](https://github.com/Ciphey/Ciphey/wiki/Contributing) for exact details on how to contribute ✨\n\nBy doing so, you\'ll get your name added to the README below and get to be apart of an ever-growing project!\n[![Stargazers over time](https://starchart.cc/Ciphey/Ciphey.svg)](https://starchart.cc/Ciphey/Ciphey)\n## 💰 Financial Contributors\nThe contributions will be used to fund not only the future of Ciphey and its authors, but also Cyber Security Society at the University of Liverpool.\n\nGitHub doesn\'t support "sponsor this project and we\'ll evenly distribute the money", so pick a link and we\'ll sort it out on our end 🥰\n\n## ✨ Contributors\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://github.com/Cyclic3"><img src="https://avatars1.githubusercontent.com/u/15613874?v=4" width="100px;" alt=""/><br /><sub><b>cyclic3</b></sub></a><br /><a href="#design-cyclic3" title="Design">🎨</a> <a href="#maintenance-cyclic3" title="Maintenance">🚧</a> <a href="https://github.com/Ciphey/Ciphey/commits?author=cyclic3" title="Code">💻</a> <a href="#ideas-cyclic3" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://skerritt.blog"><img src="https://avatars3.githubusercontent.com/u/10378052?v=4" width="100px;" alt=""/><br /><sub><b>Brandon</b></sub></a><br /><a href="#design-brandonskerritt" title="Design">🎨</a> <a href="#maintenance-brandonskerritt" title="Maintenance">🚧</a> <a href="https://github.com/Ciphey/Ciphey/commits?author=brandonskerritt" title="Code">💻</a> <a href="#ideas-brandonskerritt" title="Ideas, Planning, & Feedback">🤔</a></td>\n    <td align="center"><a href="https://github.com/michalani"><img src="https://avatars0.githubusercontent.com/u/27767884?v=4" width="100px;" alt=""/><br /><sub><b>michalani</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/commits?author=michalani" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/ashb07"><img src="https://avatars2.githubusercontent.com/u/24845568?v=4" width="100px;" alt=""/><br /><sub><b>ashb07</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/commits?author=ashb07" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/TheAlcanian"><img src="https://avatars3.githubusercontent.com/u/22127191?v=4" width="100px;" alt=""/><br /><sub><b>Shardion</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/issues?q=author%3ATheAlcanian" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/Bryzizzle"><img src="https://avatars0.githubusercontent.com/u/57810197?v=4" width="100px;" alt=""/><br /><sub><b>Bryan</b></sub></a><br /><a href="#translation-Bryzizzle" title="Translation">🌍</a> <a href="https://github.com/Ciphey/Ciphey/commits?author=Bryzizzle" title="Documentation">📖</a></td>\n    <td align="center"><a href="https://lukasgabriel.net"><img src="https://avatars0.githubusercontent.com/u/52338810?v=4" width="100px;" alt=""/><br /><sub><b>Lukas Gabriel</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/commits?author=lukasgabriel" title="Code">💻</a> <a href="https://github.com/Ciphey/Ciphey/issues?q=author%3Alukasgabriel" title="Bug reports">🐛</a> <a href="#translation-lukasgabriel" title="Translation">🌍</a> <a href="#ideas-lukasgabriel" title="Ideas, Planning, & Feedback">🤔</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/DarshanBhoi"><img src="https://avatars2.githubusercontent.com/u/70128281?v=4" width="100px;" alt=""/><br /><sub><b>Darshan</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/issues?q=author%3ADarshanBhoi" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/SkeletalDemise"><img src="https://avatars1.githubusercontent.com/u/29117662?v=4" width="100px;" alt=""/><br /><sub><b>SkeletalDemise</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/commits?author=SkeletalDemise" title="Code">💻</a></td>\n    <td align="center"><a href="https://www.patreon.com/cclauss"><img src="https://avatars3.githubusercontent.com/u/3709715?v=4" width="100px;" alt=""/><br /><sub><b>Christian Clauss</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/commits?author=cclauss" title="Code">💻</a> <a href="https://github.com/Ciphey/Ciphey/issues?q=author%3Acclauss" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="http://machinexa.xss.ht"><img src="https://avatars1.githubusercontent.com/u/60662297?v=4" width="100px;" alt=""/><br /><sub><b>Machinexa2</b></sub></a><br /><a href="#content-machinexa2" title="Content">🖋</a></td>\n    <td align="center"><a href="https://github.com/anantverma275"><img src="https://avatars1.githubusercontent.com/u/18184503?v=4" width="100px;" alt=""/><br /><sub><b>Anant Verma</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/commits?author=anantverma275" title="Code">💻</a> <a href="https://github.com/Ciphey/Ciphey/issues?q=author%3Aanantverma275" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/XVXTOR"><img src="https://avatars1.githubusercontent.com/u/40268197?v=4" width="100px;" alt=""/><br /><sub><b>XVXTOR</b></sub></a><br /><a href="https://github.com/Ciphey/Ciphey/commits?author=XVXTOR" title="Documentation">📖</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-enable -->\n<!-- prettier-ignore-end -->\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!\n',
    'author': 'Brandon',
    'author_email': 'brandon@skerritt.blog',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
