# coding=utf-8

from __future__ import unicode_literals

from spacy.symbols import (  # type: ignore
    ADJ,
    ADP,
    ADV,
    AUX,
    CCONJ,
    DET,
    INTJ,
    NOUN,
    NUM,
    PART,
    POS,
    PRON,
    PROPN,
    PUNCT,
    SPACE,
    SYM,
    VERB,
)

TAG_MAP = {
    "名詞,普通名詞": {POS: NOUN},
    "名詞,サ変名詞": {POS: NOUN},
    "名詞,固有名詞": {POS: PROPN},
    "名詞,地名": {POS: PROPN},
    "名詞,人名": {POS: PROPN},
    "名詞,組織名": {POS: PROPN},
    "名詞,数詞": {POS: NUM},
    "名詞,形式名詞": {POS: NOUN},
    "名詞,副詞的名詞": {POS: NOUN},
    "名詞,時相名詞": {POS: NOUN},
    "指示詞,名詞形態指示詞": {POS: PRON},
    "指示詞,連体詞形態指示詞": {POS: DET},
    "指示詞,副詞形態指示詞": {POS: ADV},
    "動詞,*": {POS: VERB},
    "形容詞,*": {POS: ADJ},
    "判定詞,*": {POS: AUX},
    "助動詞,*": {POS: AUX},
    "副詞,*": {POS: ADV},
    "助詞,格助詞": {POS: ADP},
    "助詞,副助詞": {POS: ADP},
    "助詞,接続助詞": {POS: ADP},
    "助詞,終助詞": {POS: PART},
    "接続詞,*": {POS: CCONJ},
    "連体詞,*": {POS: DET},
    "感動詞,*": {POS: INTJ},
    "接頭辞,名詞接頭辞": {POS: NOUN},
    "接頭辞,動詞接頭辞": {POS: ADV},
    "接頭辞,イ形容詞接頭辞": {POS: PART},
    "接頭辞,ナ形容詞接頭辞": {POS: PART},
    "接尾辞,名詞性名詞接尾辞": {POS: NOUN},
    "接尾辞,名詞性述語接尾辞": {POS: NOUN},
    "接尾辞,名詞性名詞助数辞": {POS: NOUN},
    "接尾辞,名詞性特殊接尾辞": {POS: NOUN},
    "接尾辞,形容詞性述語接尾辞": {POS: AUX},
    "接尾辞,形容詞性名詞接尾辞": {POS: PART},
    "接尾辞,動詞性接尾辞": {POS: AUX},
    "特殊,句点": {POS: PUNCT},
    "特殊,読点": {POS: PUNCT},
    "特殊,括弧始": {POS: PUNCT},
    "特殊,括弧終": {POS: PUNCT},
    "特殊,記号": {POS: PUNCT},
    "特殊,空白": {POS: SPACE},
    "未定義語,カタカナ": {POS: NOUN},
    "未定義語,アルファベット": {POS: SYM},
    "未定義語,その他": {POS: SYM},
}
