/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.Function1;
import scala.collection.AbstractIterator;
import scala.collection.BitSet;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.SortedSet;
import scala.collection.SortedSetOps;
import scala.collection.SpecificIterableFactory;
import scala.collection.immutable.Range;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;

public interface BitSetOps<C extends BitSet & BitSetOps<C>>
extends SortedSetOps<Object, SortedSet, C> {
    public SpecificIterableFactory<Object, C> bitSetFactory();

    @Override
    default public Ordering<Object> ordering() {
        return Ordering$Int$.MODULE$;
    }

    public int nwords();

    public long word(int var1);

    @Override
    default public Iterator<Object> iterator() {
        return this.iteratorFrom(0);
    }

    default public Iterator<Object> iteratorFrom(int start) {
        return new AbstractIterator<Object>(this, start){
            private int currentPos;
            private long currentWord;
            private final /* synthetic */ BitSetOps $outer;

            public final boolean hasNext() {
                while (this.currentWord == 0L) {
                    if (this.currentPos + 1 >= this.$outer.nwords()) {
                        return false;
                    }
                    ++this.currentPos;
                    this.currentWord = this.$outer.word(this.currentPos);
                }
                return true;
            }

            public final int next() {
                if (this.hasNext()) {
                    int bitPos = Long.numberOfTrailingZeros(this.currentWord);
                    this.currentWord &= this.currentWord - 1L;
                    return (this.currentPos << 6) + bitPos;
                }
                return BoxesRunTime.unboxToInt(Iterator$.scala$collection$Iterator$$_empty.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentPos = start$1 > 0 ? start$1 >> 6 : 0;
                this.currentWord = start$1 > 0 ? $outer.word(this.currentPos) & -1L << (start$1 & 0x3F) : $outer.word(0);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public int size() {
        void var1_1;
        int s = 0;
        int i = this.nwords();
        while (i > 0) {
            s += Long.bitCount(this.word(--i));
        }
        return (int)var1_1;
    }

    @Override
    default public boolean isEmpty() {
        int n = 0;
        int until$extension_end = this.nwords();
        return new Range.Exclusive(n, until$extension_end, 1).forall(i -> this.word(i) == 0L);
    }

    @Override
    default public <U> void foreach(Function1<Object, U> f) {
        for (int i = 0; i < this.nwords(); ++i) {
            long w = this.word(i);
            int j = i * 64;
            while (w != 0L) {
                if ((w & 1L) == 1L) {
                    f.apply(j);
                }
                w >>>= 1;
                ++j;
            }
        }
    }
}

