/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.AbstractIterator;
import scala.collection.AbstractView;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.View$;
import scala.collection.immutable.Seq;

public interface View<A>
extends Serializable,
Iterable<A> {
    public static /* synthetic */ IterableFactory iterableFactory$(View $this) {
        return $this.iterableFactory();
    }

    @Override
    default public IterableFactory<View> iterableFactory() {
        return View$.MODULE$;
    }

    public static /* synthetic */ View empty$(View $this) {
        return $this.empty();
    }

    @Override
    default public View<A> empty() {
        return this.iterableFactory().empty();
    }

    public static /* synthetic */ String toString$(View $this) {
        return $this.toString();
    }

    @Override
    default public String toString() {
        return new StringBuilder(16).append(this.className()).append("(<not computed>)").toString();
    }

    public static /* synthetic */ String stringPrefix$(View $this) {
        return $this.stringPrefix();
    }

    @Override
    default public String stringPrefix() {
        return "View";
    }

    public static class Appended<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final A elem;

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(this.underlying, new Single<A>(this.elem)).iterator();
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return size + 1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public Appended(IterableOps<A, ?, Object> underlying, A elem) {
            this.underlying = underlying;
            this.elem = elem;
        }
    }

    public static class Concat<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> prefix;
        private final IterableOps<A, ?, Object> suffix;

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<A> iterator() {
            void $plus$plus_xs;
            Iterator iterator = this.prefix.iterator();
            Function0<Iterator> & Serializable intersect = (Function0<Iterator> & Serializable)() -> $this.suffix.iterator();
            if (iterator == null) {
                throw null;
            }
            return iterator.concat($plus$plus_xs);
        }

        @Override
        public int knownSize() {
            int prefixSize = this.prefix.knownSize();
            if (prefixSize >= 0) {
                int suffixSize = this.suffix.knownSize();
                if (suffixSize >= 0) {
                    return prefixSize + suffixSize;
                }
                return -1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.prefix.isEmpty() && this.suffix.isEmpty();
        }

        public Concat(IterableOps<A, ?, Object> prefix, IterableOps<A, ?, Object> suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }
    }

    public static class Drop<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().drop(this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                int n = size - this.normN();
                int max$extension_that = 0;
                return Math.max(n, max$extension_that);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Drop(IterableOps<A, ?, Object> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            int max$extension_that = 0;
            this.normN = Math.max(n, max$extension_that);
        }
    }

    public static class Elems<A>
    extends AbstractView<A> {
        private final Seq<A> xs;

        @Override
        public Iterator<A> iterator() {
            return this.xs.iterator();
        }

        @Override
        public int knownSize() {
            return this.xs.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.xs.isEmpty();
        }

        public Elems(Seq<A> xs) {
            this.xs = xs;
        }
    }

    public static class Filter<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;
        private final boolean isFlipped;

        public IterableOps<A, ?, Object> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        public boolean isFlipped() {
            return this.isFlipped;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().filterImpl(this.p(), this.isFlipped());
        }

        @Override
        public int knownSize() {
            if (this.underlying().knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Filter(IterableOps<A, ?, Object> underlying, Function1<A, Object> p, boolean isFlipped) {
            this.underlying = underlying;
            this.p = p;
            this.isFlipped = isFlipped;
        }
    }

    public static class Map<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, B> f;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().map(this.f);
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public Map(IterableOps<A, ?, Object> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
        }
    }

    public static class Single<A>
    extends AbstractView<A> {
        private final A a;

        @Override
        public Iterator<A> iterator() {
            A single_a = this.a;
            return new AbstractIterator<A>(single_a){
                private boolean consumed;
                private final Object a$1;

                public boolean hasNext() {
                    return !this.consumed;
                }

                public A next() {
                    if (this.consumed) {
                        return (A)Iterator$.scala$collection$Iterator$$_empty.next();
                    }
                    this.consumed = true;
                    return (A)this.a$1;
                }

                public Iterator<A> sliceIterator(int from, int until) {
                    if (this.consumed || from > 0 || until == 0) {
                        return Iterator$.scala$collection$Iterator$$_empty;
                    }
                    return this;
                }
                {
                    this.a$1 = a$1;
                    this.consumed = false;
                }
            };
        }

        @Override
        public int knownSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public Single(A a) {
            this.a = a;
        }
    }

    public static class Take<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().take(this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                int min$extension_that = this.normN();
                return Math.min(size, min$extension_that);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Take(IterableOps<A, ?, Object> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            int max$extension_that = 0;
            this.normN = Math.max(n, max$extension_that);
        }
    }

    public static class Updated<A>
    extends AbstractView<A> {
        public final IterableOps<A, ?, Object> scala$collection$View$Updated$$underlying;
        public final int scala$collection$View$Updated$$index;
        public final A scala$collection$View$Updated$$elem;

        @Override
        public Iterator<A> iterator() {
            return new AbstractIterator<A>(this){
                private final Iterator<A> it;
                private int i;
                private final /* synthetic */ Updated $outer;

                /*
                 * WARNING - void declaration
                 */
                public A next() {
                    void var1_1;
                    A a;
                    if (this.i == this.$outer.scala$collection$View$Updated$$index) {
                        this.it.next();
                        a = this.$outer.scala$collection$View$Updated$$elem;
                    } else {
                        a = this.it.next();
                    }
                    A value = a;
                    ++this.i;
                    return var1_1;
                }

                public boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (this.$outer.scala$collection$View$Updated$$index >= this.i) {
                        throw new IndexOutOfBoundsException(Integer.toString(this.$outer.scala$collection$View$Updated$$index));
                    }
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.it = $outer.scala$collection$View$Updated$$underlying.iterator();
                    this.i = 0;
                }
            };
        }

        @Override
        public int knownSize() {
            return this.scala$collection$View$Updated$$underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Updated(IterableOps<A, ?, Object> underlying, int index, A elem) {
            this.scala$collection$View$Updated$$underlying = underlying;
            this.scala$collection$View$Updated$$index = index;
            this.scala$collection$View$Updated$$elem = elem;
        }
    }
}

